/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import java.util.Arrays;
import org.lsst.ccs.drivers.agilent.PowerSupply;

public class Device {
    public static final int MYDEV0_DID = 0;
    private static final int N_DIDS = 1;
    private static final int[] pids = new int[1];
    private static final int MY_PID = 1638;
    private static final int MAX_CHANNELS = 4;
    private int devId = -1;
    private channelList[] channels = new channelList[4];

    public void init(String hostname, int channelNumber, int powerOnOrder, double voltage, double currLimit) throws Exception {
        if (hostname.length() <= 0) {
            throw new Exception("Null hostname");
        }
        if (channelNumber < 0 || channelNumber > 4) {
            throw new Exception("Invalid channel number");
        }
        this.channels[channelNumber] = new channelList(hostname, channelNumber, powerOnOrder);
        this.channels[channelNumber].voltage = voltage;
        this.channels[channelNumber].currentLimit = currLimit;
    }

    public PowerSupply getChannel(int channelNumber) throws Exception {
        return this.channels[channelNumber].power;
    }

    public double chanVoltage(int channelNumber) throws Exception {
        return this.channels[channelNumber].power.getVoltage();
    }

    public void powerOn() {
        Arrays.sort(this.channels);
        for (int idx = 0; idx < this.channels.length; ++idx) {
            channelList chan = this.channels[idx];
            PowerSupply pwr = chan.power;
            pwr.mode(0);
            pwr.currentLimit(chan.currentLimit);
            pwr.setVoltage(chan.voltage);
            pwr.on();
        }
    }

    public void powerOff() {
        Arrays.sort(this.channels);
        for (int idx = this.channels.length - 1; idx >= 0; --idx) {
            channelList chan = this.channels[idx];
            PowerSupply pwr = chan.power;
            pwr.off();
        }
    }

    static {
        Device.pids[0] = 0;
    }

    private class channelList
    implements Comparable<channelList> {
        public double voltage = 0.0;
        public double currentLimit = 0.0;
        public int powerOnOrder = 0;
        public PowerSupply power = null;

        public channelList(String hostname, int channelNumber, int powerOnOrder) {
            this.powerOnOrder = powerOnOrder;
            this.power = new PowerSupply(hostname, channelNumber + 1);
        }

        @Override
        public int compareTo(channelList other) {
            return this.powerOnOrder - other.powerOnOrder;
        }
    }
}

