/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.BfrDevicePT;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class VpcControlPT
implements HasLifecycle {
    private static final String VPC = "Vpc";
    private static final Map<Integer, Integer> heaterChans = new HashMap<Integer, Integer>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskServices;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private BfrDevicePT bfrDevc;
    @ConfigurationParameter(category="Vpc", maxLength=2, isFinal=true, units="Celsius", description="Heater turn-on temperature differences")
    private volatile double[] deltaTemps = new double[0];
    @ConfigurationParameter(category="Vpc", isFinal=true, units="ms", description="Control loop update time")
    private volatile Integer updateTime = Integer.MAX_VALUE;
    private String[] refTempChans;
    private String[] ctrlTempChans;
    private final List<Channel> refTempChanList = new ArrayList<Channel>();
    private final List<Channel> ctrlTempChanList = new ArrayList<Channel>();
    private static final Logger LOG;
    private boolean active = false;
    private boolean loopFailedRef = false;
    private boolean loopFailedCtrl = false;
    private boolean loopFailedHtr = false;
    private long lastLoopTime;

    public void build() {
        AgentPeriodicTask apt = new AgentPeriodicTask("vpc-loop-" + this.name, () -> this.iterateLoop()).withPeriod(Duration.ofMillis(500L));
        this.periodicTaskServices.scheduleAgentPeriodicTask(apt);
    }

    public void init() {
        Channel cmpt;
        if (this.bfrDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"BfrDevice component", (String)"is missing");
        }
        if (this.refTempChans == null || this.refTempChans.length == 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"refTempChans", (String)"is missing or empty");
        } else {
            for (String cName : this.refTempChans) {
                cmpt = this.allChannels.get(cName);
                if (cmpt != null) {
                    this.refTempChanList.add(cmpt);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"refTempChans", (String)"contains non-Channel item");
            }
        }
        if (this.ctrlTempChans == null || this.ctrlTempChans.length == 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ctrlTempChans", (String)"is missing or empty");
        } else {
            for (String cName : this.ctrlTempChans) {
                cmpt = this.allChannels.get(cName);
                if (cmpt != null) {
                    this.ctrlTempChanList.add(cmpt);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ctrlTempChans", (String)"contains non-Channel item");
            }
        }
        if (this.deltaTemps.length != 2) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"deltaTemps", (String)"must be of length 2");
        }
        if (this.updateTime == Integer.MAX_VALUE) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"updateTime", (String)"is missing");
        }
    }

    public void setDeltaTemp(int heater, double temp) throws UtilityException {
        this.deltaTemps[heater] = temp;
    }

    public double getDeltaTemp(int heater) {
        return this.deltaTemps[heater];
    }

    public void startLoop() throws UtilityException {
        this.active = true;
    }

    public void stopLoop() throws UtilityException {
        this.active = false;
    }

    public boolean isLoopActive() {
        return this.active;
    }

    private void iterateLoop() {
        double value;
        if (!this.active) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time < this.lastLoopTime + (long)this.updateTime.intValue()) {
            return;
        }
        this.lastLoopTime = time;
        double refTemp = 0.0;
        double ctrlTemp = 0.0;
        int count = 0;
        for (Channel tempChan : this.refTempChanList) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            refTemp += value;
            ++count;
        }
        if (count > 0) {
            refTemp /= (double)count;
        } else {
            if (!this.loopFailedRef) {
                LOG.severe("Control loop iteration failed: no valid reference temperature values available");
                this.loopFailedRef = true;
            }
            return;
        }
        this.loopFailedRef = false;
        count = 0;
        for (Channel tempChan : this.ctrlTempChanList) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            ctrlTemp += value;
            ++count;
        }
        if (count <= 0) {
            if (!this.loopFailedCtrl) {
                LOG.severe("Control loop iteration failed: no valid control temperature values available");
                this.loopFailedCtrl = true;
            }
            return;
        }
        this.loopFailedCtrl = false;
        if (!this.setHeaters(refTemp - (ctrlTemp /= (double)count))) {
            if (!this.loopFailedHtr) {
                LOG.severe("Control loop iteration failed: heaters are offline");
                this.loopFailedHtr = true;
            }
            return;
        }
        this.loopFailedHtr = false;
    }

    private boolean setHeaters(double deltaTemp) {
        for (int htrId = 0; htrId < 2; ++htrId) {
            int htrChan = heaterChans.get(htrId);
            Boolean htrOn = this.bfrDevc.isSwitchOn(htrChan);
            if (htrOn == null) {
                return false;
            }
            if (deltaTemp > this.deltaTemps[htrId]) {
                if (htrOn.booleanValue()) continue;
                this.bfrDevc.switchOn(htrChan);
                continue;
            }
            if (!(deltaTemp <= 0.0) || !htrOn.booleanValue()) continue;
            this.bfrDevc.switchOff(htrChan);
        }
        return true;
    }

    static {
        heaterChans.put(0, 0);
        heaterChans.put(1, 1);
        LOG = Logger.getLogger(VpcControlPT.class.getName());
    }
}

