/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;

public class MCMLockHandler
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(MCMLockHandler.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private MCMSubsystem subsystem;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLoginService loginService;
    @ConfigurationParameter(description="Userid to be used to lock subsystems", isFinal=true)
    private final String userId = "mcm";

    public void postStart() {
        this.loginService.login("mcm", "noCredentialsNeeded");
        Predicate stateChangeFilter = BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class);
    }

    @Command(type=Command.CommandType.ACTION, description="Attempt to lock all subsystems", level=0)
    public void lockAll() {
        LinkedHashMap<String, Exception> xx = new LinkedHashMap<String, Exception>(0);
        for (ControlledSubsystem agent2 : this.subsystem.getControlledSubsystems()) {
            try {
                agent2.lockAndSwitchToNormal(0);
            }
            catch (ExecutionException x2) {
                xx.put(agent2.getAgentName(), x2);
                LOG.log(Level.WARNING, "Failed to lock or switch to normal mode for agent: " + agent2, x2);
            }
        }
        if (!xx.isEmpty()) {
            StringBuilder sb = new StringBuilder("Failed to lock or switch to normal mode the following subsystems:\n");
            xx.forEach((agent, x) -> sb.append((String)agent).append(": ").append(x.getClass().getSimpleName()).append(": ").append(x.getMessage()).append("\n"));
            throw new RuntimeException(sb.toString(), (Throwable)xx.values().iterator().next());
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Show lock status of all syubsystems", level=0)
    public String showLocks() {
        ArrayList<String> result = new ArrayList<String>();
        for (ControlledSubsystem agent : this.subsystem.getControlledSubsystems()) {
            AgentLock lock;
            String target = agent.getAgentName();
            Object owner = agent.getLock() == null ? ((lock = this.agentLockService.getExistingLockForAgent(target)) == null ? "unlocked" : "locked by " + lock.getOwner()) : "locked";
            result.add(String.format("%s: %s", target, owner));
        }
        return result.stream().collect(Collectors.joining("\n"));
    }

    @Command(type=Command.CommandType.ACTION, description="Unlock all subsystems", level=0)
    public void unlockAll() throws UnauthorizedLockException, IOException {
        LinkedHashMap<String, Exception> xx = new LinkedHashMap<String, Exception>(0);
        for (ControlledSubsystem agent2 : this.subsystem.getControlledSubsystems()) {
            try {
                agent2.unlock();
            }
            catch (ExecutionException x2) {
                xx.put(agent2.getAgentName(), x2);
                LOG.log(Level.WARNING, "Failed to unlock agent: " + agent2, x2);
            }
        }
        if (!xx.isEmpty()) {
            StringBuilder sb = new StringBuilder("Failed to unlock the following subsystems:\n");
            xx.forEach((agent, x) -> sb.append((String)agent).append(": ").append(x.getClass().getSimpleName()).append(": ").append(x.getMessage()).append("\n"));
            throw new RuntimeException(sb.toString(), (Throwable)xx.values().iterator().next());
        }
    }
}

