/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.refrig.CompLimits;

public class CryoCompLimits
extends CompLimits {
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Phase separator temperature limit causing delayed compressor shutoff")
    private volatile double phaseSepTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="second", description="Time delay before excess phase separator temperature causes compressor shutoff")
    private volatile int phaseSepTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="psia", description="Discharge pressure difference limit inhibiting compressor startup")
    private volatile double pressDiffImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Low discharge temperature limit inhibiting compressor startup")
    private volatile double discTempLowImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="mm", description="Low oil level limit causing immediate compressor shutoff")
    private volatile double oilLevelImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Discharge temperature limit causing heater shutoff")
    private volatile double heaterTempLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="psia", description="Discharge pressure above which orifice valve is closed")
    private volatile double orificeOffPress;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="psia", description="Discharge pressure below which orifice valve is opened")
    private volatile double orificeOnPress;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="psia", description="Discharge pressure above which filter dryer warning is issued")
    private volatile double dryerCheckHighPress;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="psia", description="Suction pressure below which filter dryer warning is issued")
    private volatile double dryerCheckLowPress;

    @Override
    public void postInit() {
        super.postInit();
        this.limitData[0].delayTime = -1;
        this.limitData[4].immedLimit = Double.NaN;
        this.limitData[9].isLower = true;
        this.limitData[9].delayLimit = Double.NaN;
        this.limitData[8].delayLimit = Double.NaN;
        this.limitData[6].isLower = true;
        this.limitData[6].delayLimit = Double.NaN;
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayLimit(double value) {
        this.phaseSepTempDelayLimit = value;
        this.limitData[4].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayTime(int value) {
        this.phaseSepTempDelayTime = value;
        this.limitData[4].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempLowImmedLimit(double value) {
        this.discTempLowImmedLimit = value;
        this.limitData[9].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setPressDiffImmedLimit(double value) {
        this.pressDiffImmedLimit = value;
        this.limitData[8].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setOilLevelImmedLimit(double value) {
        this.oilLevelImmedLimit = value;
        this.limitData[6].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setHeaterTempLimit(double value) {
        this.heaterTempLimit = value;
        this.limitData[12].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setOrificeOffPress(double value) {
        this.orificeOffPress = value;
        this.limitData[14].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setOrificeOnPress(double value) {
        this.orificeOnPress = value;
        this.limitData[13].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDryerCheckHighPress(double value) {
        this.dryerCheckHighPress = value;
        this.limitData[15].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDryerCheckLowPress(double value) {
        this.dryerCheckLowPress = value;
        this.limitData[16].immedLimit = value;
    }
}

