/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm;

import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.utilities.logging.DailyRollingFileHandler;

public class LogBusModule
implements HasLifecycle,
LogMessageListener {
    private static final Logger LOG = Logger.getLogger(LogBusModule.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Agent mmm;

    public void postInit() {
        LogBusModuleFileHandler logBusFileHandler = new LogBusModuleFileHandler();
        LOG.setUseParentHandlers(false);
        LOG.addHandler((Handler)((Object)logBusFileHandler));
        this.mmm.getMessagingAccess().addLogMessageListener((LogMessageListener)this, BusMessageFilterFactory.messageOrigin(null));
    }

    public void onLogMessage(LogMessage msg) {
        Level msgLevel = Level.parse(msg.getLevel());
        LOG.log(msgLevel, "Log message from " + msg.getOriginAgentInfo().getName() + ": " + msg.getFormattedDetails());
    }

    private class LogBusModuleFileHandler
    extends DailyRollingFileHandler {
        private LogBusModuleFileHandler() {
        }
    }
}

