/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.util.Deque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.daq.ims.Store;

class ReadThread
extends Thread {
    private final Store store;
    private final Semaphore semaphore;
    private static final AtomicInteger n = new AtomicInteger(0);
    private final Deque<Store> stores;

    ReadThread(Runnable r, Deque<Store> stores, Semaphore semaphore) {
        super(r);
        this.setName("DAQ_read_thread_" + n.getAndAdd(1));
        this.setDaemon(true);
        this.stores = stores;
        this.store = stores.pop();
        this.semaphore = semaphore;
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            this.stores.addLast(this.store);
        }
    }

    public Store getStore() {
        return this.store;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }
}

