/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.guider.ClearParameters;
import org.lsst.ccs.daq.guider.Config;
import org.lsst.ccs.daq.guider.SeriesStatus;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.daq.ims.Camera;
import org.lsst.ccs.daq.ims.Catalog;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.DAQSourceChannelImplementation;
import org.lsst.ccs.daq.ims.Emulator;
import org.lsst.ccs.daq.ims.Guider;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.RegisterClient;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.StoreImplementation;
import org.lsst.ccs.daq.ims.StoreNativeImplementation;
import org.lsst.ccs.daq.ims.StoreSimulatedImplementation;
import org.lsst.ccs.daq.ims.StreamListener;
import org.lsst.ccs.daq.ims.Version;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class Store
implements AutoCloseable {
    private Camera camera;
    private Emulator emulator;
    private RegisterClient client;
    private Guider guider;
    private final Catalog catalog;
    private final String partition;
    private final long store;
    private final List<ImageListener> imageListeners = new CopyOnWriteArrayList<ImageListener>();
    private final Map<Long, Map<Integer, List<StreamListener>>> imageStreamMap = new ConcurrentHashMap<Long, Map<Integer, List<StreamListener>>>();
    private static final Logger LOG = Logger.getLogger(Store.class.getName());
    private static final int IMAGE_TIMEOUT_MICROS = Integer.getInteger("org.lsst.ccs.daq.ims.ImageTimeout", 1000000);
    private static final int SOURCE_TIMEOUT_MICROS = Integer.getInteger("org.lsst.ccs.daq.ims.SourceTimeout", 10000000);
    private static final StoreImplementation impl;
    private final ExecutorService executor;
    private Future<?> waitForImageTask;

    public Store(String partition) throws DAQException {
        this(partition, ForkJoinPool.commonPool());
    }

    public Store(String partition, ExecutorService executor) throws DAQException {
        this.partition = partition;
        this.executor = executor;
        this.catalog = new Catalog(this);
        this.store = impl.attachStore(partition);
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Camera getCamera() throws DAQException {
        Store store = this;
        synchronized (store) {
            if (this.camera == null) {
                long camera_ = impl.attachCamera(this.store);
                this.camera = new Camera(this, camera_);
            }
            return this.camera;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Guider getGuider() throws DAQException {
        Store store = this;
        synchronized (store) {
            if (this.guider == null) {
                long guider_ = impl.attachGuider(this.partition);
                this.guider = new Guider(this, guider_);
            }
            return this.guider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Emulator getEmulator() throws DAQException {
        Store store = this;
        synchronized (store) {
            if (this.emulator == null) {
                this.emulator = new Emulator(this);
            }
            return this.emulator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterClient getRegisterClient() throws DAQException {
        Store store = this;
        synchronized (store) {
            if (this.client == null) {
                long client_ = impl.attachClient(this.getPartition());
                this.client = new RegisterClient(this, client_);
            }
            return this.client;
        }
    }

    public String getPartition() {
        return this.partition;
    }

    public long getCapacity() throws DAQException {
        return impl.capacity(this.store);
    }

    public long getRemaining() throws DAQException {
        return impl.remaining(this.store);
    }

    public LocationSet getConfiguredSources() throws DAQException {
        BitSet locations = impl.getConfiguredSources(this.store);
        return new LocationSet(locations);
    }

    LocationSet getConfiguredLocations() throws DAQException {
        BitSet locations = impl.getConfiguredLocations(this.partition);
        return new LocationSet(locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener l) {
        this.imageListeners.add(l);
        Store store = this;
        synchronized (store) {
            if (this.waitForImageTask == null || this.waitForImageTask.isCancelled() || this.waitForImageTask.isDone()) {
                this.waitForImageTask = this.executor.submit(() -> {
                    Thread thisThread = Thread.currentThread();
                    String originalThreadName = thisThread.getName();
                    try {
                        thisThread.setName("ImageStreamThread_" + this.partition);
                        LOG.log(Level.INFO, () -> String.format("DAQ image listener starting with timeouts %,d\u03bcs %,d\u03bcs", IMAGE_TIMEOUT_MICROS, SOURCE_TIMEOUT_MICROS));
                        long waitForImageStore = impl.attachStore(this.partition);
                        long stream1 = 0L;
                        long stream2 = 0L;
                        try {
                            stream1 = impl.attachStream(this.store, SOURCE_TIMEOUT_MICROS);
                            stream2 = impl.attachStream(this.store, SOURCE_TIMEOUT_MICROS);
                            while (!this.waitForImageTask.isCancelled()) {
                                int rc = impl.waitForImage(this, waitForImageStore, stream1, stream2, IMAGE_TIMEOUT_MICROS, SOURCE_TIMEOUT_MICROS);
                                if (rc != 0 && rc != 68) {
                                    LOG.log(Level.SEVERE, "Unexpected rc from waitForImage: {0}", rc);
                                    continue;
                                }
                                LOG.log(Level.FINE, "waitForImage timeout with rc {0}, continuing to wait", rc);
                            }
                        }
                        finally {
                            if (stream1 != 0L) {
                                impl.detachStream(stream1);
                            }
                            if (stream2 != 0L) {
                                impl.detachStream(stream2);
                            }
                            impl.detachStore(waitForImageStore);
                        }
                    }
                    catch (Throwable x) {
                        LOG.log(Level.SEVERE, x, () -> String.format("Thread %s exiting", Thread.currentThread().getName()));
                    }
                    finally {
                        thisThread.setName(originalThreadName);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener l) {
        Store store = this;
        synchronized (store) {
            if (this.imageListeners.remove(l) && this.imageListeners.isEmpty()) {
                this.waitForImageTask.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageCreatedCallback(ImageMetaData meta) {
        Image image = new Image(this, meta);
        LOG.log(Level.INFO, "Image created: {0}", image);
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            this.imageStreamMap.put(image.getMetaData().getId(), new ConcurrentHashMap());
        }
        this.imageListeners.forEach(l -> l.imageCreated(image));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageCompleteCallback(ImageMetaData meta) {
        Map<Integer, List<StreamListener>> streamListeners;
        Image image = new Image(this, meta);
        LOG.log(Level.INFO, "Image complete: {0}", image);
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            streamListeners = this.imageStreamMap.remove(image.getMetaData().getId());
        }
        streamListeners.forEach((locationIndex, listeners) -> {
            try {
                SourceMetaData sourceMeta = this.findSource(meta.getId(), (int)locationIndex);
                listeners.forEach(l -> l.imageComplete(sourceMeta.getLength()));
            }
            catch (DAQException ex) {
                LOG.log(Level.SEVERE, "Exception during image complete callback", ex);
            }
        });
        this.imageListeners.forEach(l -> l.imageComplete(image));
    }

    void imageSourceStreamCallback(long imageId, int location, long length) {
        List<StreamListener> listeners;
        LOG.log(Level.FINE, "Image stream: imageId={0} location={1} length={2}", new Object[]{imageId, location, length});
        Map<Integer, List<StreamListener>> streamListeners = this.imageStreamMap.get(imageId);
        if (streamListeners != null && (listeners = streamListeners.get(location)) != null) {
            listeners.forEach(l -> l.streamLength(length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamListener(long imageId, int location, StreamListener listener) {
        Map<Integer, List<StreamListener>> streamListeners;
        Map<Long, Map<Integer, List<StreamListener>>> map = this.imageStreamMap;
        synchronized (map) {
            streamListeners = this.imageStreamMap.get(imageId);
        }
        if (streamListeners == null) {
            try {
                SourceMetaData sourceMeta = this.findSource(imageId, location);
                listener.imageComplete(sourceMeta.getLength());
            }
            catch (DAQException ex) {
                LOG.log(Level.SEVERE, "Unexpected exception while adding stream listener", ex);
            }
        } else {
            List<StreamListener> listeners = streamListeners.get(location);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<StreamListener>();
                streamListeners.put(location, listeners);
            }
            listeners.add(listener);
        }
    }

    void removeStreamListener(long imageId, int location, StreamListener listener) {
        List<StreamListener> listeners;
        Map<Integer, List<StreamListener>> streamListeners = this.imageStreamMap.get(imageId);
        if (streamListeners != null && (listeners = streamListeners.get(location)) != null) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DAQException {
        Store store = this;
        synchronized (store) {
            if (this.waitForImageTask != null && !this.waitForImageTask.isDone()) {
                boolean success = this.waitForImageTask.cancel(true);
                LOG.log(Level.FINE, "Store closed, waitForImageTask={0} {1}", new Object[]{success, this.waitForImageTask.isCancelled()});
            }
        }
        this.imageListeners.clear();
        if (this.camera != null) {
            this.camera.detach();
        }
        if (this.guider != null) {
            this.guider.detach();
        }
        if (this.client != null) {
            this.client.detach();
        }
        if (this.emulator != null) {
            this.emulator.detach();
        }
        impl.detachStore(this.store);
    }

    List<String> listFolders() throws DAQException {
        ArrayList<String> result = new ArrayList<String>();
        impl.listFolders(this.store, result);
        return result;
    }

    int insertFolder(String folderName) throws DAQException {
        return impl.insertFolder(this.store, folderName);
    }

    int removeFolder(String folderName) throws DAQException {
        return impl.removeFolder(this.store, folderName);
    }

    boolean findFolder(String folderName) throws DAQException {
        return impl.findFolder(this.store, folderName);
    }

    void listImages(String folderName, List<ImageMetaData> result) throws DAQException {
        impl.listImages(this.store, folderName, result);
    }

    int moveImageToFolder(long id, String folderName) throws DAQException {
        return impl.moveImageToFolder(this.store, id, folderName);
    }

    int deleteImage(long id) throws DAQException {
        return impl.deleteImage(this.store, id);
    }

    SourceMetaData findSource(long id, int location) throws DAQException {
        return impl.findSource(this.store, id, location);
    }

    ImageMetaData addImageToFolder(String imageName, String folderName, ImageMetaData meta) throws DAQException {
        return impl.addImageToFolder(this.store, imageName, folderName, meta.getAnnotation(), meta.getOpcode(), meta.getLocationBitSet());
    }

    ImageMetaData findImage(String imageName, String folderName) throws DAQException {
        return impl.findImage(this.store, imageName, folderName);
    }

    DAQSourceChannelImplementation openSourceChannel(long id, Location location, Source.ChannelMode mode) throws DAQException {
        return impl.openSourceChannelObject(this.store, id, location.index(), mode == Source.ChannelMode.WRITE);
    }

    SourceMetaData addSourceToImage(long id, Location location, int[] registerValues) throws DAQException {
        return impl.addSourceToImage(this.store, id, location.index(), (byte)location.type().getCCDCount(), "test-platform", registerValues);
    }

    ImageMetaData triggerImage(long camera, ImageMetaData meta) throws DAQException {
        return impl.triggerImage(this.store, camera, meta);
    }

    long startSequencer(long camera, int opcode) throws DAQException {
        return impl.startSequencer(camera, opcode);
    }

    public static Version getClientVersion() throws DAQException {
        return impl.getClientVersion();
    }

    public String getClientPlatform() throws DAQException {
        return impl.getClientPlatform(this.partition);
    }

    static String decodeException(int rc) {
        return impl.decodeException(rc);
    }

    void detachCamera(long camera) throws DAQException {
        impl.detachCamera(camera);
    }

    void setRegisterList(long camera, Location.LocationType rebType, int[] registerAddresses) throws DAQException {
        impl.setRegisterList(this.store, camera, rebType, registerAddresses);
    }

    void detachClient(long client) throws DAQException {
        impl.detachClient(client);
    }

    int[][] readRegisters(long client, BitSet locations, int[] addresses) throws DAQException {
        return impl.readRegisters(client, locations, addresses);
    }

    void writeRegisters(long client, BitSet locations, int[] addresses, int[] values) throws DAQException {
        impl.writeRegisters(client, locations, addresses, values);
    }

    long getStore() {
        return this.store;
    }

    public void simulateTrigger(Location location, ImageMetaData meta, int[] registerList, Path rawData) throws DAQException {
        if (!(impl instanceof StoreSimulatedImplementation)) {
            throw new UnsupportedOperationException("Only supported for simulated DAQ");
        }
        ((StoreSimulatedImplementation)impl).simulateTrigger(meta, location, registerList, rawData);
    }

    void detachGuider(long guider) throws DAQException {
        impl.detachGuider(guider);
    }

    Status stopGuider(long guider, String comment) throws DAQException {
        return impl.stopGuider(guider, comment);
    }

    Status resumeGuider(long guider, String comment) throws DAQException {
        return impl.resumeGuider(guider, comment);
    }

    Status pauseGuider(long guider, String comment) throws DAQException {
        return impl.pauseGuider(guider, comment);
    }

    Status sleepGuider(long guider) throws DAQException {
        return impl.sleepGuider(guider);
    }

    Status wakeGuider(long guider) throws DAQException {
        return this.wakeGuider(guider, ClearParameters.defaultValue());
    }

    Status wakeGuider(long guider, ClearParameters clearParameters) throws DAQException {
        return impl.wakeGuider(guider, clearParameters.getDelay(), clearParameters.getPreRows(), clearParameters.getFlushCount(), clearParameters.getReadRows(), clearParameters.getPostRows(), clearParameters.getOverRows());
    }

    Status startGuider(long guider, int nRows, int nCols, int integrationTimeMilliSeconds, int overRows, int underCols, int overCols, int flushCount, String id, int[] roiData) throws DAQException {
        return impl.startGuider(guider, nRows, nCols, integrationTimeMilliSeconds, overRows, underCols, overCols, flushCount, id, roiData);
    }

    void validateGuider(long guider, int nRows, int nCols, int integrationTimeMilliSeconds, int[] roiData) throws DAQException {
        impl.validateGuider(guider, nRows, nCols, integrationTimeMilliSeconds, roiData);
    }

    long attachGuiderSubscriber(String partition, boolean bigEndian, int[] locations) throws DAQException {
        return impl.attachGuiderSubscriber(partition, bigEndian, locations);
    }

    void detachGuiderSubscriber(long subscriber) throws DAQException {
        impl.detachGuiderSubscriber(subscriber);
    }

    void waitForGuider(long subscriber, Guider.Subscriber callback) throws DAQException {
        impl.waitForGuider(subscriber, callback);
    }

    void abortWaitForGuider(long subscriber) throws DAQException {
        impl.abortWaitForGuider(subscriber);
    }

    Config guiderConfig(long guider) throws DAQException {
        return impl.guiderConfig(guider);
    }

    SeriesStatus guiderSeries(long guider) throws DAQException {
        return impl.guiderSeries(guider);
    }

    public Status clearGuider(long guider, ClearParameters clearParameters) throws DAQException {
        return impl.clearGuider(guider, clearParameters.getDelay(), clearParameters.getPreRows(), clearParameters.getFlushCount(), clearParameters.getReadRows(), clearParameters.getPostRows(), clearParameters.getOverRows());
    }

    static {
        String runMode = System.getProperty("org.lsst.ccs.run.mode");
        if (runMode != null) {
            LOG.log(Level.INFO, "runMode={0}", runMode);
        }
        impl = "simulation".equals(runMode) ? new StoreSimulatedImplementation() : new StoreNativeImplementation();
    }
}

