/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.classes;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;

public abstract class DataProviderInfoUtils {
    private static final Set<Pattern> trendingExclusions = new HashSet<Pattern>();
    private static final Pattern runtimeInfoPattern = Pattern.compile("runtimeInfo/.*");
    private static final Set<String> CONFIGURATION_ATTRIBUTES;
    private static final Set<String> TELEMETRY_ATTRIBUTES;

    public static String getCategory(DataProviderInfo dpi) {
        String cat = dpi.getAttributeValue(DataProviderInfo.Attribute.CONFIG_CATEGORY);
        cat = cat == null ? "" : cat;
        String dataType = dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
        if ("TRENDING".equals(dataType)) {
            cat = "Trending";
        }
        return cat;
    }

    public static boolean acceptData(DataProviderInfo dpi, XMLMaker2.SALType salType) {
        if (!DataProviderInfoUtils.acceptDataType(dpi, salType)) {
            return false;
        }
        String path = dpi.getFullPath();
        if (runtimeInfoPattern.matcher(path).matches()) {
            return false;
        }
        return DataProviderInfoUtils.acceptDataProviderInfo(dpi);
    }

    public static boolean acceptDataProviderInfo(DataProviderInfo dpi) {
        if (dpi.getAttributeValue(DataProviderInfo.Attribute.DO_NOT_TREND) != null) {
            return false;
        }
        String originalPathName = dpi.getFullPath();
        if (DataProviderInfoUtils.exludePath(originalPathName)) {
            return false;
        }
        String units = dpi.getAttributeValue(DataProviderInfo.Attribute.UNITS);
        if (units != null && units.equalsIgnoreCase("DAC Counts")) {
            return false;
        }
        String cat = DataProviderInfoUtils.getCategory(dpi);
        if ("Rafts".equals(cat) && dpi.getFullPath().endsWith("useScienceCCD")) {
            return false;
        }
        if (cat.equals("InfluxDb")) {
            return false;
        }
        String lowerCaseVarName = dpi.getFullPath().toLowerCase();
        return !lowerCaseVarName.contains("rebstate") && !lowerCaseVarName.contains("tripstate");
    }

    public static boolean acceptDataType(DataProviderInfo dpi, XMLMaker2.SALType salType) {
        Set<String> attributeTypes = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? CONFIGURATION_ATTRIBUTES : TELEMETRY_ATTRIBUTES;
        String dataType = dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
        return attributeTypes.contains(dataType);
    }

    private static boolean exludePath(String path) {
        for (Pattern exclude : trendingExclusions) {
            if (!exclude.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        trendingExclusions.add(Pattern.compile(".*endSetFilter.*"));
        trendingExclusions.add(Pattern.compile(".*startSetFilter.*"));
        CONFIGURATION_ATTRIBUTES = Collections.singleton(DataProviderInfo.Type.CONFIGURATION.name());
        TELEMETRY_ATTRIBUTES = new HashSet<String>();
        TELEMETRY_ATTRIBUTES.add(DataProviderInfo.Type.MONITORING.name());
        TELEMETRY_ATTRIBUTES.add(DataProviderInfo.Type.TRENDING.name());
    }
}

