/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.gpio;

import java.util.List;
import org.lsst.ccs.drivers.commons.DriverException;

public abstract class GPIODriver {
    public abstract List<? extends GPIOChip> enumerateChips() throws DriverException;

    public abstract List<? extends GPIOChannel> enumerateExportedChannels() throws DriverException;

    public abstract GPIOChannel getChannel(int var1) throws DriverException;

    public abstract boolean isExported(int var1);

    public abstract GPIOChannel export(int var1) throws DriverException;

    public abstract List<? extends GPIOChannel> exportRange(int var1, int var2) throws DriverException;

    public abstract void unexport(int var1) throws DriverException;

    public abstract void unexportRange(int var1, int var2) throws DriverException;

    public class GPIOChip {
        private final int base;
        private final int ngpio;
        private final String name;
        private final String label;

        protected GPIOChip(int base, int ngpio, String name, String label) throws DriverException {
            this.base = base;
            this.ngpio = ngpio;
            this.name = name;
            this.label = label;
        }

        public int getBase() {
            return this.base;
        }

        public int getNgpio() {
            return this.ngpio;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public List<? extends GPIOChannel> exportAll() throws DriverException {
            return GPIODriver.this.exportRange(this.base, this.ngpio);
        }

        public void unexportAll() throws DriverException {
            GPIODriver.this.unexportRange(this.base, this.ngpio);
        }

        public String toString() {
            return "GPIOChip{base=" + this.base + ", ngpio=" + this.ngpio + ", name=" + this.name + ", label=" + this.label + "}";
        }
    }

    public static abstract class GPIOChannel {
        protected final int chip;
        protected final int channel;
        protected final String name;
        protected final int offset;

        public GPIOChannel(int chip, int channel, String name, int offset) {
            this.chip = chip;
            this.channel = channel;
            this.name = name;
            this.offset = offset;
        }

        public abstract Direction getDirection() throws DriverException;

        public abstract void setDirection(Direction var1) throws DriverException;

        public abstract void set() throws DriverException;

        public abstract void clear() throws DriverException;

        public abstract boolean read() throws DriverException;

        public abstract void write(boolean var1) throws DriverException;

        public abstract void lock() throws DriverException;

        public abstract void unlock() throws DriverException;

        public int getChip() {
            return this.chip;
        }

        public int getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return "GPIOChannel{channel=" + this.channel + ", name=" + this.name + ", chip=" + this.chip + ", offset=" + this.offset + "}";
        }

        public static enum Direction {
            IN,
            OUT;

        }
    }
}

