/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.subsystem.utility.Maq20DeviceUT;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class ValvePositionErrorChannel
extends DerivedChannel {
    @LookupPath
    private String path;
    private Channel positionChannel;
    private Maq20DeviceUT valveControl;
    private Integer valveId;

    public void postInit() {
        if (this.positionChannel == null) {
            throw new RuntimeException(this.path + ": positionChannel has not been specified");
        }
        if (this.valveControl == null) {
            throw new RuntimeException(this.path + ": valveControl has not been specified");
        }
        if (this.valveId == null) {
            throw new RuntimeException(this.path + ": valveId has not been specified");
        }
        if (this.valveId < 0 || this.valveId >= 3) {
            throw new RuntimeException(this.path + ": valveId must be non-negative and less than 3");
        }
    }

    public double evaluateDerivedValue() {
        double setPosition;
        try {
            setPosition = 100.0 * this.valveControl.getValvePosition(this.valveId);
        }
        catch (UtilityException e) {
            return Double.NaN;
        }
        if (System.currentTimeMillis() >= this.valveControl.getStableValveTime(this.valveId)) {
            return Math.abs(this.positionChannel.getValue() - setPosition);
        }
        return Double.NaN;
    }
}

