/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.DoNotTrend;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

@SkipEncoding
@DoNotTrend
@DataAttributes(units="unitless")
public class ImageReadoutParametersEvent
implements Serializable {
    private static final long serialVersionUID = -68951332963342L;
    public static String EVENT_KEY = "ImageReadoutParameters";
    private final ImageName imageName;
    private final String[] ccdType;
    private final int[] overRows;
    private final int[] overCols;
    private final int[] readRows;
    private final int[] readCols;
    private final int[] readCols2;
    private final int[] preCols;
    private final int[] preRows;
    private final int[] postCols;
    private final int[] postRows;
    private final int[] underCols;
    private final String annotation;
    private final LocationSet locations;
    private final int currentOpcode;
    private final String daqFolder;

    public ImageReadoutParametersEvent(ImageName imageName, String annotation, LocationSet locations, int currentOpcode, String daqFolder) {
        this.imageName = imageName;
        this.annotation = annotation;
        this.locations = new LocationSet((Set)locations);
        this.currentOpcode = currentOpcode;
        this.daqFolder = daqFolder;
        int nLocations = locations.size();
        this.ccdType = new String[nLocations];
        this.overRows = new int[nLocations];
        this.overCols = new int[nLocations];
        this.readRows = new int[nLocations];
        this.readCols = new int[nLocations];
        this.readCols2 = new int[nLocations];
        this.preCols = new int[nLocations];
        this.preRows = new int[nLocations];
        this.postCols = new int[nLocations];
        this.postRows = new int[nLocations];
        this.underCols = new int[nLocations];
    }

    public void setParameters(Location location, CCDType ccdType, int preCols, int underCols, int readCols, int postCols, int readCols2, int overCols, int preRows, int readRows, int postRows, int overRows) {
        int currentLocation = this.indexOf(location, this.locations);
        this.ccdType[currentLocation] = ccdType.getManufacturer();
        this.overRows[currentLocation] = overRows;
        this.overCols[currentLocation] = overCols;
        this.underCols[currentLocation] = underCols;
        this.readRows[currentLocation] = readRows;
        this.readCols[currentLocation] = readCols;
        this.readCols2[currentLocation] = readCols2;
        this.preCols[currentLocation] = preCols;
        this.preRows[currentLocation] = preRows;
        this.postCols[currentLocation] = postCols;
        this.postRows[currentLocation] = postRows;
        this.underCols[currentLocation] = underCols;
    }

    private int indexOf(Location location, LocationSet locations) {
        int i = 0;
        for (Location l : locations) {
            if (l.equals((Object)location)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ImageName getImageName() {
        return this.imageName;
    }

    public String[] getCcdType() {
        return this.ccdType;
    }

    public int[] getOverRows() {
        return this.overRows;
    }

    public int[] getOverCols() {
        return this.overCols;
    }

    public int[] getReadRows() {
        return this.readRows;
    }

    public int[] getReadCols() {
        return this.readCols;
    }

    public int[] getReadCols2() {
        return this.readCols2;
    }

    public int[] getPreCols() {
        return this.preCols;
    }

    public int[] getPreRows() {
        return this.preRows;
    }

    public int[] getPostCols() {
        return this.postCols;
    }

    public int[] getPostRows() {
        return this.postRows;
    }

    public int[] getUnderCols() {
        return this.underCols;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public LocationSet getLocations() {
        return this.locations;
    }

    public int getCurrentOpcode() {
        return this.currentOpcode;
    }

    public String getDaqFolder() {
        return this.daqFolder;
    }

    public String toString() {
        return "ImageReadoutParametersEvent{imageName=" + this.imageName + ", ccdType=" + Arrays.toString(this.ccdType) + ", overRows=" + Arrays.toString(this.overRows) + ", overCols=" + Arrays.toString(this.overCols) + ", readRows=" + Arrays.toString(this.readRows) + ", readCols=" + Arrays.toString(this.readCols) + ", readCols2=" + Arrays.toString(this.readCols2) + ", preCols=" + Arrays.toString(this.preCols) + ", preRows=" + Arrays.toString(this.preRows) + ", postCols=" + Arrays.toString(this.postCols) + ", postRows=" + Arrays.toString(this.postRows) + ", underCols=" + Arrays.toString(this.underCols) + ", annotation=" + this.annotation + ", locations=" + this.locations + ", currentOpcode=" + this.currentOpcode + ", daqFolder=" + this.daqFolder + "}";
    }
}

