/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistScatterPlotStyle;
import jas.util.CheckBoxBorderPanel;
import jas.util.ColorChooser;
import jas.util.PropertyBinding;
import jas.util.PropertyPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import tablelayout.TableLayout;

final class JASHist2DPropStyle
extends PropertyPage {
    private JCheckBox twoDCheckBox;
    private JCheckBox scatCheckBox;
    private JPanel plotSchemePanel;
    private JComboBox plotScheme;
    private JLabel plotLabel;
    private ColorChooser shapeColor;
    private JLabel shapeColorLabel;
    private ColorChooser overFlowColor;
    private JLabel overFlowColorLabel;
    private JComboBox colorMapScheme;
    private JLabel colorMapLabel;
    private ColorChooser startColor;
    private JLabel startColorLabel;
    private ColorChooser endColor;
    private JLabel endColorLabel;
    private JCheckBox showOverFlow;
    private JButton invertRange;
    private JASHist2DHistogramStyle s2D;
    private JASHist2DHistogramStyle m_selected;

    JASHist2DPropStyle() {
        this.setLayout(new BorderLayout());
        CheckBoxBorderPanel p1 = this.create2DPanel();
        CheckBoxBorderPanel p2 = this.createScatterPanel();
        this.twoDCheckBox = p1.getCheckBox();
        this.scatCheckBox = p2.getCheckBox();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.twoDCheckBox);
        bg.add(this.scatCheckBox);
        this.scatCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JASHist2DPropStyle.this.callEnable();
            }
        });
        this.add((Component)p1, "Center");
        this.add((Component)p2, "South");
    }

    private CheckBoxBorderPanel create2DPanel() {
        CheckBoxBorderPanel p = new CheckBoxBorderPanel("2D Plot Style");
        p.setLayout(new TableLayout());
        this.plotSchemePanel = new JPanel(new FlowLayout());
        this.plotLabel = new JLabel("Plot Scheme:");
        this.plotScheme = new JComboBox();
        this.plotScheme.addItem("Box");
        this.plotScheme.addItem("Ellipse");
        this.plotScheme.addItem("ColorMap");
        this.plotSchemePanel.add(this.plotLabel);
        this.plotSchemePanel.add(this.plotScheme);
        this.colorMapLabel = new JLabel("ColorMap Scheme:");
        this.colorMapScheme = new JComboBox();
        this.colorMapScheme.addItem("Warm");
        this.colorMapScheme.addItem("Cool");
        this.colorMapScheme.addItem("Thermal");
        this.colorMapScheme.addItem("Rainbow");
        this.colorMapScheme.addItem("GrayScale");
        this.colorMapScheme.addItem("Select Range");
        this.plotSchemePanel.add(this.colorMapLabel);
        this.plotSchemePanel.add(this.colorMapScheme);
        p.add("0 0 5 1", this.plotSchemePanel);
        this.shapeColorLabel = new JLabel("Bin Color");
        this.shapeColor = new ColorChooser(Color.black);
        p.add("1 1 w", this.shapeColor);
        p.add("0 1 Wr", this.shapeColorLabel);
        this.startColorLabel = new JLabel("Set Range Min");
        this.startColor = new ColorChooser(Color.white);
        p.add("3 1 w", this.startColor);
        p.add("2 1 Wr", this.startColorLabel);
        this.overFlowColorLabel = new JLabel("OverFlow Color");
        this.overFlowColor = new ColorChooser(Color.red);
        p.add("1 2 w", this.overFlowColor);
        p.add("0 2 Wr", this.overFlowColorLabel);
        this.endColorLabel = new JLabel("Set Range Max");
        this.endColor = new ColorChooser(Color.black);
        p.add("3 2 w", this.endColor);
        p.add("2 2 Wr", this.endColorLabel);
        this.invertRange = new JButton("Invert"){

            @Override
            protected final void fireActionPerformed(ActionEvent e) {
                Color tempColor = JASHist2DPropStyle.this.startColor.getColor();
                JASHist2DPropStyle.this.startColor.setColor(JASHist2DPropStyle.this.endColor.getColor());
                JASHist2DPropStyle.this.endColor.setColor(tempColor);
            }
        };
        p.add("4 1 1 2 HWl", this.invertRange);
        this.addBinding(new PropertyBinding(this.plotScheme, "HistStyle"));
        this.addBinding(new PropertyBinding(this.colorMapScheme, "ColorMapScheme"));
        this.addBinding(new PropertyBinding(this.shapeColor, "ShapeColor"));
        this.addBinding(new PropertyBinding(this.overFlowColor, "OverflowBinColor"));
        this.addBinding(new PropertyBinding(this.startColor, "StartDataColor"));
        this.addBinding(new PropertyBinding(this.endColor, "EndDataColor"));
        return p;
    }

    private CheckBoxBorderPanel createScatterPanel() {
        ColorChooser pointColor = new ColorChooser();
        JComboBox<String> pointStyle = new JComboBox<String>();
        JSpinner pointSize = new JSpinner(new SpinnerNumberModel(2, 1, 20, 1));
        CheckBoxBorderPanel p = new CheckBoxBorderPanel("Scatter Plot Style", new FlowLayout());
        p.add(new JLabel("Data Points"));
        p.add(pointColor);
        p.add(pointStyle);
        p.add(pointSize);
        this.add((Component)p, "North");
        this.addConditionalBinding(new PropertyBinding(pointColor, "DataPointColor"));
        this.addConditionalBinding(new PropertyBinding(pointStyle, "DataPointStyle"));
        this.addConditionalBinding(new PropertyBinding(pointSize, "DataPointSize"));
        pointStyle.addItem("Box");
        pointStyle.addItem("Triangle");
        pointStyle.addItem("Diamond");
        pointStyle.addItem("Star");
        pointStyle.addItem("Vert Line");
        pointStyle.addItem("Horiz Line");
        pointStyle.addItem("Cross");
        pointStyle.addItem("Square");
        return p;
    }

    public void addConditionalBinding(PropertyBinding b) {
        b.setBeanClass(JASHistScatterPlotStyle.class);
        this.addBinding(b);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doDataExchange(boolean set, Object bean) {
        super.doDataExchange(set, bean);
        this.s2D = (JASHist2DHistogramStyle)bean;
        if (this.s2D instanceof JASHistScatterPlotStyle) {
            ss = (JASHistScatterPlotStyle)this.s2D;
            if (set) {
                ss.setDisplayAsScatterPlot(this.scatCheckBox.isSelected());
            }
            this.scatCheckBox.setSelected(ss.getDisplayAsScatterPlot());
            this.twoDCheckBox.setSelected(ss.getDisplayAsScatterPlot() == false);
            this.scatCheckBox.setEnabled(true);
        } else {
            this.twoDCheckBox.setSelected(true);
            this.scatCheckBox.setEnabled(false);
        }
        colormap = this.s2D.getHistStyle() == 2;
        this.shapeColor.setEnabled(colormap == false);
        this.shapeColorLabel.setEnabled(colormap == false);
        this.colorMapScheme.setEnabled(colormap);
        this.colorMapLabel.setEnabled(colormap);
        overflow = colormap == false && this.s2D.getShowOverflow() != false;
        this.overFlowColor.setEnabled(overflow);
        this.overFlowColorLabel.setEnabled(overflow);
        if (!colormap) ** GOTO lbl-1000
        if (this.s2D.getColorMapScheme() == 5) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        userDefined = v0;
        this.invertRange.setEnabled(userDefined);
        this.startColor.setEnabled(userDefined);
        this.startColorLabel.setEnabled(userDefined);
        this.endColorLabel.setEnabled(userDefined);
        this.endColor.setEnabled(userDefined);
    }

    public void valueChanged(ListSelectionEvent evt) {
        System.out.println("2D valueChanged called");
    }

    public void callEnable() {
        this.setChanged(true);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d1 = super.getMaximumSize();
        Dimension d2 = super.getPreferredSize();
        d1.height = d2.height;
        return d1;
    }

    void init(boolean isHistData) {
        System.out.println("2D - Its really Alive!");
    }
}

