/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.kafka;

import java.time.Duration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class SALKafkaUtils {
    private final int pid;
    private final AtomicInteger seqNum = new AtomicInteger(1);
    private static final SALKafkaUtils theInstance = new SALKafkaUtils();

    private SALKafkaUtils() {
        Random random = new Random();
        this.pid = random.nextInt();
    }

    static SALKafkaUtils instance() {
        return theInstance;
    }

    int getPid() {
        return this.pid;
    }

    int getSeqNum() {
        return this.seqNum.getAndIncrement();
    }

    static Duration durationFromSeconds(double timeout) {
        return Duration.ofMillis((int)(timeout * 1000.0));
    }

    static double durationToSeconds(Duration d) {
        return (double)d.toMillis() * 1000.0;
    }
}

