/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorUpdateTask;

public class MonitoringConfig
implements ConfigurationBulkChangeHandler {
    private static final Logger LOG = Logger.getLogger(MonitoringConfig.class.getName());
    @ConfigurationParameter(category="Monitoring", description="Regular expression to select tasks to pause before readout. An empty String means no tasks will be paused.", units="unitless")
    public volatile String readoutPauseTasks = "";
    @ConfigurationParameter(category="Monitoring", description="Regular expression to select tasks to trigger immediately after readout. An empty String means no tasks will be triggered.", units="unitless")
    public volatile String postReadoutTriggerTasks = "";
    private final List<MonitorUpdateTask> tasksToPause = new CopyOnWriteArrayList<MonitorUpdateTask>();
    private final List<MonitorUpdateTask> tasksToTrigger = new CopyOnWriteArrayList<MonitorUpdateTask>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor monitor;

    public void validateBulkChange(Map<String, Object> parametersView) {
        String proposedPostReadoutTriggerTasks;
        String proposedReadoutPauseTasks = (String)parametersView.get("readoutPauseTasks");
        if (!this.readoutPauseTasks.equals(proposedReadoutPauseTasks) && !proposedReadoutPauseTasks.isEmpty()) {
            try {
                Pattern.compile(proposedReadoutPauseTasks);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("The provided \"readoutPauseTasks\" configuration parameter is an invalid regular expression: " + this.readoutPauseTasks, e);
            }
        }
        if (!this.postReadoutTriggerTasks.equals(proposedPostReadoutTriggerTasks = (String)parametersView.get("postReadoutTriggerTasks")) && !proposedPostReadoutTriggerTasks.isEmpty()) {
            try {
                Pattern.compile(proposedPostReadoutTriggerTasks);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("The provided \"postReadoutTriggerTasks\" configuration parameter is an invalid regular expression: " + this.postReadoutTriggerTasks, e);
            }
        }
    }

    public void setParameterBulk(Map<String, Object> parametersView) {
        String proposedPostReadoutTriggerTasks;
        Pattern p;
        String proposedReadoutPauseTasks;
        if (parametersView.containsKey("readoutPauseTasks") && !this.readoutPauseTasks.equals(proposedReadoutPauseTasks = (String)parametersView.get("readoutPauseTasks"))) {
            this.readoutPauseTasks = proposedReadoutPauseTasks;
            this.tasksToPause.clear();
            if (!this.readoutPauseTasks.isEmpty()) {
                p = Pattern.compile(this.readoutPauseTasks);
                this.tasksToPause.addAll(this.filterMonitorTasksByName(p));
            }
            LOG.log(Level.INFO, () -> "Configuration parameter \"readoutPauseTasks\" updated to " + this.readoutPauseTasks + "\n" + this.printTasksToPauseDuringReadout());
        }
        if (parametersView.containsKey("postReadoutTriggerTasks") && !this.postReadoutTriggerTasks.equals(proposedPostReadoutTriggerTasks = (String)parametersView.get("postReadoutTriggerTasks"))) {
            this.postReadoutTriggerTasks = proposedPostReadoutTriggerTasks;
            this.tasksToTrigger.clear();
            if (!this.postReadoutTriggerTasks.isEmpty()) {
                p = Pattern.compile(this.postReadoutTriggerTasks);
                this.tasksToTrigger.addAll(this.filterMonitorTasksByName(p));
            }
            LOG.log(Level.INFO, () -> "Configuration parameter \"postReadoutTriggerTasks\" updated to " + this.postReadoutTriggerTasks + "\n" + this.printTasksToTriggerAfterReadout());
        }
    }

    private List<MonitorUpdateTask> filterMonitorTasksByName(Pattern p) {
        ArrayList<MonitorUpdateTask> result = new ArrayList<MonitorUpdateTask>();
        this.monitor.getMonitorTasksList().stream().filter(t -> p.matcher(t.getName()).matches()).forEachOrdered(t -> result.add((MonitorUpdateTask)t));
        return result;
    }

    String printTasksToPauseDuringReadout() {
        if (this.tasksToPause.isEmpty()) {
            return "No tasks will be paused during readout.";
        }
        StringBuilder sb = new StringBuilder("The following tasks will be paused during readout: \n");
        int count = 0;
        for (MonitorUpdateTask t : this.tasksToPause) {
            sb.append("-").append(++count).append("- ").append(t.getName()).append("\n");
        }
        return sb.toString();
    }

    String printTasksToTriggerAfterReadout() {
        if (this.tasksToTrigger.isEmpty()) {
            return "No tasks will be triggered right after readout";
        }
        StringBuilder sb = new StringBuilder("The following tasks will be triggered right after readout: \n");
        int count = 0;
        for (MonitorUpdateTask t : this.tasksToTrigger) {
            sb.append("-").append(++count).append("- ").append(t.getName()).append("\n");
        }
        return sb.toString();
    }

    void pauseMonitoringTasks() {
        ArrayList listOfFutures = new ArrayList();
        this.tasksToPause.forEach(t -> listOfFutures.add(t.pausePeriodicUpdate()));
        try {
            for (Future f : listOfFutures) {
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to pause monitoring tasks.", e);
        }
    }

    void resumeMonitoringTasks() {
        this.tasksToPause.forEach(t -> t.resumePeriodicUpdate());
    }

    void triggerMonitoringTasks() {
        this.tasksToTrigger.forEach(t -> t.scheduleUpdateAndPublishNow());
    }

    List<MonitorUpdateTask> getTasksToPauseDuringReadout() {
        return this.tasksToPause;
    }

    List<MonitorUpdateTask> getTasksToTriggerAfterReadout() {
        return this.tasksToTrigger;
    }
}

