/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.subsystem.comcamvacuum.SwitchDevice;
import org.lsst.ccs.subsystem.comcamvacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorr84Device;

public class VacTurboDevice
extends TwisTorr84Device
implements SwitchDevice {
    private static final Map<TwisTorr84.PumpStatus, DeviceState> turboStateMap = new HashMap<TwisTorr84.PumpStatus, DeviceState>();
    private final int deviceId;

    public VacTurboDevice(int deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public int getSwitchDevice() {
        return this.deviceId;
    }

    @Override
    public void setSwitch(int sw, boolean on) throws DriverException {
        if (on) {
            this.startTurboPump();
        } else {
            this.stopTurboPump();
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        DeviceState st = this.getDeviceState();
        return st == null ? null : Boolean.valueOf(st != DeviceState.STOPPED && st != DeviceState.BRAKING);
    }

    public DeviceState getDeviceState() {
        try {
            return turboStateMap.get(this.readTurboStatus());
        }
        catch (DriverException e) {
            return null;
        }
    }

    static {
        turboStateMap.put(TwisTorr84.PumpStatus.STOP, DeviceState.STOPPED);
        turboStateMap.put(TwisTorr84.PumpStatus.WAIT_INTLK, DeviceState.WAITING);
        turboStateMap.put(TwisTorr84.PumpStatus.STARTING, DeviceState.STARTNG);
        turboStateMap.put(TwisTorr84.PumpStatus.NORMAL, DeviceState.NORMAL);
        turboStateMap.put(TwisTorr84.PumpStatus.BRAKING, DeviceState.BRAKING);
        turboStateMap.put(TwisTorr84.PumpStatus.FAIL, DeviceState.FAILED);
        turboStateMap.put(TwisTorr84.PumpStatus.AUTO_TUNING, DeviceState.AUTOTUN);
    }
}

