/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.time.Instant;

public class Status {
    private final Instant timestamp;
    private final int status;
    private final int sequence;
    private final State in;
    private final State out;

    private Status(long timestampNanos, int status, int sequence, int inState, int outState) {
        this.timestamp = Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
        this.status = status;
        this.sequence = sequence;
        this.in = State.values()[inState];
        this.out = State.values()[outState];
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public int getStatus() {
        return this.status;
    }

    public int getSequence() {
        return this.sequence;
    }

    public State getIn() {
        return this.in;
    }

    public State getOut() {
        return this.out;
    }

    public String toString() {
        return "Status{timestamp=" + this.timestamp + ", status=" + this.status + ", sequence=" + this.sequence + ", in=" + this.in + ", out=" + this.out + "}";
    }

    public static enum State {
        UNDEFINED,
        STOPPED,
        PAUSED,
        RUNNING,
        ERROR,
        OFF;

    }
}

