/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.util.ChecksumExtractorUtils;
import org.lsst.ccs.camera.sal.xml.util.SerializationUtils;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DataAndDictionarySerializer
implements HasLifecycle,
AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(DataAndDictionarySerializer.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dpdService;
    private ChecksumExtractorUtils extractor;
    private final Map<String, Long> xmlChecksums = new HashMap<String, Long>();
    @ConfigurationParameter(description="The Camera name", isFinal=true, units="unitless")
    private Camera camera = Camera.COMCAM;
    @ConfigurationParameter(description="The output directory", units="unitless")
    private String outputDir = "/tmp/";
    private File outputLocation;
    private final DictionaryListener dataDictionaryListener = new DictionaryListener();
    private final TrendingAndMonitoringDataListener trendingAndMonitoringDataListener = new TrendingAndMonitoringDataListener();
    private final ConfigurationListener configurationListener = new ConfigurationListener();
    private final Predicate<BusMessage> workersAndServicesOnly = bm -> ((StatusMessage)bm).getOriginAgentInfo().isAgentWorkerOrService();

    public void init() {
        this.dpdService.addDataProviderDictionaryListener((DataProviderDictionaryService.DataProviderDictionaryListener)this.dataDictionaryListener);
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.trendingAndMonitoringDataListener, BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(this.workersAndServicesOnly));
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.configurationListener, BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class).and(this.workersAndServicesOnly));
        InputStream is = DataAndDictionarySerializer.class.getResourceAsStream("/xml/" + this.camera.getCscName() + XMLMaker2.SALType.TELEMETRY.getXMLFileSuffix());
        try {
            this.extractor = new ChecksumExtractorUtils();
            this.xmlChecksums.putAll(this.extractor.extractChecksumsFromSALXMLInputStream(is));
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException xe) {
            throw new RuntimeException("Failed to extract checksums : ", xe);
        }
        is = DataAndDictionarySerializer.class.getResourceAsStream("/xml/" + this.camera.getCscName() + XMLMaker2.SALType.SETTINGS_APPLIED.getXMLFileSuffix());
        try {
            this.xmlChecksums.putAll(this.extractor.extractChecksumsFromSALXMLInputStream(is));
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException xe) {
            throw new RuntimeException("Failed to extract checksums : ", xe);
        }
    }

    public void shutdown() {
        this.dpdService.removeDataProviderDictionaryListener((DataProviderDictionaryService.DataProviderDictionaryListener)this.dataDictionaryListener);
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.trendingAndMonitoringDataListener);
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.configurationListener);
    }

    @ConfigurationParameterChanger(propertyName="outputDir")
    public void setOutputDir(String outputDir) {
        try {
            this.outputLocation = new File(outputDir);
            this.outputLocation.mkdirs();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set configuration parameter xmlOutputDir to " + outputDir, e);
        }
        this.outputDir = outputDir;
    }

    @Command(type=Command.CommandType.QUERY, level=0)
    public void writeSerializedFilesForAllAgents() {
        for (String agentName : this.dataDictionaryListener.getAllAgents()) {
            this.writeSerializedFilesForAgent(agentName);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0)
    public void writeSerializedFilesForAgent(String agentName) {
        this.writeDataDictionaryForAgent(agentName);
        StatusConfigurationInfo configInfo = this.configurationListener.getConfigurationInfoForAgent(agentName);
        this.writeObject(configInfo, agentName + "-config-info.ser");
        Map<String, StatusSubsystemData> monitoringMap = this.trendingAndMonitoringDataListener.getMonitoringDataForAgent(agentName);
        for (Map.Entry<String, StatusSubsystemData> e : monitoringMap.entrySet()) {
            String taskName = e.getKey();
            StatusSubsystemData ssd = e.getValue();
            String outputName = taskName.isEmpty() ? agentName + "-monitoring.ser" : agentName + "-" + taskName.replace("/", "_") + "-monitoring.ser";
            this.writeObject(ssd, outputName);
        }
        Map<String, StatusSubsystemData> trendMap = this.trendingAndMonitoringDataListener.getTrendingDataForAgent(agentName);
        for (Map.Entry<String, StatusSubsystemData> e : trendMap.entrySet()) {
            String taskName = e.getKey();
            StatusSubsystemData ssd = e.getValue();
            String outputName = taskName.isEmpty() ? agentName + "-trending.ser" : agentName + "-" + taskName.replace("/", "_") + "-trending.ser";
            this.writeObject(ssd, outputName);
        }
    }

    private void writeDataDictionaryForAgent(String agentName) {
        DataProviderDictionary dataDict = this.dataDictionaryListener.getDataDictionaryForAgent(agentName);
        this.writeObject(dataDict, agentName + "-status-dictionary.ser");
    }

    @Command(type=Command.CommandType.QUERY, level=0)
    public void writeXMLFilesForAgent(String agentName) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        this.writeXMLFilesForAgent(agentName, true, true);
    }

    public void writeXMLFilesForAgent(String agentName, boolean writeEvents, boolean writeTelemetry) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        DataProviderDictionary dictionary = this.dataDictionaryListener.getDataDictionaryForAgent(agentName);
        this.writeXMLFilesFromSerializedDictionary(agentName, dictionary, writeEvents, writeTelemetry);
    }

    private void writeXMLFilesFromSerializedDictionary(String agentName, DataProviderDictionary dict, boolean writeEvents, boolean writeTelemetry) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        MakeXMLConfiguration config;
        XMLMaker2 maker = new XMLMaker2(false);
        if (writeTelemetry) {
            config = MakeXMLConfiguration.getInstance((Camera)this.camera, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY, (String)agentName, (DataProviderDictionary)dict);
            this.writeXMLForConfig(config, maker, agentName);
        }
        if (writeEvents) {
            config = MakeXMLConfiguration.getInstance((Camera)this.camera, (XMLMaker2.SALType)XMLMaker2.SALType.SETTINGS_APPLIED, (String)agentName, (DataProviderDictionary)dict);
            this.writeXMLForConfig(config, maker, agentName);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0)
    public String printTrendingQuantities() {
        Object result = this.printTrendingQuantitiesFor(this.dataDictionaryListener.agentDataDictionary.entrySet());
        result = (String)result + "\n";
        result = (String)result + this.printTrendingQuantitiesFor(this.dataDictionaryListener.ignoredAgentDataDictionary.entrySet());
        return result;
    }

    private String printTrendingQuantitiesFor(Set<Map.Entry<String, DataProviderDictionary>> set) {
        StringBuilder sb = new StringBuilder("Trending quantities by agent:");
        for (Map.Entry<String, DataProviderDictionary> e : set) {
            String agentName = e.getKey();
            sb.append("\n--- ").append(agentName);
            DataProviderDictionary dict = e.getValue();
            int count = 0;
            for (DataProviderInfo dpi : dict.getDataProviderInfos()) {
                if (!DataProviderInfo.Type.TRENDING.name().equals(dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE)) || dpi.getFullPath().startsWith("runtime")) continue;
                sb.append("\n    -").append(++count).append("- ").append(dpi.toString());
            }
            if (count != 0) continue;
            sb.append(" no trending quantities in dictionary");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=0)
    public void writeXMLFilesFromSerializedDictionary(String agentName, String dictionaryFileName) throws ParserConfigurationException, IOException, ClassNotFoundException, TransformerException, SAXException, XPathExpressionException {
        DataProviderDictionary dict = SerializationUtils.readDictionaryFromFile((String)dictionaryFileName);
        this.writeXMLFilesFromSerializedDictionary(agentName, dict, true, true);
    }

    private void writeXMLForConfig(MakeXMLConfiguration config, XMLMaker2 maker, String agentName) throws ParserConfigurationException, TransformerException {
        File outputFileName = new File(this.outputLocation, config.getXMLFileNameForAgent(agentName));
        Document document = maker.createXML(config);
        maker.writeXML(new StreamResult(outputFileName), document);
        LOG.log(Level.INFO, "Wrote {0}", outputFileName);
    }

    private void writeObject(Object obj, String name) {
        File outputFileName = new File(this.outputLocation, name);
        LOG.log(Level.INFO, "Writing out file {0}", outputFileName.getAbsolutePath());
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(outputFileName));){
            oos.writeObject(obj);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Failed to write " + outputFileName.getAbsolutePath(), ex);
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            String agentName = ai.getName();
            this.dataDictionaryListener.removeAgent(agentName);
            this.trendingAndMonitoringDataListener.removeAgent(agentName);
            this.configurationListener.removeAgent(agentName);
        }
    }

    private class DictionaryListener
    implements DataProviderDictionaryService.DataProviderDictionaryListener {
        private final Map<String, DataProviderDictionary> agentDataDictionary = new ConcurrentHashMap<String, DataProviderDictionary>();
        private final Map<String, DataProviderDictionary> ignoredAgentDataDictionary = new ConcurrentHashMap<String, DataProviderDictionary>();
        private MakeXMLConfiguration xmlConfig = null;

        private DictionaryListener() {
        }

        private MakeXMLConfiguration getXmlConfiguration() {
            if (this.xmlConfig == null) {
                this.xmlConfig = MakeXMLConfiguration.getInstance((Camera)DataAndDictionarySerializer.this.camera, (XMLMaker2.SALType)XMLMaker2.SALType.TELEMETRY);
            }
            return this.xmlConfig;
        }

        public void dataProviderDictionaryUpdate(DataProviderDictionaryService.DataProviderDictionaryEvent evt) {
            block15: {
                try {
                    AgentInfo.AgentType type;
                    if (evt.getEventType() != DataProviderDictionaryService.DataProviderDictionaryEvent.EventType.ADDED || (type = evt.getAgentInfo().getType()) != AgentInfo.AgentType.WORKER && type != AgentInfo.AgentType.SERVICE) break block15;
                    AgentInfo agentInfo = evt.getAgentInfo();
                    String agentName = agentInfo.getName();
                    if (this.getXmlConfiguration().getDictionaryConfigurationForAgentInfo(agentInfo) == null) {
                        if (!this.ignoredAgentDataDictionary.containsKey(agentName)) {
                            this.ignoredAgentDataDictionary.put(agentName, evt.getDictionary());
                        }
                        LOG.log(Level.INFO, "Ignoring dictionary for agent {0}; it's not an agent worth listening to.", agentName);
                        return;
                    }
                    if (this.agentDataDictionary.containsKey(agentName)) break block15;
                    DataProviderDictionary dict = evt.getDictionary();
                    this.agentDataDictionary.put(agentName, dict);
                    LOG.log(Level.INFO, "Processing checksums for agent {0}", agentName);
                    Map dictionaryChecksums = DataAndDictionarySerializer.this.extractor.extractChecksumsFromDataProviderDictionaryForAgent(DataAndDictionarySerializer.this.camera, agentInfo, dict);
                    boolean writeEventsXml = false;
                    boolean writeTelemetryXml = false;
                    boolean writeDataDictionary = false;
                    for (Map.Entry entry : dictionaryChecksums.entrySet()) {
                        Long xmlChecksum;
                        boolean equals;
                        String topic = (String)entry.getKey();
                        if (topic.contains("InfluxDb")) continue;
                        Long checksum = (Long)entry.getValue();
                        Object topicName = topic;
                        if (topic.contains("logevent")) {
                            topicName = (String)topicName + "Configuration";
                        }
                        if (!(equals = checksum.equals(xmlChecksum = DataAndDictionarySerializer.this.xmlChecksums.get(topicName)))) {
                            if (xmlChecksum == null) {
                                LOG.log(Level.WARNING, "Missing topic in XML: {0}", topic);
                            } else {
                                LOG.log(Level.WARNING, "Checksum mismatch for {0} ({1} != {2})", new Object[]{topic, checksum, xmlChecksum});
                            }
                            if (topic.contains("logevent")) {
                                writeEventsXml = true;
                            } else {
                                writeTelemetryXml = true;
                            }
                        }
                        writeDataDictionary = true;
                    }
                    if (writeEventsXml || writeTelemetryXml) {
                        LOG.log(Level.INFO, "Writing xml files for agent {0} (events:{1}, telemetry:{2})", new Object[]{agentName, writeEventsXml, writeTelemetryXml});
                        try {
                            DataAndDictionarySerializer.this.writeXMLFilesForAgent(agentName, writeEventsXml, writeTelemetryXml);
                        }
                        catch (IOException | ClassNotFoundException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
                            LOG.log(Level.WARNING, "Failed to write xml for agent " + agentName, e);
                        }
                    }
                    if (writeDataDictionary) {
                        DataAndDictionarySerializer.this.writeDataDictionaryForAgent(agentName);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Exception adding dictionary", t);
                }
            }
        }

        public DataProviderDictionary getDataDictionaryForAgent(String agentName) {
            return this.agentDataDictionary.get(agentName);
        }

        public void removeAgent(String agentName) {
            this.agentDataDictionary.remove(agentName);
        }

        public Set<String> getAllAgents() {
            return this.agentDataDictionary.keySet();
        }
    }

    private class TrendingAndMonitoringDataListener
    implements StatusMessageListener {
        private final Map<String, Map<String, StatusSubsystemData>> agentMonitoringData = new ConcurrentHashMap<String, Map<String, StatusSubsystemData>>();
        private final Map<String, Map<String, StatusSubsystemData>> agentTrendingData = new ConcurrentHashMap<String, Map<String, StatusSubsystemData>>();

        private TrendingAndMonitoringDataListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            StatusSubsystemData ssd = (StatusSubsystemData)msg;
            if (!ssd.getDataKey().endsWith("State")) {
                String agentName = msg.getOriginAgentInfo().getName();
                KeyValueData kvd = ssd.getSubsystemData();
                if (kvd instanceof KeyValueDataList) {
                    KeyValueDataList kvdl = (KeyValueDataList)kvd;
                    String type = (String)((Object)kvdl.getAttribute("publicationType"));
                    if (type == null) {
                        String taskName = ((KeyValueData)((KeyValueDataList)kvd).getListOfKeyValueData().get(0)).getKey() + "-" + DataAndDictionarySerializer.this.dpdService.calculateHashCodeForData(ssd);
                        this.agentTrendingData.computeIfAbsent(agentName, k -> new ConcurrentHashMap()).put(taskName, ssd);
                    } else {
                        String taskName = (String)((Object)kvdl.getAttribute("taskName"));
                        if ("scheduledFull".equals(type)) {
                            taskName = "";
                        }
                        this.agentMonitoringData.computeIfAbsent(agentName, k -> new ConcurrentHashMap()).put(taskName, ssd);
                    }
                }
            }
        }

        public Map<String, StatusSubsystemData> getMonitoringDataForAgent(String agentName) {
            Map<String, StatusSubsystemData> result = this.agentMonitoringData.get(agentName);
            if (result != null) {
                return new HashMap<String, StatusSubsystemData>(result);
            }
            return new HashMap<String, StatusSubsystemData>();
        }

        public Map<String, StatusSubsystemData> getTrendingDataForAgent(String agentName) {
            Map<String, StatusSubsystemData> result = this.agentTrendingData.get(agentName);
            if (result != null) {
                return new HashMap<String, StatusSubsystemData>(result);
            }
            return new HashMap<String, StatusSubsystemData>();
        }

        public void removeAgent(String agentName) {
            this.agentMonitoringData.remove(agentName);
            this.agentTrendingData.remove(agentName);
        }
    }

    private class ConfigurationListener
    implements StatusMessageListener {
        private final Map<String, StatusConfigurationInfo> agentConfigurationData = new ConcurrentHashMap<String, StatusConfigurationInfo>();

        private ConfigurationListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            String agentName = msg.getOriginAgentInfo().getName();
            this.agentConfigurationData.put(agentName, (StatusConfigurationInfo)msg);
        }

        public StatusConfigurationInfo getConfigurationInfoForAgent(String agentName) {
            return this.agentConfigurationData.get(agentName);
        }

        public void removeAgent(String agentName) {
            this.agentConfigurationData.remove(agentName);
        }
    }
}

