/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm.alerts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.Alert;

public enum MmmAlerts {
    MissingSubsystem("MissingSubsystems", "Alert raised by the MMM when subsystems are missing");

    private final String id;
    private final String description;

    private MmmAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getAlertId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert(Enum group, Serializable ... parameters) {
        String alertId = this.id + "/" + group;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("group", group.name());
        if (this.id.equals(MmmAlerts.MissingSubsystem.id) && parameters != null && parameters.length > 0) {
            data.put("missing", parameters[0]);
        }
        Alert a = new Alert(alertId, this.description);
        for (Map.Entry e : data.entrySet()) {
            a.addAlertData((String)e.getKey(), (Serializable)e.getValue());
        }
        return a;
    }
}

