/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Clock;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Constant;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Parameter;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

public class SequencerTextParser {
    static int lnum = 0;

    public static Sequencer parse(File f) throws IOException {
        try (FileReader fr = new FileReader(f);){
            Sequencer sequencer = SequencerTextParser.parse(fr);
            return sequencer;
        }
    }

    public static Sequencer parse(Reader r) throws IOException {
        String l;
        Sequencer s = new Sequencer();
        FileSection sec = FileSection.BEFORE;
        BufferedReader rdr = new BufferedReader(r);
        lnum = 0;
        while ((l = rdr.readLine()) != null) {
            l = l.trim();
            ++lnum;
            if (l.isEmpty() || l.substring(0, 1).equals("#")) continue;
            sec = sec.parseLine(s, l);
        }
        s.complete();
        return s;
    }

    static enum FileSection {
        BEFORE{

            @Override
            FileSection parseLine(Sequencer s, String line) {
                if (line.startsWith("[constants]")) {
                    return CONSTANTS;
                }
                1.syntaxError(line);
                return this;
            }
        }
        ,
        CONSTANTS{

            @Override
            FileSection parseLine(Sequencer s, String line) {
                if (line.startsWith("[clocks]")) {
                    return CLOCKS;
                }
                Matcher m = this.definePattern.matcher(line);
                if (!m.matches()) {
                    2.syntaxError(line);
                }
                String key = m.group(1);
                String value = m.group(2).trim();
                String comm = 2.trim(m.group(4));
                s.getSequencerConfig().getParameters().add(new Parameter(key, comm, value));
                return this;
            }
        }
        ,
        CLOCKS{

            @Override
            FileSection parseLine(Sequencer s, String line) {
                if (line.startsWith("[pointers]")) {
                    return POINTERS;
                }
                Matcher m = this.defineNumPattern.matcher(line);
                if (!m.matches()) {
                    3.syntaxError(line);
                }
                String key = m.group(1);
                int value = Integer.parseInt(m.group(2));
                String comm = 3.trim(m.group(4));
                s.getSequencerConfig().getChannels().add(new Channel(key, comm, value));
                return this;
            }
        }
        ,
        POINTERS{

            @Override
            FileSection parseLine(Sequencer s, String line) {
                if (line.startsWith("[functions]")) {
                    return FUNCTIONS;
                }
                Matcher m = this.ptrPattern.matcher(line);
                if (!m.matches()) {
                    4.syntaxError(line);
                }
                switch (m.group(1)) {
                    case "PTR_FUNC": {
                        s.getSequencerConfig().getFuncPtrs().add(new FunctionPointer(m.group(2), 4.trim(m.group(5)), m.group(3)));
                        break;
                    }
                    case "PTR_SUBR": {
                        s.getSequencerConfig().getSubPtrs().add(new SubroutinePointer(m.group(2), 4.trim(m.group(5)), m.group(3)));
                        break;
                    }
                    case "REP_FUNC": {
                        int count = 0;
                        if (m.group(3).equals("infinity")) {
                            count = 0x800000;
                        } else if (m.group(3).matches("[0-9]+")) {
                            count = Integer.valueOf(m.group(3));
                        } else {
                            4.syntaxError(line);
                        }
                        s.getSequencerConfig().getFuncRepPtrs().add(new RepeatFunctionPointer(m.group(2), 4.trim(m.group(5)), count));
                        break;
                    }
                    case "REP_SUBR": {
                        int count = 0;
                        if (m.group(3).matches("[0-9]+")) {
                            count = Integer.valueOf(m.group(3));
                        } else {
                            4.syntaxError(line);
                        }
                        s.getSequencerConfig().getSubRepPtrs().add(new RepeatSubroutinePointer(m.group(2), 4.trim(m.group(5)), count));
                        break;
                    }
                    default: {
                        4.syntaxError(line);
                    }
                }
                return this;
            }
        }
        ,
        FUNCTIONS{
            boolean inSlices = false;
            Function curFunc = null;

            @Override
            FileSection parseLine(Sequencer s, String line) {
                if (line.startsWith("[subroutines]")) {
                    this.inSlices = false;
                    return SUBROUTINES;
                }
                if (line.startsWith("[mains]")) {
                    this.inSlices = false;
                    return MAINS;
                }
                Matcher m = this.funcPattern.matcher(line);
                if (!m.matches()) {
                    5.syntaxError(line);
                }
                if (m.group(1).equals("slices")) {
                    if (!m.group(2).equals(":") || !m.group(3).isEmpty()) {
                        5.syntaxError(line);
                    }
                    this.inSlices = true;
                } else if (m.group(1).equals("clocks")) {
                    if (!m.group(2).equals(":")) {
                        5.syntaxError(line);
                    }
                    this.inSlices = false;
                    if (!m.group(3).isEmpty()) {
                        String[] clocks;
                        for (String c : clocks = m.group(3).split("\\s*,\\s*")) {
                            this.curFunc.getClocks().add(new Clock(this.findChannel(s, c)));
                        }
                    }
                } else if (m.group(1).equals("constants")) {
                    if (!m.group(2).equals(":")) {
                        5.syntaxError(line);
                    }
                    this.inSlices = false;
                    if (!m.group(3).isEmpty()) {
                        String[] cst;
                        for (String c : cst = m.group(3).split("\\s*,\\s*")) {
                            String[] cc = c.trim().split("=");
                            this.curFunc.getConstants().add(new Constant(this.findChannel(s, cc[0]), cc[1]));
                        }
                    }
                } else if (this.inSlices && m.group(2).equals("=")) {
                    this.curFunc.getTimeslices().add(new Timeslice(m.group(1).trim(), m.group(3).trim().replaceAll("\\s*,\\s*", "")));
                } else {
                    if (!m.group(2).equals(":") || !m.group(3).isEmpty()) {
                        5.syntaxError(line);
                    }
                    this.inSlices = false;
                    this.curFunc = new Function(m.group(1).trim(), 5.trim(m.group(5)));
                    s.getSequencerConfig().getFunctions().add(this.curFunc);
                }
                return this;
            }
        }
        ,
        SUBROUTINES{
            Subroutine curSub = null;

            @Override
            FileSection parseLine(Sequencer s, String line) {
                if (line.startsWith("[mains]")) {
                    return MAINS;
                }
                Matcher m = this.subLabelPattern.matcher(line);
                if (m.matches()) {
                    this.curSub = new Subroutine(m.group(1), 6.trim(m.group(3)));
                    s.getSequencerRoutines().getSubroutines().add(this.curSub);
                    return this;
                }
                if (this.parseSubroutineLine(s, this.curSub, line)) {
                    this.curSub = null;
                }
                return this;
            }
        }
        ,
        MAINS{
            Main curSub = null;

            @Override
            FileSection parseLine(Sequencer s, String line) {
                if (line.startsWith("[subroutines]")) {
                    return SUBROUTINES;
                }
                Matcher m = this.subLabelPattern.matcher(line);
                if (m.matches()) {
                    this.curSub = new Main(m.group(1), 7.trim(m.group(3)));
                    s.getSequencerRoutines().getMains().add(this.curSub);
                    return this;
                }
                if (this.parseSubroutineLine(s, this.curSub, line)) {
                    this.curSub = null;
                }
                return this;
            }
        };

        Pattern definePattern = Pattern.compile("(\\w+)\\s*:\\s*([\\w ]+)\\s*(#\\s*(.*))?");
        Pattern defineNumPattern = Pattern.compile("(\\w+)\\s*:\\s*(\\d+)\\s*(#\\s*(.*))?");
        Pattern ptrPattern = Pattern.compile("(\\w+)\\s+(\\w+)\\s+(\\w+)\\s*(#\\s*(.*))?");
        Pattern funcPattern = Pattern.compile("([\\w ]+)\\s*([:=])\\s*([\\w ,=]*)\\s*(#\\s*(.*))?");
        Pattern subLabelPattern = Pattern.compile("(\\w+)\\s*:\\s*(#\\s*(.*))?");
        Pattern subRTSPattern = Pattern.compile("RTS\\s*(#\\s*(.*))?");
        Pattern subENDPattern = Pattern.compile("END\\s*(#\\s*(.*))?");
        Pattern subCALLPattern = Pattern.compile("CALL\\s+(@?\\w+)\\s*(repeat\\((@?\\w+)\\))?\\s*(#\\s*(.*))?");
        Pattern subJSRPattern = Pattern.compile("JSR\\s+(@?\\w+)\\s*(repeat\\((@?\\w+)\\))?\\s*(#\\s*(.*))?");

        Channel findChannel(Sequencer s, String name) {
            return s.getSequencerConfig().getChannels().stream().filter(x -> x.getId().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("channel " + name + " not found line " + lnum));
        }

        boolean parseSubroutineLine(Sequencer s, Subroutine curSub, String line) {
            if (curSub == null) {
                FileSection.syntaxError(line);
                return false;
            }
            Matcher m = this.subRTSPattern.matcher(line);
            if (m.matches()) {
                return true;
            }
            m = this.subENDPattern.matcher(line);
            if (m.matches()) {
                return true;
            }
            m = this.subCALLPattern.matcher(line);
            if (m.matches()) {
                Call c = new Call();
                c.setFcnName(m.group(1));
                c.setRepeat(m.group(3));
                curSub.getCalls().add(c);
                return false;
            }
            m = this.subJSRPattern.matcher(line);
            if (m.matches()) {
                Call c = new Call();
                c.setSubName(m.group(1));
                c.setRepeat(m.group(3));
                curSub.getCalls().add(c);
                return false;
            }
            FileSection.syntaxError(line);
            return false;
        }

        static void syntaxError(String line) {
            throw new RuntimeException("sequencer file syntax error line " + lnum + ": " + line);
        }

        static String trim(String str) {
            return str == null ? null : str.trim();
        }

        abstract FileSection parseLine(Sequencer var1, String var2);
    }
}

