/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.visualization.client.Message;
import org.lsst.ccs.visualization.server.FitsFileManager;

class MessageHandler
extends Thread {
    private final ByteBuffer headerBuffer = ByteBuffer.allocateDirect(256);
    private final SocketChannel socket;
    private final FitsFileManager ffManager;
    private static final Logger LOGGER = Logger.getLogger(MessageHandler.class.getName());

    MessageHandler(SocketChannel accept, FitsFileManager ffManager) throws IOException {
        this.ffManager = ffManager;
        this.socket = accept;
        accept.shutdownOutput();
    }

    @Override
    public void run() {
        try {
            Message message;
            while ((message = this.readMessage()) != null) {
                LOGGER.log(Level.FINE, "Received: {0}", message);
                this.ffManager.handleMessage(message, this.socket);
            }
        }
        catch (ClosedChannelException ex) {
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "IOException handling message on socket " + this.socket, ex);
        }
        finally {
            try {
                LOGGER.log(Level.FINE, "Closing connection to : {0}", this.socket);
                this.socket.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "IOException closing socket " + this.socket, ex);
            }
        }
    }

    private Message readMessage() throws IOException {
        this.headerBuffer.clear();
        this.headerBuffer.limit(4);
        int l = this.socket.read(this.headerBuffer);
        if (l < 0) {
            return null;
        }
        int len = this.headerBuffer.getInt(0);
        this.headerBuffer.limit(len + 4);
        this.socket.read(this.headerBuffer);
        this.headerBuffer.flip();
        return Message.decode(this.headerBuffer);
    }

    void close() throws IOException {
        this.socket.close();
    }
}

