/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.states.CalibrationState;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.states.RaftsState;
import org.lsst.ccs.subsystem.ocsbridge.states.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.states.TakeImageReadinessState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.CalibrationDetailedStateEvent;
import org.lsst.sal.camera.states.FilterChangerDetailedStateEvent;
import org.lsst.sal.camera.states.ImageReadinessDetailedStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.RaftsDetailedStateEvent;
import org.lsst.sal.camera.states.ShutterDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSStateEventConverter {
    private final Map<Class<? extends Enum>, Class<? extends Enum>> mapEnums = new HashMap<Class<? extends Enum>, Class<? extends Enum>>();
    private final Map<Class<? extends Enum>, Class<? extends CameraStateChangeEvent>> mapEnumToClass = new HashMap<Class<? extends Enum>, Class<? extends CameraStateChangeEvent>>();

    public OCSStateEventConverter() {
        this.mapEnums.put(SummaryStateEvent.SummaryState.class, SummaryStateEvent.SummaryState.class);
        this.mapEnums.put(ShutterState.class, ShutterDetailedStateEvent.ShutterState.class);
        this.mapEnums.put(FilterState.class, FilterChangerDetailedStateEvent.FilterChangerState.class);
        this.mapEnums.put(CCSCommandStateEvent.CCSCommandState.class, CCSCommandStateEvent.CCSCommandState.class);
        this.mapEnums.put(TakeImageReadinessState.class, ImageReadinessDetailedStateEvent.ImageReadinessState.class);
        this.mapEnums.put(RaftsState.class, RaftsDetailedStateEvent.RaftsState.class);
        this.mapEnums.put(CalibrationState.class, CalibrationDetailedStateEvent.CalibrationState.class);
        this.mapEnums.put(OfflineDetailedStateEvent.OfflineState.class, OfflineDetailedStateEvent.OfflineState.class);
        this.mapEnumToClass.put(SummaryStateEvent.SummaryState.class, SummaryStateEvent.class);
        this.mapEnumToClass.put(ShutterState.class, ShutterDetailedStateEvent.class);
        this.mapEnumToClass.put(FilterState.class, FilterChangerDetailedStateEvent.class);
        this.mapEnumToClass.put(CCSCommandStateEvent.CCSCommandState.class, CCSCommandStateEvent.class);
        this.mapEnumToClass.put(TakeImageReadinessState.class, ImageReadinessDetailedStateEvent.class);
        this.mapEnumToClass.put(RaftsState.class, RaftsDetailedStateEvent.class);
        this.mapEnumToClass.put(CalibrationState.class, CalibrationDetailedStateEvent.class);
        this.mapEnumToClass.put(OfflineDetailedStateEvent.OfflineState.class, OfflineDetailedStateEvent.class);
    }

    private Enum getEnum(Enum ccsStateEvent) {
        Class<? extends Enum> ocsEvent = this.mapEnums.get(ccsStateEvent.getClass());
        if (ocsEvent == null) {
            return null;
        }
        String name = ccsStateEvent.name();
        for (Enum ocsEnum : ocsEvent.getEnumConstants()) {
            if (!ocsEnum.name().equals(name)) continue;
            return ocsEnum;
        }
        throw new RuntimeException("Could not find equivalent Enum for input: " + ccsStateEvent);
    }

    public CameraStateChangeEvent convert(CCSTimeStamp when, Enum ccsEnum) throws RuntimeException {
        Enum enumForOCS = this.getEnum(ccsEnum);
        Class<? extends CameraStateChangeEvent> ocsStateChangeEvent = this.mapEnumToClass.get(ccsEnum.getClass());
        if (enumForOCS == null || ocsStateChangeEvent == null) {
            return null;
        }
        try {
            if (ocsStateChangeEvent == SummaryStateEvent.class) {
                Constructor<? extends CameraStateChangeEvent> constructor = ocsStateChangeEvent.getConstructor(enumForOCS.getClass());
                return constructor.newInstance(enumForOCS);
            }
            Constructor<? extends CameraStateChangeEvent> constructor = ocsStateChangeEvent.getConstructor(enumForOCS.getClass(), Double.TYPE);
            return constructor.newInstance(enumForOCS, when.getTAIDouble());
        }
        catch (ReflectiveOperationException x) {
            throw new RuntimeException("Error constructing CameraStateChangeEvent for ccsEnum " + ccsEnum, x);
        }
    }
}

