/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.AbstractArchiveDetector;
import de.schlichtherle.io.ArchiveDriverRegistry;
import de.schlichtherle.io.GlobalArchiveDriverRegistry;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.util.SuffixSet;
import de.schlichtherle.util.regex.ThreadLocalMatcher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;

public class DefaultArchiveDetector
extends AbstractArchiveDetector
implements Serializable {
    private static final long serialVersionUID = 848158760183179884L;
    public static final String DEFAULT_SUFFIXES;
    public static final String ALL_SUFFIXES;
    private final ArchiveDriverRegistry registry;
    private final String list;
    private transient ThreadLocalMatcher matcher;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultArchiveDetector(String list) {
        this.registry = GlobalArchiveDriverRegistry.INSTANCE;
        SuffixSet set = new SuffixSet(list);
        SuffixSet all = this.registry.suffixes();
        if (set.retainAll(all)) {
            SuffixSet unknown = new SuffixSet(list);
            unknown.removeAll(all);
            throw new IllegalArgumentException("\"" + unknown + "\" (no archive driver installed for these suffixes)");
        }
        this.list = set.toString();
        this.matcher = new ThreadLocalMatcher(set.toRegex());
    }

    public DefaultArchiveDetector(String list, ArchiveDriver driver) {
        this(NULL, list, driver);
    }

    public DefaultArchiveDetector(DefaultArchiveDetector delegate, String list, ArchiveDriver driver) {
        this(delegate, new Object[]{list, driver});
    }

    public DefaultArchiveDetector(DefaultArchiveDetector delegate, Object[] config) {
        this(delegate, DefaultArchiveDetector.toMap(config));
    }

    public DefaultArchiveDetector(DefaultArchiveDetector delegate, Map config) {
        this.registry = new ArchiveDriverRegistry(delegate.registry, config);
        SuffixSet set = this.registry.decorate(new SuffixSet(delegate.list));
        this.list = set.toString();
        this.matcher = new ThreadLocalMatcher(set.toRegex());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.matcher = new ThreadLocalMatcher(new SuffixSet(this.list).toRegex());
    }

    private static Map toMap(Object[] config) {
        if (config == null) {
            return null;
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>((int)((double)config.length / 0.75) + 1);
        int l = config.length;
        for (int i = 0; i < l; ++i) {
            map.put(config[i], config[++i]);
        }
        return map;
    }

    public ArchiveDriver getArchiveDriver(String path) {
        Matcher m = this.matcher.reset(path);
        if (!m.matches()) {
            return null;
        }
        ArchiveDriver driver = this.registry.getArchiveDriver(m.group(1).toLowerCase(Locale.ENGLISH));
        if (!$assertionsDisabled && driver == null) {
            throw new AssertionError((Object)"archive driver does not exist for a recognized suffix");
        }
        return driver;
    }

    public String getSuffixes() {
        return this.list;
    }

    static {
        $assertionsDisabled = !DefaultArchiveDetector.class.desiredAssertionStatus();
        DEFAULT_SUFFIXES = GlobalArchiveDriverRegistry.INSTANCE.defaultSuffixes;
        ALL_SUFFIXES = GlobalArchiveDriverRegistry.INSTANCE.allSuffixes;
    }
}

