/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestAscii {
    protected final Ascii dev;

    public TestAscii() {
        this.dev = new Ascii();
    }

    public TestAscii(Ascii dev) {
        this.dev = dev;
    }

    @Command(description="Set options")
    public void setOptions(@Argument(description="Device options") Ascii.Option option) {
        this.dev.setOptions(option);
    }

    @Command(description="Set default baud rate")
    public void setDefaultBaud(@Argument(description="Default baud rsate") int baud) {
        this.dev.setDefaultBaud(baud);
    }

    @Command(description="Set default network port")
    public void setDefaultPort(@Argument(description="Default parameter") int port) {
        this.dev.setDefaultPort(port);
    }

    @Command(description="Open connection to general device")
    public void open(@Argument(description="Connection type: net or serial") DriverConstants.ConnType type, @Argument(description="Device identifier") String ident, @Argument(description="Device parameter") int param) throws DriverException {
        this.dev.open(type, ident, param);
    }

    @Command(description="Open connection to general device")
    public void open(@Argument(description="Connection type: net or serial") DriverConstants.ConnType type, @Argument(description="Device identifier") String ident) throws DriverException {
        this.dev.open(type, ident);
    }

    @Command(description="Open connection to network device")
    public void openNet(@Argument(description="Host name") String host, @Argument(description="Port number") int port) throws DriverException {
        this.dev.openNet(host, port);
    }

    @Command(description="Open connection to network device")
    public void openNet(@Argument(description="Host name") String host) throws DriverException {
        this.dev.openNet(host);
    }

    @Command(description="Open connection to serial device")
    public void openSerial(@Argument(description="Device name") String devc, @Argument(description="Baud rate") int baud, @Argument(description="The number of data bits") Ascii.DataBits dbits, @Argument(description="The number of stop bits") Ascii.StopBits sbits, @Argument(description="The parity") Ascii.Parity parity, @Argument(description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        this.dev.openSerial(devc, baud, Ascii.makeDataCharacteristics(dbits, sbits, parity, flow));
    }

    @Command(description="Open connection to serial device")
    public void openSerial(@Argument(description="Device name") String devc, @Argument(description="Baud rate") int baud) throws DriverException {
        this.dev.openSerial(devc, baud);
    }

    @Command(description="Open connection to serial device")
    public void openSerial(@Argument(description="Device name") String devc) throws DriverException {
        this.dev.openSerial(devc);
    }

    @Command(description="Close connection to device")
    public void close() throws DriverException {
        this.dev.close();
    }

    @Command(description="Write command to device")
    public void write(@Argument(description="Command word") String command, String ... args) throws DriverException {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(" ").append(arg);
        }
        this.dev.write(TestAscii.makeCommandString(command, args));
    }

    @Command(description="Read response from device")
    public String read() throws DriverException {
        return this.dev.read();
    }

    @Command(description="Write command and read response")
    public String read(@Argument(description="Command word") String command, String ... args) throws DriverException {
        return this.dev.read(TestAscii.makeCommandString(command, args));
    }

    @Command(description="Set read response timeout")
    public void setTimeout(@Argument(description="Timeout value (msec)") int time) throws DriverException {
        this.dev.setTimeout(time);
    }

    @Command(description="Show read response timeout (msec)")
    public int showTimeout() {
        return this.dev.getTimeout();
    }

    @Command(description="Set network connection timeout")
    public void setConnTimeout(@Argument(description="Timeout value (msec)") int time) {
        this.dev.setConnTimeout(time);
    }

    @Command(description="Show network connection timeout (msec)")
    public int showConnTimeout() {
        return this.dev.getConnTimeout();
    }

    @Command(description="Set command terminator")
    public void setCommandTerm(@Argument(description="Terminator enum") Ascii.Terminator term) {
        this.dev.setCommandTerm(term);
    }

    @Command(description="Set response terminator")
    public void setResponseTerm(@Argument(description="Terminator enum") Ascii.Terminator term) {
        this.dev.setResponseTerm(term);
    }

    @Command(description="Set both terminators")
    public void setTerminator(@Argument(description="Terminator enum") Ascii.Terminator term) {
        this.dev.setTerminator(term);
    }

    protected static String makeCommandString(String command, String ... args) {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(' ').append(arg);
        }
        return cmnd.toString();
    }
}

