/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.chiller;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.chiller.Chiller;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestChiller {
    private final Chiller chiller = new Chiller();

    @Command(name="open", description="Open connection to chiller")
    public void open(@Argument(description="Host name") String host, @Argument(description="Port number", defaultValue="9760") int port) throws DriverException {
        this.chiller.open(host, port);
    }

    @Command(name="close", description="Close connection to chiller")
    public void close() throws DriverException {
        this.chiller.close();
    }

    @Command(name="setDebug", description="set debug mode true/false")
    public void setDebug(@Argument(description="true/false") boolean debug) {
        this.chiller.setDebug(debug);
    }

    @Command(name="listQueries", description="List available queries")
    public String listQueries() {
        return this.chiller.listQueries();
    }

    @Command(name="listNamedParameters", description="List parameters available for public setting")
    public String listNamedParameters() {
        return this.chiller.listNamedParameters();
    }

    @Command(name="listStatusBits", description="List status register bits")
    public String listStatusBits() {
        return this.chiller.listStatusBits();
    }

    @Command(name="queryChiller", description="send specified query to chiller")
    public String queryChiller(@Argument(description="Read Enumerated quantity from Chiller") Chiller.Query quantity) throws DriverException {
        String response = this.chiller.queryChiller(quantity);
        return response;
    }

    @Command(name="showTemperature", description="numerical value of a temperature reading or set-point")
    public String showTemperature(@Argument(description="which quantity") Chiller.Query quantity) throws DriverException {
        String temp = "Example of getTemperature " + quantity.toString() + ":  " + this.chiller.getTemperature(quantity);
        return temp;
    }

    @Command(name="showFlow", description="numerical value of a flow reading or set-point")
    public String showFlow(@Argument(description="which quantity") Chiller.Query quantity) throws DriverException {
        String flow = "Example of getFlow " + quantity.toString() + ":  " + this.chiller.getFlow(quantity);
        return flow;
    }

    @Command(name="showPressure", description="numerical value of a pressure reading")
    public String showPressure(@Argument(description="which quantity") Chiller.Query quantity) throws DriverException {
        String pressure = "Example of getPresssure " + quantity.toString() + ":  " + this.chiller.getPressure(quantity);
        return pressure;
    }

    @Command(name="showFill", description="numerical value of a fill reading")
    public String showFill(@Argument(description="which quantity") Chiller.Query quantity) throws DriverException {
        String fill = "Example of getFill " + quantity.toString() + ":  " + this.chiller.getFill(quantity);
        return fill;
    }

    @Command(name="showLifetime", description="numerical value of lifetime")
    public String showLifetime(@Argument(description="which quantity") Chiller.Life quantity) throws DriverException {
        String lifetime = "Example of getLifetime " + quantity.getDescription() + ":  " + this.chiller.getLifetime(quantity);
        return lifetime;
    }

    @Command(name="showHeatCool", description="numerical values of heat/cool percentages")
    public String showHeatCool() throws DriverException {
        double[] percentages = this.chiller.getHeatCool();
        String heatcool = "Heat, Cool percentages = " + percentages[0] + ", " + percentages[1];
        return heatcool;
    }

    @Command(name="showEvtReg", description="Show decoded Event Register")
    public String showEvtReg() throws DriverException {
        return this.chiller.decodeEvtReg();
    }

    @Command(name="showStatusReg", description="Show decoded Status Register")
    public String showStatusReg() throws DriverException {
        return this.chiller.decodeStatusReg();
    }

    @Command(name="showErrorWords", description="Show error and warning words in hex")
    public String showErrorWords() throws DriverException {
        return this.chiller.getErrorWords().toString();
    }

    @Command(name="readParameter", description="Read value of specified parameter")
    public String readParameter(@Argument(description="index of parameter") int index) throws DriverException {
        return this.chiller.readParameter(index);
    }

    @Command(name="readNamedParameter", description="Read value of named parameter")
    public String readNamedParameter(@Argument(description="enum of parameter") Chiller.FParam param) throws DriverException {
        return this.chiller.readNamedParameter(param);
    }

    @Command(name="setAnyParameter", description="Set value of specified parameter")
    public void setAnyParameter(@Argument(description="index of parameter") int index, @Argument(description="value to be set") String value) throws DriverException {
        this.chiller.setParameter(index, value);
    }

    @Command(name="setAndReadAnyParameter", description="Set value of specified paramete and read it backr")
    public String setAndReadAnyParameter(@Argument(description="index of parameter") int index, @Argument(description="value to set") String value) throws DriverException {
        return this.chiller.setAndReadParameter(index, value);
    }

    @Command(name="setParam", description="Invoke Chiller command tp set named parameter")
    public void setParam(@Argument(description="enumerated parameter") Chiller.FParam param, @Argument(description="parameter value") double value) throws DriverException {
        this.chiller.setParamCommand(param, value);
    }

    @Command(name="selectDUT", description="Select DUT vs Normal temperature-control mode")
    public void selectDUT(@Argument(description="true for DUT") boolean dut) throws DriverException {
        this.setParam(Chiller.FParam.T_CTRL_MODE, dut ? 1.0 : 0.0);
    }

    @Command(name="setTemperature", description="go to temperature setting using default ramp")
    public void setTemperature(@Argument(description="tempeature in degrees") double temperature) throws DriverException {
        this.chiller.setTemperature(temperature);
    }

    @Command(name="setTemperatureWithRaRamp", description="go to temperature setting using provided ramp")
    public void setTemperatureWithRamp(@Argument(description="tempeature in degrees") double temperature, @Argument(description="ramp in degrees/min") double ramp) throws DriverException {
        this.chiller.setTemperatureWithRamp(temperature, ramp);
    }

    @Command(name="setFlow", description="go to temperature setting using default ramp")
    public void setFlow(@Argument(description="flow rate in gpm") double flow) throws DriverException {
        this.chiller.setFlow(flow);
    }

    @Command(name="clearErrors", description="clear chiller errpr and warning words")
    public void clearErrors() throws DriverException {
        this.chiller.clearErrors();
    }

    @Command(name="sendDebugCommand", description="Send non-query command to chiller, debug-mode")
    public void sendDebugCommand(@Argument(description="command String") String command, String ... args) throws DriverException {
        this.chiller.sendDirectCommand(command, args);
    }
}

