/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.logging.Level;
import java.util.logging.Logger;

public class PIDController {
    private static final Logger LOG = Logger.getLogger(PIDController.class.getName());
    private double coefP = 3.0;
    private double coefI = 1.0;
    private double coefD = 0.0;
    private double timeConst = 100.0;
    private double smoothTime = 30.0;
    private double maxOutput = 100.0;
    private double minOutput = 0.0;
    private double maxInput = 0.0;
    private double minInput = 0.0;
    private double setpoint = 0.0;
    private double baseOutput = 0.0;
    private double aveInput;
    private double input = 0.0;
    private double error = 0.0;
    private double integral = 0.0;
    private double lastError = 0.0;
    private double lastDerivative = 0.0;
    private double lastDeltaIntegral = 0.0;
    private double measTime;
    private double lastTime = 0.0;
    private double lastOutput = 0.0;
    private String callerName = "unknown";

    public PIDController(String callerPath) {
        this.callerName = callerPath;
    }

    public double performPID(double[] input, double time) {
        this.aveInput = 0.0;
        for (double mInput : input) {
            this.aveInput += mInput / (double)input.length;
        }
        this.measTime = time;
        return this.calculate();
    }

    public void setTimeConst(double time) {
        this.timeConst = time;
    }

    public void setSmoothTime(double time) {
        this.smoothTime = time;
    }

    public void setCoefP(double value) {
        this.coefP = value;
    }

    public void setCoefI(double value) {
        this.coefI = value;
    }

    public void setCoefD(double value) {
        this.coefD = value;
    }

    public double getCoefP() {
        return this.coefP;
    }

    public double getCoefI() {
        return this.coefI;
    }

    public double getCoefD() {
        return this.coefD;
    }

    public double getTimeConst() {
        return this.timeConst;
    }

    public void setBaseOutput(double value) {
        this.baseOutput = value;
    }

    public void setInputRange(double minimumInput, double maximumInput) {
        this.minInput = minimumInput;
        this.maxInput = maximumInput;
        this.setSetpoint(this.setpoint);
    }

    public void setOutputRange(double minimumOutput, double maximumOutput) {
        this.minOutput = minimumOutput;
        this.maxOutput = maximumOutput;
    }

    public void setSetpoint(double setpnt) {
        this.setpoint = this.maxInput <= this.minInput ? setpnt : (setpnt > this.maxInput ? this.maxInput : (setpnt < this.minInput ? this.minInput : setpnt));
    }

    public double getSetpoint() {
        return this.setpoint;
    }

    public double getError() {
        return this.error;
    }

    public double getIntegral() {
        return this.integral;
    }

    public void setIntegral(double value) {
        this.integral = value;
    }

    public double getInput() {
        return this.input;
    }

    public void reset() {
        this.integral = 0.0;
        this.lastTime = Double.NaN;
        this.lastError = Double.NaN;
        this.lastDerivative = 0.0;
        this.lastOutput = 0.0;
    }

    private double calculate() {
        double output;
        double deltaIntegral = 0.0;
        double derivative = 0.0;
        double smoothTimeEff = this.smoothTime;
        double maxStep = (this.maxOutput - this.minOutput) / 4.0;
        if (Double.isNaN(this.lastTime)) {
            this.lastTime = this.measTime - 1.0;
            this.input = this.aveInput;
        }
        if (this.measTime <= this.lastTime) {
            return this.lastOutput;
        }
        double deltaTime = this.measTime - this.lastTime;
        if (smoothTimeEff < deltaTime) {
            smoothTimeEff = deltaTime;
        }
        if (this.timeConst > smoothTimeEff) {
            maxStep = (this.maxOutput - this.minOutput) * smoothTimeEff / this.timeConst;
        }
        this.input = (deltaTime * this.aveInput + (smoothTimeEff - deltaTime) * this.input) / smoothTimeEff;
        this.error = this.setpoint - this.input;
        if (this.timeConst > 0.0) {
            deltaIntegral = this.error * deltaTime / this.timeConst;
        }
        if (!Double.isNaN(this.lastError)) {
            derivative = smoothTimeEff * (this.error - this.lastError) / deltaTime;
        }
        if ((output = this.coefP * this.error + this.coefI * (this.integral + deltaIntegral) + this.coefD * derivative) > this.maxOutput) {
            output = this.maxOutput;
        } else if (output < this.minOutput) {
            output = this.minOutput;
        } else {
            this.integral += deltaIntegral;
        }
        output = output > this.lastOutput + maxStep ? this.lastOutput + maxStep : output;
        this.lastError = this.error;
        this.lastTime = this.measTime;
        this.lastOutput = output;
        this.lastDerivative = derivative;
        this.lastDeltaIntegral = deltaIntegral;
        LOG.log(Level.FINE, () -> String.format("%s: raw input      = %.2f", this.callerName, this.aveInput));
        LOG.log(Level.FINE, () -> String.format("%s: smoothed input = %.2f", this.callerName, this.input));
        LOG.log(Level.FINE, () -> String.format("%s: error          = %.4f", this.callerName, this.error));
        LOG.log(Level.FINE, () -> String.format("%s: deltaTime      = %.4f", this.callerName, deltaTime));
        LOG.log(Level.FINE, () -> String.format("%s: deltaIntegral  = %.4f", this.callerName, this.lastDeltaIntegral));
        LOG.log(Level.FINE, () -> String.format("%s: integral       = %.4f", this.callerName, this.integral));
        LOG.log(Level.FINE, () -> String.format("%s: derivative     = %.4f", this.callerName, this.lastDerivative));
        LOG.log(Level.FINE, () -> String.format("%s: output         = %.4f", this.callerName, this.lastOutput + this.baseOutput));
        return output + this.baseOutput;
    }
}

