/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.motrona;

import java.util.Date;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.motrona.MotronaIV251;

public class TestIV251 {
    private final MotronaIV251 iv251 = new MotronaIV251();

    @Command(name="timestamp", description="Prints current time")
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }

    @Command(name="open", description="Open default connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.iv251.open(ident);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident, @Argument(name="baud", description="baud rate in Hz") int baudRate, @Argument(name="format", description="enumerated data characteristics") MotronaIV251.SerialFormat format) throws DriverException {
        this.iv251.openSerial(ident, baudRate, format.getOpenFormat());
    }

    @Command(name="close", description="Closes connection to device")
    public void close() throws DriverException {
        this.iv251.close();
    }

    @Command(name="readAll", description="Read all IV251 settings and data")
    public String readAll() {
        String table = "Read all IV251 settings and data\n" + this.timestamp() + "\n";
        MotronaIV251.CmndParam[] cmndN = MotronaIV251.CmndParam.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndN[i]});
            try {
                int respN = this.iv251.readParam(cmndN[i]);
                table = table + String.format("%d", respN);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        table = table + String.format("\n   %-22s", "Encoder position");
        try {
            int pos = this.iv251.readEncoder();
            table = table + String.format("%d", pos);
        }
        catch (DriverException ex) {
            table = table + ex.getMessage();
        }
        table = table + String.format("\n   %-22s", "Encoder error");
        try {
            int err = this.iv251.readErrorBit();
            table = table + String.format("%d", err);
        }
        catch (DriverException ex) {
            table = table + ex.getMessage();
        }
        table = table + "\n";
        return table;
    }

    @Command(name="readSerialSettings", description="Read and decode settings")
    public String readSerialSettings() throws DriverException {
        MotronaIV251.SerialRate rate = MotronaIV251.SerialRate.decode(this.iv251.readParam(MotronaIV251.CmndParam.SERIAL_BAUD_RATE));
        MotronaIV251.SerialFormat format = MotronaIV251.SerialFormat.decode(this.iv251.readParam(MotronaIV251.CmndParam.SERIAL_FORMAT));
        return "IV251 serial baud rate = " + rate.toString() + ",  format = " + format.toString();
    }

    @Command(name="readPosition", description="Read encoder position")
    public int readPosition() throws DriverException {
        return this.iv251.readEncoder();
    }

    @Command(name="readEncoderError", description="<1|0> if <encoder error|no encoder error>")
    public int readEncoderError() throws DriverException {
        return this.iv251.readErrorBit();
    }

    @Command(name="setParameter", description="Set parameter value (pending activate command)")
    public void setParameter(@Argument(name=" enumerated CmndParam") MotronaIV251.CmndParam param, @Argument(name="int value") int value) throws DriverException {
        this.iv251.setParam(param, value);
    }

    @Command(name="repeatSetParameter", description="Set parameter value multiple times in succession")
    public void repeatSetParameter(@Argument(name=" enumerated CmndParam") MotronaIV251.CmndParam param, @Argument(name="int value") int value, @Argument(name="repetitions") int reps) throws DriverException {
        if (reps > 0) {
            for (int i = 0; i < reps; ++i) {
                this.iv251.setParam(param, value);
            }
        }
    }

    @Command(name="activateNewSettings", description="copy settings to registers")
    public void acivateNewSettings() throws DriverException {
        this.iv251.activateData();
    }

    @Command(name="setAndActivateParameter", description="Set and activate parameter value")
    public void setAndActivateParameter(@Argument(name=" enumerated CmndParam") MotronaIV251.CmndParam param, @Argument(name="int value") int value) throws DriverException {
        this.iv251.setAndActivateParam(param, value);
    }

    @Command(name="setDataRate", description="Set baud rate.  Danger: last-resort reset only!")
    public void setDataRate(@Argument(name=" 600 to 38400", description="Motrona IV251 baud rate setting") int value) throws DriverException {
        this.iv251.setBaudRate(value);
    }

    @Command(name="setSerialFormat", description="Set setiral format.  Danger: last-resort reset only!")
    public void setSerialFormat(@Argument(name=" <enumerated format>", description="Motrona IV251 serial format setting") MotronaIV251.SerialFormat format) throws DriverException {
        this.iv251.setFormat(format);
    }

    @Command(name="listSerialFormats", description="list of enum names")
    public String listSerialFormats() {
        MotronaIV251.SerialFormat[] form = MotronaIV251.SerialFormat.values();
        String listf = "MotronIV251.SerialFormat enum instances";
        for (int i = 0; i < form.length; ++i) {
            listf = listf + "\n   " + form[i].toString();
        }
        return listf;
    }

    @Command(name="saveSettings", description="Save settings to EEProm for next power-up")
    public void saveSettings() throws DriverException {
        this.iv251.saveToEEProm();
    }

    @Command(name="setDebug", description="set debug mode <true|false>")
    public void setDebug(@Argument(name="<true|false>", description="debug mode") boolean mode) {
        this.iv251.debug = mode;
    }

    @Command(name="setDelay", description="set delay after hardware command")
    public void setDelay(@Argument(name="delay", description="in ms") long delay) {
        this.iv251.delay = delay;
    }
}

