/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class ChillerLatches {
    public static final int LATCH_SMOKE_DETC = 0;
    public static final int LATCH_PERMIT = 1;
    public static final int LATCH_EXT_EMO = 2;
    public static final int LATCH_BD_SUPPLY_P = 3;
    public static final int LATCH_BD_RETURN_P = 4;
    public static final int LATCH_LEAK_DETC = 5;
    public static final int LATCH_LEAK_FAULT = 6;
    public static final int NUM_LATCHES = 7;
    private static final Map<String, Integer> NAME_MAP = new LinkedHashMap<String, Integer>();
    private static final Map<Integer, String> ID_MAP;

    public static List<String> getNames() {
        return new ArrayList<String>(NAME_MAP.keySet());
    }

    public static String getName(int id) {
        return ID_MAP.get(id);
    }

    public static int getId(String name) throws RefrigException {
        Integer id = NAME_MAP.get(name);
        if (id == null) {
            throw new RefrigException("Invalid latch name: " + name);
        }
        return id;
    }

    static {
        NAME_MAP.put("SmokeDetc", 0);
        NAME_MAP.put("Permit", 1);
        NAME_MAP.put("ExtEMO", 2);
        NAME_MAP.put("BDSupplyP", 3);
        NAME_MAP.put("BDReturnP", 4);
        NAME_MAP.put("LeakDetc", 5);
        NAME_MAP.put("LeakDetcFault", 6);
        ID_MAP = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> e : NAME_MAP.entrySet()) {
            ID_MAP.put((int)e.getValue(), e.getKey());
        }
    }
}

