/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Digest;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Promise;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@Deprecated(since="5.3.5", forRemoval=true)
@MBean(description="Flushes the cluster")
public class FLUSH
extends Protocol {
    private static final FlushStartResult SUCCESS_START_FLUSH = new FlushStartResult(Boolean.TRUE, null);
    @Property(description="Max time to keep channel blocked in flush. Default is 8000 msec", type=AttributeType.TIME)
    protected long timeout = 8000L;
    @Property(description="Timeout (per atttempt) to quiet the cluster during the first flush phase. Default is 2000 msec", type=AttributeType.TIME)
    protected long start_flush_timeout = 2000L;
    @Property(description="Timeout to wait for UNBLOCK after STOP_FLUSH is issued. Default is 2000 msec", type=AttributeType.TIME)
    protected long end_flush_timeout = 2000L;
    @Property(description="Retry timeout after an unsuccessful attempt to quiet the cluster (first flush phase).Default is 3000 msec", type=AttributeType.TIME)
    protected long retry_timeout = 2000L;
    @Property(description="Reconciliation phase toggle. Default is true")
    protected boolean enable_reconciliation = true;
    @Property(description="When set, FLUSH is bypassed, same effect as if FLUSH wasn't in the config at all")
    protected boolean bypass = false;
    private long startFlushTime;
    private long totalTimeInFlush;
    private int numberOfFlushes;
    private double averageFlushDuration;
    private View currentView = new View(new ViewId(), new ArrayList<Address>());
    private Address flushCoordinator;
    private final List<Address> flushMembers = new ArrayList<Address>();
    private final AtomicInteger viewCounter = new AtomicInteger(0);
    private final Map<Address, Digest> flushCompletedMap = new HashMap<Address, Digest>();
    private final List<Address> flushNotCompletedMap = new ArrayList<Address>();
    private final Set<Address> suspected = new TreeSet<Address>();
    private final List<Address> reconcileOks = new ArrayList<Address>();
    private final Object sharedLock = new Object();
    private final ReentrantLock blockMutex = new ReentrantLock();
    private final Condition notBlockedDown = this.blockMutex.newCondition();
    @ManagedAttribute(description="Is message sending currently blocked")
    private volatile boolean isBlockingFlushDown = true;
    private boolean flushCompleted = false;
    private final Promise<FlushStartResult> flush_promise = new Promise();
    private final Promise<Boolean> flush_unblock_promise = new Promise();
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final AtomicBoolean sentBlock = new AtomicBoolean(false);
    private final AtomicBoolean sentUnblock = new AtomicBoolean(false);

    public long getStartFlushTimeout() {
        return this.start_flush_timeout;
    }

    public FLUSH setStartFlushTimeout(long start_flush_timeout) {
        this.start_flush_timeout = start_flush_timeout;
        return this;
    }

    public long getRetryTimeout() {
        return this.retry_timeout;
    }

    public FLUSH setRetryTimeout(long retry_timeout) {
        this.retry_timeout = retry_timeout;
        return this;
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("flush_supported", Boolean.TRUE);
        this.up_prot.up(new Event(56, map));
        this.down_prot.down(new Event(56, map));
        this.viewCounter.set(0);
        this.blockMutex.lock();
        try {
            this.isBlockingFlushDown = true;
        }
        finally {
            this.blockMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.currentView = new View(new ViewId(), new ArrayList<Address>());
            this.flushCompletedMap.clear();
            this.flushNotCompletedMap.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
        }
    }

    @ManagedAttribute(type=AttributeType.TIME)
    public double getAverageFlushDuration() {
        return this.averageFlushDuration;
    }

    @ManagedAttribute(type=AttributeType.TIME)
    public long getTotalTimeInFlush() {
        return this.totalTimeInFlush;
    }

    @ManagedAttribute
    public int getNumberOfFlushes() {
        return this.numberOfFlushes;
    }

    @ManagedOperation(description="Sets the bypass flag")
    public boolean setBypass(boolean flag) {
        boolean ret = this.bypass;
        this.bypass = flag;
        return ret;
    }

    @ManagedOperation(description="Request cluster flush")
    public void startFlush() {
        this.startFlush(new Event(68));
    }

    private void startFlush(Event evt) {
        List flushParticipants = (List)evt.getArg();
        this.startFlush(flushParticipants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFlush(List<Address> flushParticipants) {
        block11: {
            if (!this.flushInProgress.get()) {
                this.flush_promise.reset();
                Object object = this.sharedLock;
                synchronized (object) {
                    if (flushParticipants == null) {
                        flushParticipants = new ArrayList<Address>(this.currentView.getMembers());
                    }
                }
                this.onSuspend(flushParticipants);
                try {
                    FlushStartResult r = this.flush_promise.getResultWithTimeout(this.start_flush_timeout);
                    if (r.failed()) {
                        throw new RuntimeException(r.getFailureCause());
                    }
                    break block11;
                }
                catch (TimeoutException e) {
                    HashSet<Address> missingMembers;
                    Object object2 = this.sharedLock;
                    synchronized (object2) {
                        missingMembers = new HashSet<Address>(this.flushMembers);
                        missingMembers.removeAll(this.flushCompletedMap.keySet());
                    }
                    this.rejectFlush(flushParticipants, this.currentViewId());
                    throw new RuntimeException(String.valueOf(this.local_addr) + " timed out waiting for flush responses from " + String.valueOf(missingMembers) + " after " + this.start_flush_timeout + " ms. Rejected flush to participants " + String.valueOf(flushParticipants), e);
                }
            }
            throw new RuntimeException("Flush attempt is in progress");
        }
    }

    @ManagedOperation(description="Request end of flush in a cluster")
    public void stopFlush() {
        this.down(new Event(70));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        if (!this.bypass) {
            switch (evt.getType()) {
                case 2: 
                case 92: {
                    return this.handleConnect(evt, true);
                }
                case 80: 
                case 93: {
                    return this.handleConnect(evt, false);
                }
                case 68: {
                    this.startFlush(evt);
                    return null;
                }
                case 94: {
                    if (this.flushInProgress.get()) break;
                    this.flush_promise.reset();
                    ArrayList<Address> flushParticipants = null;
                    Object object = this.sharedLock;
                    synchronized (object) {
                        flushParticipants = new ArrayList<Address>(this.currentView.getMembers());
                    }
                    this.onSuspend(flushParticipants);
                    break;
                }
                case 70: {
                    this.onResume(evt);
                    return null;
                }
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        if (!this.bypass) {
            Address dest = msg.getDest();
            if (dest == null) {
                FlushHeader fh = (FlushHeader)msg.getHeader(this.id);
                if (fh != null && fh.type == 6) {
                    return this.down_prot.down(msg);
                }
                this.blockMessageDuringFlush();
            } else {
                return this.down_prot.down(msg);
            }
        }
        return this.down_prot.down(msg);
    }

    private Object handleConnect(Event evt, boolean waitForUnblock) {
        Object result;
        if (this.sentBlock.compareAndSet(false, true)) {
            this.sendBlockUpToChannel();
        }
        if ((result = this.down_prot.down(evt)) instanceof Throwable) {
            this.sentBlock.set(false);
        }
        if (waitForUnblock) {
            this.waitForUnblock();
        }
        return result;
    }

    private void blockMessageDuringFlush() {
        boolean shouldSuspendByItself = false;
        this.blockMutex.lock();
        try {
            while (this.isBlockingFlushDown) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.valueOf(this.local_addr) + ": blocking for " + (String)(this.timeout <= 0L ? "ever" : this.timeout + "ms"));
                }
                if (this.timeout <= 0L) {
                    this.notBlockedDown.await();
                } else {
                    boolean bl = shouldSuspendByItself = !this.notBlockedDown.await(this.timeout, TimeUnit.MILLISECONDS);
                }
                if (!shouldSuspendByItself) continue;
                this.isBlockingFlushDown = false;
                this.log.warn(String.valueOf(this.local_addr) + ": unblocking after " + this.timeout + "ms");
                this.flush_promise.setResult(new FlushStartResult(Boolean.TRUE, null));
                this.notBlockedDown.signalAll();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.blockMutex.unlock();
        }
    }

    @Override
    public Object up(Event evt) {
        if (!this.bypass) {
            switch (evt.getType()) {
                case 6: {
                    boolean isThisOurFirstView;
                    this.up_prot.up(evt);
                    View newView = (View)evt.getArg();
                    boolean coordinatorLeft = this.onViewChange(newView);
                    boolean singletonMember = newView.size() == 1 && newView.containsMember(this.local_addr);
                    boolean bl = isThisOurFirstView = this.viewCounter.addAndGet(1) == 1;
                    if (isThisOurFirstView && singletonMember || coordinatorLeft) {
                        this.onStopFlush();
                    }
                    return null;
                }
                case 15: {
                    View tmpView = (View)evt.getArg();
                    if (tmpView.containsMember(this.local_addr)) break;
                    this.onViewChange(tmpView);
                    break;
                }
                case 9: {
                    List<Address> suspects = evt.arg() instanceof Address ? Collections.singletonList((Address)evt.arg()) : (List<Address>)evt.arg();
                    this.onSuspect(suspects);
                    break;
                }
                case 68: {
                    this.startFlush(evt);
                    return null;
                }
                case 70: {
                    this.onResume(evt);
                    return null;
                }
                case 75: {
                    this.flush_unblock_promise.setResult(Boolean.TRUE);
                }
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        if (!this.bypass) {
            FlushHeader fh = (FlushHeader)msg.getHeader(this.id);
            if (fh != null) {
                Tuple<Collection<? extends Address>, Digest> tuple = this.readParticipantsAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
                switch (fh.type) {
                    case 6: {
                        return this.up_prot.up(msg);
                    }
                    case 0: {
                        boolean amIParticipant;
                        Collection<? extends Address> fp = tuple.getVal1();
                        boolean bl = amIParticipant = fp != null && fp.contains(this.local_addr) || msg.getSrc().equals(this.local_addr);
                        if (amIParticipant) {
                            this.handleStartFlush(msg, fh);
                            break;
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug(String.valueOf(this.local_addr) + ": received START_FLUSH but I'm not flush participant, not responding");
                        break;
                    }
                    case 7: {
                        this.handleFlushReconcile(msg);
                        break;
                    }
                    case 8: {
                        this.onFlushReconcileOK(msg);
                        break;
                    }
                    case 2: {
                        this.onStopFlush();
                        break;
                    }
                    case 5: {
                        boolean participant;
                        Collection<? extends Address> flushParticipants = tuple.getVal1();
                        boolean bl = participant = flushParticipants != null && flushParticipants.contains(this.local_addr);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.valueOf(this.local_addr) + ": received ABORT_FLUSH from flush coordinator " + String.valueOf(msg.getSrc()) + ",  am I flush participant=" + participant);
                        }
                        if (!participant) break;
                        this.resetForNextFlush();
                        break;
                    }
                    case 9: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.valueOf(this.local_addr) + ": received FLUSH_NOT_COMPLETED from " + String.valueOf(msg.getSrc()));
                        }
                        boolean flushCollision = false;
                        Object object = this.sharedLock;
                        synchronized (object) {
                            this.flushNotCompletedMap.add(msg.getSrc());
                            boolean bl = flushCollision = !this.flushCompletedMap.isEmpty();
                            if (flushCollision) {
                                this.flushNotCompletedMap.clear();
                                this.flushCompletedMap.clear();
                            }
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.valueOf(this.local_addr) + ": received FLUSH_NOT_COMPLETED from " + String.valueOf(msg.getSrc()) + " collision=" + flushCollision);
                        }
                        if (flushCollision) {
                            Runnable r = () -> this.rejectFlush((Collection)tuple.getVal1(), fh.viewID);
                            new Thread(r).start();
                        }
                        this.flush_promise.setResult(new FlushStartResult(Boolean.FALSE, new Exception("Flush failed for " + String.valueOf(msg.getSrc()))));
                        break;
                    }
                    case 3: {
                        if (!this.isCurrentFlushMessage(fh)) break;
                        this.onFlushCompleted(msg.getSrc(), msg, fh);
                    }
                }
                return null;
            }
            if (msg.getDest() != null) {
                return this.up_prot.up(msg);
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.bypass) {
            this.up_prot.up(batch);
            return;
        }
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (msg.getHeader(this.id) != null) {
                it.remove();
                this.up(msg);
                continue;
            }
            if (msg.getDest() == null) continue;
            it.remove();
            this.up_prot.up(msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    private void waitForUnblock() {
        try {
            this.flush_unblock_promise.getResultWithTimeout(this.end_flush_timeout);
        }
        catch (TimeoutException t) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(String.valueOf(this.local_addr) + ": waiting for UNBLOCK timed out after " + this.end_flush_timeout + " ms");
            }
        }
        finally {
            this.flush_unblock_promise.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushReconcileOK(Message msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(this.local_addr) + ": received reconcile ok from " + String.valueOf(msg.getSrc()));
        }
        Object object = this.sharedLock;
        synchronized (object) {
            this.reconcileOks.add(msg.getSrc());
            if (this.reconcileOks.size() >= this.flushMembers.size()) {
                this.flush_promise.setResult(SUCCESS_START_FLUSH);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.valueOf(this.local_addr) + ": all FLUSH_RECONCILE_OK received");
                }
            }
        }
    }

    private void handleFlushReconcile(Message msg) {
        Address requester = msg.getSrc();
        Tuple<Collection<? extends Address>, Digest> tuple = this.readParticipantsAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
        Digest reconcileDigest = tuple.getVal2();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(this.local_addr) + ": received FLUSH_RECONCILE, passing digest to NAKACK " + String.valueOf(reconcileDigest));
        }
        this.down_prot.down(new Event(78, reconcileDigest));
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(this.local_addr) + ": returned from FLUSH_RECONCILE,  sending RECONCILE_OK to " + String.valueOf(requester));
        }
        Message reconcileOk = new EmptyMessage(requester).setFlag(Message.Flag.OOB).putHeader(this.id, new FlushHeader(8));
        this.down_prot.down(reconcileOk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStartFlush(Message msg, FlushHeader fh) {
        Address flushRequester = msg.getSrc();
        boolean proceed = this.flushInProgress.compareAndSet(false, true);
        if (proceed) {
            Object object = this.sharedLock;
            synchronized (object) {
                this.flushCoordinator = flushRequester;
            }
            this.onStartFlush(flushRequester, msg, fh);
        } else {
            Tuple<Collection<? extends Address>, Digest> tuple = this.readParticipantsAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
            Collection<? extends Address> flushParticipants = tuple.getVal1();
            Message response = new BytesMessage(flushRequester).putHeader(this.id, new FlushHeader(9, fh.viewID)).setArray(FLUSH.marshal(flushParticipants, null));
            this.down_prot.down(response);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.valueOf(this.local_addr) + ": received START_FLUSH, responded with FLUSH_NOT_COMPLETED to " + String.valueOf(flushRequester));
            }
        }
    }

    private void rejectFlush(Collection<? extends Address> participants, long viewId) {
        if (participants == null) {
            return;
        }
        for (Address address : participants) {
            if (address == null) continue;
            Message reject = new BytesMessage(address).setSrc(this.local_addr).setFlag(Message.Flag.OOB).putHeader(this.id, new FlushHeader(5, viewId)).setArray(FLUSH.marshal(participants, null));
            this.down_prot.down(reject);
        }
    }

    @Override
    public List<Integer> providedDownServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>(2);
        retval.add(68);
        retval.add(70);
        return retval;
    }

    private void sendBlockUpToChannel() {
        this.up(new Event(10));
        this.sentUnblock.set(false);
    }

    private void sendUnBlockUpToChannel() {
        this.sentBlock.set(false);
        this.up(new Event(75));
    }

    private boolean isCurrentFlushMessage(FlushHeader fh) {
        return fh.viewID == this.currentViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long currentViewId() {
        long viewId = -1L;
        Object object = this.sharedLock;
        synchronized (object) {
            ViewId view = this.currentView.getViewId();
            if (view != null) {
                viewId = view.getId();
            }
        }
        return viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onViewChange(View view) {
        boolean coordinatorLeft = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.suspected.retainAll(view.getMembers());
            View oldView = this.currentView;
            this.currentView = view;
            coordinatorLeft = !oldView.getMembers().isEmpty() && !view.getMembers().isEmpty() && !view.containsMember(oldView.getCreator());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(this.local_addr) + ": installing view " + String.valueOf(view));
        }
        return coordinatorLeft;
    }

    private void onStopFlush() {
        if (this.stats && this.startFlushTime > 0L) {
            long stopFlushTime = System.currentTimeMillis();
            this.totalTimeInFlush += stopFlushTime - this.startFlushTime;
            if (this.numberOfFlushes > 0) {
                this.averageFlushDuration = (double)this.totalTimeInFlush / (double)this.numberOfFlushes;
            }
            this.startFlushTime = 0L;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.valueOf(this.local_addr) + ": received STOP_FLUSH, unblocking FLUSH.down() and sending UNBLOCK up");
        }
        this.resetForNextFlush();
        if (this.sentUnblock.compareAndSet(false, true)) {
            this.sendUnBlockUpToChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetForNextFlush() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedMap.clear();
            this.flushNotCompletedMap.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
            this.flushCompleted = false;
        }
        this.blockMutex.lock();
        try {
            this.isBlockingFlushDown = false;
            this.notBlockedDown.signalAll();
        }
        finally {
            this.blockMutex.unlock();
        }
        this.flushInProgress.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspend(List<Address> members) {
        List<Address> participantsInFlush = null;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCoordinator = this.local_addr;
            participantsInFlush = members;
            participantsInFlush.retainAll(this.currentView.getMembers());
            this.flushMembers.clear();
            this.flushMembers.addAll(participantsInFlush);
            this.flushMembers.removeAll(this.suspected);
        }
        if (participantsInFlush.isEmpty()) {
            this.flush_promise.setResult(SUCCESS_START_FLUSH);
        } else {
            Message msg = new BytesMessage(null).setSrc(this.local_addr).setArray(FLUSH.marshal(participantsInFlush, null)).putHeader(this.id, new FlushHeader(0, this.currentViewId()));
            this.down_prot.down(msg);
            this.log.debug("%s: flush coordinator is starting FLUSH with participants %s", this.local_addr, participantsInFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResume(Event evt) {
        List members = (List)evt.getArg();
        long viewID = this.currentViewId();
        boolean isParticipant = false;
        Iterator iterator = this.sharedLock;
        synchronized (iterator) {
            isParticipant = this.flushMembers.contains(this.local_addr) || members != null && members.contains(this.local_addr);
        }
        if (members == null || members.isEmpty()) {
            Message msg = new EmptyMessage(null).setSrc(this.local_addr);
            this.log.debug(String.valueOf(this.local_addr) + ": received RESUME, sending STOP_FLUSH to all");
            msg.putHeader(this.id, new FlushHeader(2, viewID));
            this.down_prot.down(msg);
        } else {
            for (Address address : members) {
                Message msg = new EmptyMessage(address).setSrc(this.local_addr);
                this.log.debug(String.valueOf(this.local_addr) + ": received RESUME, sending STOP_FLUSH to " + String.valueOf(address));
                msg.putHeader(this.id, new FlushHeader(2, viewID));
                this.down_prot.down(msg);
            }
        }
        if (isParticipant) {
            this.waitForUnblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartFlush(Address flushStarter, Message msg, FlushHeader fh) {
        if (this.stats) {
            this.startFlushTime = System.currentTimeMillis();
            ++this.numberOfFlushes;
        }
        boolean proceed = false;
        boolean amIFlushInitiator = false;
        Tuple<Collection<? extends Address>, Digest> tuple = this.readParticipantsAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
        Object object = this.sharedLock;
        synchronized (object) {
            amIFlushInitiator = flushStarter.equals(this.local_addr);
            if (!amIFlushInitiator) {
                this.flushCoordinator = flushStarter;
                this.flushMembers.clear();
                if (tuple.getVal1() != null) {
                    this.flushMembers.addAll(tuple.getVal1());
                }
                this.flushMembers.removeAll(this.suspected);
            }
            proceed = this.flushMembers.contains(this.local_addr);
        }
        if (proceed) {
            if (this.sentBlock.compareAndSet(false, true)) {
                this.sendBlockUpToChannel();
                this.blockMutex.lock();
                try {
                    this.isBlockingFlushDown = true;
                }
                finally {
                    this.blockMutex.unlock();
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug(String.valueOf(this.local_addr) + ": received START_FLUSH, but not sending BLOCK up");
            }
            Digest digest = (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
            Message start_msg = new BytesMessage(flushStarter).putHeader(this.id, new FlushHeader(3, fh.viewID)).setArray(FLUSH.marshal(tuple.getVal1(), digest));
            this.down_prot.down(start_msg);
            this.log.debug(String.valueOf(this.local_addr) + ": received START_FLUSH, responded with FLUSH_COMPLETED to " + String.valueOf(flushStarter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted(Address address, Message m, FlushHeader header) {
        Message msg = null;
        boolean needsReconciliationPhase = false;
        boolean collision = false;
        Tuple<Collection<? extends Address>, Digest> tuple = this.readParticipantsAndDigest(m.getArray(), m.getOffset(), m.getLength());
        Digest digest = tuple.getVal2();
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedMap.put(address, digest);
            this.flushCompleted = this.flushCompletedMap.size() >= this.flushMembers.size() && !this.flushMembers.isEmpty() && this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            boolean bl = collision = !this.flushNotCompletedMap.isEmpty();
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.valueOf(this.local_addr) + ": FLUSH_COMPLETED from " + String.valueOf(address) + ", completed " + this.flushCompleted + ", flushMembers " + String.valueOf(this.flushMembers) + ", flushCompleted " + String.valueOf(this.flushCompletedMap.keySet()));
            }
            boolean bl2 = needsReconciliationPhase = this.enable_reconciliation && this.flushCompleted && this.hasVirtualSynchronyGaps();
            if (needsReconciliationPhase) {
                Digest d = this.findHighestSequences(this.currentView);
                this.reconcileOks.clear();
                msg = new BytesMessage(null, FLUSH.marshal(this.flushMembers, d)).setFlag(Message.Flag.OOB).putHeader(this.id, new FlushHeader(7, this.currentViewId()));
                this.log.debug("%s : reconciling flush mebers due to virtual synchrony gap, digest is %s, flush members are %s", this.local_addr, d, this.flushMembers);
                this.flushCompletedMap.clear();
            } else if (this.flushCompleted) {
                this.flushCompletedMap.clear();
            } else if (collision) {
                this.flushNotCompletedMap.clear();
                this.flushCompletedMap.clear();
            }
        }
        if (needsReconciliationPhase) {
            this.down_prot.down(msg);
        } else if (this.flushCompleted) {
            this.flush_promise.setResult(SUCCESS_START_FLUSH);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.valueOf(this.local_addr) + ": all FLUSH_COMPLETED received");
            }
        } else if (collision) {
            Runnable r = () -> this.rejectFlush((Collection)tuple.getVal1(), header.viewID);
            new Thread(r).start();
        }
    }

    private boolean hasVirtualSynchronyGaps() {
        ArrayList<Digest> digests = new ArrayList<Digest>(this.flushCompletedMap.values());
        return !FLUSH.same(digests);
    }

    protected static boolean same(List<Digest> digests) {
        if (digests == null) {
            return false;
        }
        Digest first = digests.get(0);
        for (int i = 1; i < digests.size(); ++i) {
            Digest current = digests.get(i);
            if (first.equals(current)) continue;
            return false;
        }
        return true;
    }

    private Digest findHighestSequences(View view) {
        ArrayList<Digest> digests = new ArrayList<Digest>(this.flushCompletedMap.values());
        return FLUSH.maxSeqnos(view, digests);
    }

    protected static Digest maxSeqnos(View view, List<Digest> digests) {
        if (view == null || digests == null) {
            return null;
        }
        MutableDigest digest = new MutableDigest(view.getMembersRaw());
        digests.forEach(digest::merge);
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspect(Collection<Address> addresses) {
        boolean amINeighbourOfCrashedFlushCoordinator = false;
        ArrayList<Address> flushMembersCopy = null;
        Object object = this.sharedLock;
        synchronized (object) {
            boolean flushCoordinatorSuspected;
            boolean bl = flushCoordinatorSuspected = addresses != null && addresses.contains(this.flushCoordinator);
            if (flushCoordinatorSuspected) {
                int indexOfCoordinator = this.flushMembers.indexOf(this.flushCoordinator);
                int myIndex = this.flushMembers.indexOf(this.local_addr);
                int diff = myIndex - indexOfCoordinator;
                boolean bl2 = amINeighbourOfCrashedFlushCoordinator = diff == 1 || myIndex == 0 && indexOfCoordinator == this.flushMembers.size();
                if (amINeighbourOfCrashedFlushCoordinator) {
                    flushMembersCopy = new ArrayList<Address>(this.flushMembers);
                }
            }
        }
        if (amINeighbourOfCrashedFlushCoordinator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.valueOf(this.local_addr) + ": flush coordinator " + String.valueOf(this.flushCoordinator) + " suspected, I am the neighbor, completing the flush ");
            }
            this.onResume(new Event(70, flushMembersCopy));
        }
        boolean flushOkCompleted = false;
        Message m = null;
        long viewID = 0L;
        Object diff = this.sharedLock;
        synchronized (diff) {
            this.suspected.addAll(addresses);
            this.flushMembers.removeAll(this.suspected);
            viewID = this.currentViewId();
            boolean bl = flushOkCompleted = !this.flushCompletedMap.isEmpty() && this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            if (flushOkCompleted) {
                m = new BytesMessage(this.flushCoordinator).setSrc(this.local_addr);
            }
            this.log.debug(String.valueOf(this.local_addr) + ": suspects: " + String.valueOf(addresses) + ", completed " + flushOkCompleted + ", flushOkSet " + String.valueOf(this.flushCompletedMap) + ", flushMembers " + String.valueOf(this.flushMembers));
        }
        if (flushOkCompleted) {
            Digest digest = (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
            m.putHeader(this.id, new FlushHeader(3, viewID)).setArray(FLUSH.marshal(null, digest));
            this.down_prot.down(m);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.valueOf(this.local_addr) + ": sent FLUSH_COMPLETED message to " + String.valueOf(this.flushCoordinator));
            }
        }
    }

    protected static ByteArray marshal(Collection<? extends Address> participants, Digest digest) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(512);
        try {
            Util.writeAddresses(participants, (DataOutput)out);
            Util.writeStreamable(digest, out);
            return out.getBuffer();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Tuple<Collection<? extends Address>, Digest> readParticipantsAndDigest(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return null;
        }
        try {
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
            ArrayList participants = Util.readAddresses(in, ArrayList::new);
            Digest digest = Util.readStreamable(Digest::new, in);
            return new Tuple<Collection<? extends Address>, Digest>(participants, digest);
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading particpants and digest from message: %s", this.local_addr, ex);
            return null;
        }
    }

    private static final class FlushStartResult {
        private final Boolean result;
        private final Exception failureCause;

        private FlushStartResult(Boolean result, Exception failureCause) {
            this.result = result;
            this.failureCause = failureCause;
        }

        public Boolean getResult() {
            return this.result;
        }

        public boolean failed() {
            return this.result == Boolean.FALSE;
        }

        public Exception getFailureCause() {
            return this.failureCause;
        }
    }

    public static class FlushHeader
    extends Header {
        public static final byte START_FLUSH = 0;
        public static final byte STOP_FLUSH = 2;
        public static final byte FLUSH_COMPLETED = 3;
        public static final byte ABORT_FLUSH = 5;
        public static final byte FLUSH_BYPASS = 6;
        public static final byte FLUSH_RECONCILE = 7;
        public static final byte FLUSH_RECONCILE_OK = 8;
        public static final byte FLUSH_NOT_COMPLETED = 9;
        protected byte type;
        protected long viewID;

        public FlushHeader() {
            this(0, 0L);
        }

        public FlushHeader(byte type) {
            this.type = type;
        }

        public FlushHeader(byte type, long viewID) {
            this(type);
            this.viewID = viewID;
        }

        @Override
        public short getMagicId() {
            return 64;
        }

        @Override
        public Supplier<? extends Header> create() {
            return FlushHeader::new;
        }

        public byte getType() {
            return this.type;
        }

        public long getViewID() {
            return this.viewID;
        }

        @Override
        public int serializedSize() {
            return 9;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "FLUSH[type=START_FLUSH,viewId=" + this.viewID;
                }
                case 2: {
                    return "FLUSH[type=STOP_FLUSH,viewId=" + this.viewID + "]";
                }
                case 5: {
                    return "FLUSH[type=ABORT_FLUSH,viewId=" + this.viewID + "]";
                }
                case 3: {
                    return "FLUSH[type=FLUSH_COMPLETED,viewId=" + this.viewID + "]";
                }
                case 6: {
                    return "FLUSH[type=FLUSH_BYPASS,viewId=" + this.viewID + "]";
                }
                case 7: {
                    return "FLUSH[type=FLUSH_RECONCILE,viewId=" + this.viewID;
                }
                case 8: {
                    return "FLUSH[type=FLUSH_RECONCILE_OK,viewId=" + this.viewID + "]";
                }
            }
            return "[FLUSH: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.type = in.readByte();
            this.viewID = in.readLong();
        }
    }
}

