/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class SimCompPlutoDevice
extends CompPlutoDevice {
    private static final Map<String, Integer> latchMap = new LinkedHashMap<String, Integer>();
    private static final Map<String, Integer> conditionMap;
    private static final Logger LOG;
    private final boolean[] coldSwitches = new boolean[2];
    private final boolean[] cryoSwitches = new boolean[3];
    private final LatchState[] latches = new LatchState[10];
    private final ConditionState[] conditions = new ConditionState[18];
    private boolean[] switches;
    private long powerTime = 0L;
    private final Map<String, Integer> channelMap = new LinkedHashMap<String, Integer>();
    private final List<Channel> channels = new ArrayList<Channel>();
    private final List<Double> channelValues = new ArrayList<Double>();
    private boolean plcActive = true;

    public SimCompPlutoDevice() {
        Arrays.fill((Object[])this.latches, (Object)LatchState.CLEAR);
        Arrays.fill((Object[])this.conditions, (Object)ConditionState.YES);
        this.conditions[1] = ConditionState.NO;
        this.conditions[2] = ConditionState.NO;
        this.conditions[3] = ConditionState.NO;
        this.conditions[12] = ConditionState.NO;
        this.conditions[16] = ConditionState.NO;
        this.conditions[17] = ConditionState.NO;
    }

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
        LOG.log(Level.INFO, "Connected to {0} (simulated Pluto gateway)", this.getPath());
    }

    protected void close() {
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan >= 100) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hwChan", (Object)hwChan);
        }
        int index = this.channelValues.size();
        this.channelMap.put(ch.getPath(), index);
        this.channels.add(ch);
        double offset = ch.convertRawValue(0.0);
        double scale = ch.convertRawValue(1.0) - offset;
        this.channelValues.add(((double)index - offset) / scale);
        return new int[]{index, 0};
    }

    protected double readChannel(Channel ch) {
        return this.channelValues.get(ch.getType());
    }

    @Override
    public void setType(int type) {
        this.switches = type == 0 ? this.coldSwitches : this.cryoSwitches;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw] = on;
        if (sw == 0) {
            if (on) {
                this.powerTime = System.currentTimeMillis() + 30000L;
                this.conditions[1] = ConditionState.YES;
                if (this.areLatchesClear()) {
                    this.conditions[2] = ConditionState.YES;
                    this.conditions[3] = ConditionState.YES;
                }
            } else {
                this.powerTime = 0L;
                this.conditions[1] = ConditionState.NO;
                this.conditions[2] = ConditionState.NO;
                this.conditions[3] = ConditionState.NO;
            }
        } else if (sw == 2) {
            if (on) {
                this.conditions[16] = ConditionState.YES;
                if (this.areLatchesClear()) {
                    this.conditions[17] = ConditionState.YES;
                }
            } else {
                this.conditions[16] = ConditionState.NO;
                this.conditions[17] = ConditionState.NO;
            }
        } else if (sw == 1) {
            this.conditions[12] = on ? ConditionState.YES : ConditionState.NO;
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        if (this.powerTime != 0L && System.currentTimeMillis() >= this.powerTime) {
            this.conditions[2] = ConditionState.NO;
            this.powerTime = 0L;
        }
        return this.switches[sw];
    }

    @Override
    public LatchState getLatchState(int cond) {
        return this.latches[cond];
    }

    @Override
    public ConditionState getConditionState(int cond) {
        return this.conditions[cond];
    }

    @Override
    public void resetLatches() {
        for (int cond = 0; cond < this.latches.length; ++cond) {
            LatchState state = this.latches[cond];
            this.latches[cond] = state == LatchState.LATCHED ? LatchState.CLEAR : state;
        }
        if (this.areLatchesClear()) {
            this.conditions[11] = ConditionState.YES;
            if (this.switches[0]) {
                this.conditions[3] = ConditionState.YES;
            }
        }
    }

    public Boolean isPLCActive() {
        return this.plcActive;
    }

    @Override
    public int getErrorCode() {
        return 42;
    }

    private boolean areLatchesClear() {
        boolean clear = true;
        for (LatchState state : this.latches) {
            if (state == LatchState.CLEAR) continue;
            clear = false;
            break;
        }
        return clear;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of latched condition names")
    public String getLatchNames() {
        return latchMap.keySet().toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Make a latched condition active")
    public void setLatchActive(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[this.getLatch((String)cond)] = LatchState.ACTIVE;
        this.conditions[3] = ConditionState.NO;
        this.conditions[2] = ConditionState.NO;
        this.conditions[11] = ConditionState.NO;
    }

    @Command(type=Command.CommandType.ACTION, description="Make a latched condition latched")
    public void setLatchLatched(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[this.getLatch((String)cond)] = LatchState.LATCHED;
        this.conditions[3] = ConditionState.NO;
        this.conditions[2] = ConditionState.NO;
        this.conditions[11] = ConditionState.NO;
    }

    @Command(type=Command.CommandType.ACTION, description="Put a latched condition into warning state")
    public void setLatchWarning(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[this.getLatch((String)cond)] = LatchState.WARNING;
    }

    private int getLatch(String name) throws RefrigException {
        Integer cond = latchMap.get(name);
        if (cond == null) {
            throw new RefrigException("Unknown latched condition name: " + name);
        }
        return cond;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of condition names")
    public String getConditionNames() {
        return conditionMap.keySet().toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the state of a condition")
    public void setCondition(@Argument(description="Running condition name") String cond, @Argument(description="Condition on state") boolean set) throws RefrigException {
        Integer condNum = conditionMap.get(cond);
        if (condNum == null) {
            throw new RefrigException("Unknown condition name: " + cond);
        }
        if (condNum != 3) {
            this.conditions[condNum.intValue()] = set ? ConditionState.YES : ConditionState.NO;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws RefrigException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new RefrigException("Invalid channel name");
        }
        Channel ch = this.channels.get(index);
        double offset = ch.convertRawValue(0.0);
        double scale = ch.convertRawValue(1.0) - offset;
        this.channelValues.set(index, (value - offset) / scale);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Set whether PLC is active")
    public void setPLCActive(@Argument(description="PLC active state") boolean set) {
        this.plcActive = set;
    }

    static {
        latchMap.put("AfterTmp", 8);
        latchMap.put("DischPrs", 3);
        latchMap.put("DischTmp", 0);
        latchMap.put("ExtPermit", 5);
        latchMap.put("LiquidTmp", 2);
        latchMap.put("OilLevel", 9);
        latchMap.put("Power", 4);
        latchMap.put("SensValid", 7);
        latchMap.put("SmokeDetc", 6);
        latchMap.put("SuctnTmp", 1);
        conditionMap = new LinkedHashMap<String, Integer>();
        conditionMap.put("CmpOn8Hrs", 14);
        conditionMap.put("CurrentValid", 9);
        conditionMap.put("CurrSensErr", 13);
        conditionMap.put("DiscPrsValid", 7);
        conditionMap.put("DiscTmpValid", 4);
        conditionMap.put("KeySwitchOn", 0);
        conditionMap.put("LiqdTmpValid", 6);
        conditionMap.put("OilLvlValid", 15);
        conditionMap.put("SuctPrsValid", 8);
        conditionMap.put("SuctTmpValid", 5);
        conditionMap.put("VoltageValid", 10);
        LOG = Logger.getLogger(SimCompPlutoDevice.class.getName());
    }
}

