import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.common.devices.dataforth.SimMaq20Device
import org.lsst.ccs.subsystem.refrig.PrototypeColdPlateSubsystem
import org.lsst.ccs.subsystem.common.ConfiguredAverageChannel;
import org.lsst.ccs.subsystem.refrig.PcpPowerDevice
import org.lsst.ccs.subsystem.refrig.SimPcpPowerDevice
import org.lsst.ccs.subsystem.refrig.PcpPowerControl
import org.lsst.ccs.subsystem.refrig.SimPcpPowerControl
import org.lsst.ccs.subsystem.refrig.PcpMaq20Device
import org.lsst.ccs.subsystem.refrig.PcpPlutoDevice
import org.lsst.ccs.subsystem.refrig.SimPcpPlutoDevice
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.CalcChannel

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    maq20Device = SimMaq20Device
    plutoDevice = SimPcpPlutoDevice
    powerDevice = SimPcpPowerDevice
    powerControl = SimPcpPowerControl
}
else {
    maq20Device = PcpMaq20Device
    plutoDevice = PcpPlutoDevice
    powerDevice = PcpPowerDevice
    powerControl = PcpPowerControl
}

pOffset500 = -125.0;
pScale500 = 31250.0

CCSBuilder builder = ["prototype-cold-plate"]

builder.main (PrototypeColdPlateSubsystem,
              powerChans: [PcpPowerDevice.CHAN_MINUS_Y, PcpPowerDevice.CHAN_CENTER, PcpPowerDevice.CHAN_PLUS_Y] /* -Y, center, +Y */) {

  /**
    * Maq20 modules in order of DIN number in LCA-19722-A:
    * DIN 09, 10, 11, 12, 20, 21; then added 16, 15 for heaters
    */
    Maq20 (maq20Device, modules: ["RTD","RTD","RTD","RTD","IS","RTD","VS","VO"]) {

        HtrPower (powerDevice)
        
        MinusYHtr (powerControl, ident: PcpPowerDevice.CHAN_MINUS_Y, inVoltage: "6:0:V5:150.0", outVoltage: "7:0:VP5:150.0",
                   inCurrent: "6:1:V5:8.0", outCurrent: "7:1:VP5:8.0", inEnabled: "6:6:V40:20.0", maxCurrent: 6.0)

        CenterHtr (powerControl, ident: PcpPowerDevice.CHAN_CENTER, inVoltage: "6:2:V10:60.0", outVoltage: "7:2:VP10:60.0",
                   inCurrent: "6:3:V10:20.0", outCurrent: "7:3:VP10:20.0", inEnabled: "6:7:V40:8.0", maxCurrent: 19.5)

        PlusYHtr (powerControl, ident: PcpPowerDevice.CHAN_PLUS_Y, inVoltage: "6:4:V5:150.0", outVoltage: "7:4:VP5:150.0",
                  inCurrent: "6:5:V5:7.0", outCurrent: "7:5:VP5:7.0", inEnabled: "6:8:V40:20.0", maxCurrent: 6.0)

        PSupply (Channel, description: "ColdPlate supply pressure",
                 devcName: "Maq20", units: "psia", format: ".2f",
                 subtype: "MA4_20", type: "4", hwChan: 0,
                 offset: pOffset500, scale: pScale500,
                 checkLo:"none", checkHi:"none")

        PReturn (Channel, description: "ColdPlate return pressure",
                 devcName: "Maq20", units: "psia", format: ".2f",
                 subtype: "MA4_20", type: "4", hwChan: 1,
                 offset: pOffset500, scale: pScale500,
                 checkLo:"none", checkHi:"none")

        TSupply (Channel, description: "Coolant input temperature",
                 devcName: "Maq20", units: "\u00b0C", format: ".2f",
                 subtype: "R200", type: "5", hwChan: 0,
                 checkLo:"none", checkHi:"none")

        TCircuit1In  (Channel, description: "Circuit 1 input temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 2,
                      checkLo:"none", checkHi:"none")

        TCircuit2In (Channel, description: "Circuit 2 input temperature",
                     devcName: "Maq20", units: "\u00b0C", format: ".2f",
                     subtype: "R200", type: "5", hwChan: 4,
                     checkLo:"none", checkHi:"none")

        TCircuit1Out (Channel, description: "Circuit 1 output temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 3,
                      checkLo:"none", checkHi:"none")

        TCircuit2Out (Channel, description: "Circuit 2 output temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 5,
                      checkLo:"none", checkHi:"none")

        TReturn (Channel, description: "Coolant return temperature",
                 devcName: "Maq20", units: "\u00b0C", format: ".2f",
                 subtype: "R200", type: "5", hwChan: 1,
                 checkLo:"none", checkHi:"none")

        TColdBarAvg (ConfiguredAverageChannel, units: "\u00b0C", format: ".2f",
                     description: "Average Temperature Cold Bar RTDs",
                     checkLo:"none", checkHi:"none")

        RTD10 (Channel, description: "Temperature, Bar 0 position 1",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "0", hwChan: 0,
               checkLo:"none", checkHi:"none")

        RTD20 (Channel, description: "Temperature, Bar 0 position 2",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "0", hwChan: 1,
               checkLo:"none", checkHi:"none")

        RTD30 (Channel, description: "Temperature, Bar 0 position 3",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "0", hwChan: 2,
               checkLo:"none", checkHi:"none")

        RTD11 (Channel, description: "Temperature, Bar 1 position 1",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "0", hwChan: 3,
               checkLo:"none", checkHi:"none")

        RTD21 (Channel, description: "Temperature, Bar 1 position 2",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "0", hwChan: 4,
               checkLo:"none", checkHi:"none")

        RTD31 (Channel, description: "Temperature, Bar 1 position 3",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "0", hwChan: 5,
               checkLo:"none", checkHi:"none")

        RTD02 (Channel, description: "Temperature, Bar 2 position 0",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "2", hwChan: 0,
               checkLo:"none", checkHi:"none")

        RTD12 (Channel, description: "Temperature, Bar 2 position 1",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "2", hwChan: 1,
               checkLo:"none", checkHi:"none")

        RTD22 (Channel, description: "Temperature, Bar 2 position 2",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "2", hwChan: 2,
               checkLo:"none", checkHi:"none")

        RTD32 (Channel, description: "Temperature, Bar 2 position 3",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "2", hwChan: 3,
               checkLo:"none", checkHi:"none")

        RTD03 (Channel, description: "Temperature, Bar 3 position 0",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "2", hwChan: 4,
               checkLo:"none", checkHi:"none")

        RTD13 (Channel, description: "Temperature, Bar 3 position 1",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "2", hwChan: 5,
               checkLo:"none", checkHi:"none")

        RTD23 (Channel, description: "Temperature, Bar 3 position 2",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "1", hwChan: 0,
               checkLo:"none", checkHi:"none")

        RTD33 (Channel, description: "Temperature, Bar 3 position 3",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "1", hwChan: 1,
               checkLo:"none", checkHi:"none")

        RTD04 (Channel, description: "Temperature, Bar 4 position 0",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "1", hwChan: 2,
               checkLo:"none", checkHi:"none")

        RTD14 (Channel, description: "Temperature, Bar 4 position 1",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "1", hwChan: 3,
               checkLo:"none", checkHi:"none")

        RTD24 (Channel, description: "Temperature, Bar 4 position 2",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "1", hwChan: 4,
               checkLo:"none", checkHi:"none")

        RTD05 (Channel, description: "Temperature, Bar 5 position 0",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "1", hwChan: 5,
               checkLo:"none", checkHi:"none")

        RTD15 (Channel, description: "Temperature, Bar 5 position 1",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "3", hwChan: 0,
               checkLo:"none", checkHi:"none")

        RTD25 (Channel, description: "Temperature, Bar 5 position 2",
               devcName: "Maq20", units: "\u00b0C", format: ".2f",
               subtype: "R200", type: "3", hwChan: 1,
               checkLo:"none", checkHi:"none")

        AmbientTemp  (Channel, description: "Temperature outside enclosure",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 2,
                      checkLo:"none", checkHi:"none")

        InteriorTemp (Channel, description: "Temperature inside enclosure",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 3,
                      checkLo:"none", checkHi:"none")
    }

    Pluto (plutoDevice) {

        RTD00 (Channel, description: "Temperature, Bar 0 position 0", units: "\u00b0C", format: ".2f",
               devcName: "Pluto", hwChan: 0, type: "ADDREG:0", scale: 0.01, offset: -120.0,
               checkLo:"none", checkHi:"none")

        RTD01 (Channel, description: "Temperature, Bar 1 position 0", units: "\u00b0C", format: ".2f",
               devcName: "Pluto", hwChan: 0, type: "ADDREG:1", scale: 0.01, offset: -120.0,
               checkLo:"none", checkHi:"none")

        RTD34 (Channel, description: "Temperature, Bar 4 position 3", units: "\u00b0C", format: ".2f",
               devcName: "Pluto", hwChan: 0, type: "ADDREG:2", scale: 0.01, offset: -120.0,
               checkLo:"none", checkHi:"none")

        RTD35 (Channel, description: "Temperature, Bar 5 position 3", units: "\u00b0C", format: ".2f",
               devcName: "Pluto", hwChan: 0, type: "ADDREG:3", scale: 0.01, offset: -120.0,
               checkLo:"none", checkHi:"none")
    }

    Heaters (Object) {

        MinusYHtr_V (Channel, description: "-Y Heater Voltage", units: "Volts", format: ".1f",
                     devcName: "Maq20/HtrPower", hwChan: 0, type: "VOLTAGE",
                     checkLo:"none", checkHi:"none")

        MinusYHtr_I (Channel, description: "-Y Heater Current", units: "Amps", format: ".1f",
                     devcName: "Maq20/HtrPower", hwChan: 0, type: "CURRENT",
                     checkLo:"none", checkHi:"none")

        MinusYHtr_P (CalcChannel, description: "-Y Heater Power", units: "Watts", format: ".1f",
                     type: CalcChannel.Operation.PROD, channelPaths: ["Heaters/MinusYHtr_V", "Heaters/MinusYHtr_I"],
                     checkLo:"none", checkHi:"none")

        CenterHtr_V (Channel, description: "Center Heater Voltage", units: "Volts", format: ".1f",
                     devcName: "Maq20/HtrPower", hwChan: 1, type: "VOLTAGE",
                     checkLo:"none", checkHi:"none")

        CenterHtr_I (Channel, description: "Center Heater Current", units: "Amps", format: ".1f",
                     devcName: "Maq20/HtrPower", hwChan: 1, type: "CURRENT",
                     checkLo:"none", checkHi:"none")

        CenterHtr_P (CalcChannel, description: "Center Heater Power", units: "Watts", format: ".1f",
                     type: CalcChannel.Operation.PROD, channelPaths: ["Heaters/CenterHtr_V", "Heaters/CenterHtr_I"],
                     checkLo:"none", checkHi:"none")

        PlusYHtr_V (Channel, description: "+Y Heater Voltage", units: "Volts", format: ".1f",
                    devcName: "Maq20/HtrPower", hwChan: 2, type: "VOLTAGE",
                    checkLo:"none", checkHi:"none")

        PlusYHtr_I (Channel, description: "+Y Heater Current", units: "Amps", format: ".1f",
                    devcName: "Maq20/HtrPower", hwChan: 2, type: "CURRENT",
                    checkLo:"none", checkHi:"none")

        PlusYHtr_P (CalcChannel, description: "+Y Heater Power", units: "Watts", format: ".1f",
                    type: CalcChannel.Operation.PROD, channelPaths: ["Heaters/PlusYHtr_V", "Heaters/PlusYHtr_I"],
                    checkLo:"none", checkHi:"none")
    }

}
