/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.refrig.PcpPowerControl;

public class SimPcpPowerControl
extends PcpPowerControl {
    private static final double[] loads = new double[3];
    private double voltage;

    @Override
    public void setVoltage(double value) throws DriverException {
        super.setVoltage(value);
        PcpPowerControl.ChannelDesc chanDesc = this.channelDescs[0];
        this.maqDevc.getMaq20().setSimChannelValue(chanDesc.moduleData.modId, chanDesc.hwChannel, chanDesc.scale * value);
        chanDesc = this.channelDescs[2];
        this.maqDevc.getMaq20().setSimChannelValue(chanDesc.moduleData.modId, chanDesc.hwChannel, chanDesc.scale * value / loads[this.ident]);
        this.voltage = value;
    }

    public void setOutput(boolean value) throws DriverException {
        PcpPowerControl.ChannelDesc chanDesc = this.channelDescs[4];
        this.maqDevc.getMaq20().setSimChannelValue(chanDesc.moduleData.modId, chanDesc.hwChannel, value ? 0.0 : 5.0);
        this.setVoltage(value ? this.voltage : 0.0);
    }

    static {
        SimPcpPowerControl.loads[0] = 10.0;
        SimPcpPowerControl.loads[1] = 2.5;
        SimPcpPowerControl.loads[2] = 10.0;
    }
}

