/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.refrig.PcpPlutoDevice;
import org.lsst.ccs.subsystem.refrig.PcpPowerControl;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class PcpPowerDevice
extends PowerDevice {
    public static final int CHAN_MINUS_Y = 0;
    public static final int CHAN_CENTER = 1;
    public static final int CHAN_PLUS_Y = 2;
    public static final int NUM_CHANS = 3;
    private static final int TYPE_VOLTAGE = 0;
    private static final int TYPE_CURRENT = 1;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private static final Map<Integer, Integer> plutoSwitches;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Maq20Device maqDevc;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private final List<PcpPowerControl> controlList = new ArrayList<PcpPowerControl>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PcpPlutoDevice plutoDevc;
    private static final Logger LOG;
    final PcpPowerControl[] controls = new PcpPowerControl[3];

    public PcpPowerDevice() {
        super("PcpPower", null, 0, 0, 2);
        this.connType = DriverConstants.ConnType.NET;
        this.devcId = "";
    }

    @Override
    protected void initDevice() {
        if (this.maqDevc == null) {
            throw new RuntimeException(this.path + ": Parent Maq20Device object has not been defined");
        }
        Iterator<PcpPowerControl> iterator = this.controlList.iterator();
        while (iterator.hasNext()) {
            PcpPowerControl ctrl;
            this.controls[ctrl.getIdent()] = ctrl = iterator.next();
        }
        for (int j = 0; j < this.controls.length; ++j) {
            if (this.controls[j] != null) continue;
            throw new RuntimeException(this.path + ": Sibling PcpPowerControl object with ident " + j + " has not been defined");
        }
        if (this.plutoDevc == null) {
            throw new RuntimeException(this.path + ": PcpPlutoDevice object has not been defined");
        }
        this.fullName = this.path + " (Pcp load power supply)";
    }

    @Override
    protected void initialize() {
        this.setOnline(this.maqDevc.isOnline());
        if (this.isOnline()) {
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
        }
    }

    @Override
    protected void close() {
    }

    @Override
    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan;
        String type = ch.getTypeStr();
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        if ((hwChan = ch.getHwChan()) < 0 || hwChan >= 3) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"HW channel", (Object)hwChan);
        }
        return new int[]{iType, 0};
    }

    @Override
    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        if (this.isOnline()) {
            PcpPowerControl ctrl = this.controls[ch.getHwChan()];
            try {
                switch (ch.getType()) {
                    case 0: {
                        value = ctrl.readVoltage();
                        break;
                    }
                    case 1: {
                        value = ctrl.readCurrent();
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading current or voltage from {0}: {1}", new Object[]{this.fullName, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public void setOutput(int chan, boolean value) throws DriverException {
        this.plutoDevc.setSwitchOn(plutoSwitches.get(chan), value);
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public boolean getOutput(int chan) throws DriverException {
        return this.controls[chan].isOutputOn();
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public void setVoltage(int chan, double value) throws DriverException {
        this.controls[chan].setVoltage(value);
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public double readVoltage(int chan) throws DriverException {
        return this.controls[chan].readVoltage();
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public void setCurrent(int chan, double value) throws DriverException {
        this.controls[chan].setCurrent(value);
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public double readCurrent(int chan) throws DriverException {
        return this.controls[chan].readCurrent();
    }

    static {
        typeMap.put("VOLTAGE", 0);
        typeMap.put("CURRENT", 1);
        plutoSwitches = new HashMap<Integer, Integer>();
        plutoSwitches.put(0, 2);
        plutoSwitches.put(1, 3);
        plutoSwitches.put(2, 4);
        LOG = Logger.getLogger(PcpPowerDevice.class.getName());
    }
}

