/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.classes;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.DataProviderInfoUtils;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;

public class SALClassDescriptionMaker {
    private final Map<String, SALClassDescription> SALClassDescriptionMap = new TreeMap<String, SALClassDescription>();
    private final Map<String, Class> SALClassMap = new TreeMap<String, Class>();
    private static final boolean SALCLASS_DESCRIPTION_MAKER_DEBUG = false;
    private static final Logger LOG = Logger.getLogger(SALClassDescriptionMaker.class.getName());
    private boolean noWarning = System.getProperty("no.missing.sal.class.warning", "false").toLowerCase().equals("true");
    private final MakeXMLConfiguration.DictionaryConfiguration dictConfig;
    private final int level;

    public SALClassDescriptionMaker(MakeXMLConfiguration.DictionaryConfiguration dictConfig, Mapping mapping) {
        this(dictConfig, mapping, dictConfig.getLevel());
    }

    public SALClassDescriptionMaker(MakeXMLConfiguration.DictionaryConfiguration dictConfig, Mapping mapping, int level) {
        this.level = level;
        this.dictConfig = dictConfig;
        XMLMaker2.SALType salType = dictConfig.getSALType();
        String cscName = dictConfig.getCSCName();
        Camera camera = dictConfig.getCamera();
        String subsystemName = dictConfig.getComponentName();
        DataProviderDictionary dataProviderDictionary = null;
        try {
            dataProviderDictionary = dictConfig.getDictionary();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Could not fetch the dictionary", ex);
        }
        List<DataProviderInfo> dpInfoList = dataProviderDictionary.getDataProviderInfos();
        for (DataProviderInfo dpi : dpInfoList) {
            Mapping.Match match;
            if (!DataProviderInfoUtils.acceptData(dpi, salType)) continue;
            String type = dpi.getAttributeValue(DataProviderInfo.Attribute.TYPE);
            String description = dpi.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION);
            String units = dpi.getAttributeValue(DataProviderInfo.Attribute.UNITS);
            int count = 1;
            if (dpi.getAttributeValue(DataProviderInfo.Attribute.CONFIG_MAX_LENGTH) != null) {
                int tmpCount = Integer.parseInt(dpi.getAttributeValue(DataProviderInfo.Attribute.CONFIG_MAX_LENGTH));
                if (tmpCount < 0) {
                    LOG.log(Level.WARNING, "Negative value for CONFIG_MAX_LENGTH attribute for variable: {0} value={1} but using value 1.", new Object[]{dpi.getFullPath(), tmpCount});
                } else {
                    count = tmpCount;
                }
            }
            String category = DataProviderInfoUtils.getCategory(dpi);
            String originalPathName = dpi.getFullPath();
            if (salType == XMLMaker2.SALType.SETTINGS_APPLIED && !originalPathName.contains("/")) {
                originalPathName = "/" + originalPathName;
            }
            if ((match = mapping.match(originalPathName)) != null) {
                SALClassDescription.SALVariable existingVariable;
                String rawSALClassParameterName = match.getPatternName() + "/" + match.getPathAfterMatch();
                String salClassParameterName = this.makeSALClassParameterName(rawSALClassParameterName.trim(), level);
                String topicName = this.makeSALTopicName(level, cscName, subsystemName, salType, rawSALClassParameterName, category);
                Class simpleSalClass = this.makeSALClasseName(topicName, salType, camera);
                SALClassDescription salClassDescription = this.SALClassDescriptionMap.computeIfAbsent(topicName, name -> new SALClassDescription(topicName, simpleSalClass, level, category));
                SALClassDescription.BusVariable busVariable = new SALClassDescription.BusVariable(originalPathName);
                if (simpleSalClass != null) {
                    this.SALClassMap.put(topicName, simpleSalClass);
                }
                if ((existingVariable = salClassDescription.getVariable(salClassParameterName)) instanceof SALClassDescription.PatternMatchedSALVariable) {
                    ((SALClassDescription.PatternMatchedSALVariable)existingVariable).addBusVariable(busVariable);
                    continue;
                }
                String locationVariableName = match.getPatternName() + "Location";
                SALClassDescription.LocationVariable locationVariable = (SALClassDescription.LocationVariable)salClassDescription.getVariable(locationVariableName);
                if (locationVariable == null) {
                    locationVariable = new SALClassDescription.LocationVariable(locationVariableName, match.getPatternName() + " location");
                    salClassDescription.add(locationVariable);
                }
                SALClassDescription.PatternMatchedSALVariable var = new SALClassDescription.PatternMatchedSALVariable(match.getPatternName(), match.getLocation(), locationVariable, salClassParameterName, type, units, description);
                var.addBusVariable(busVariable);
                salClassDescription.add(var);
                continue;
            }
            String topicName = this.makeSALTopicName(level, cscName, subsystemName, salType, originalPathName, category);
            Class simpleSalClass = this.makeSALClasseName(topicName, salType, camera);
            SALClassDescription salClassDescription = this.SALClassDescriptionMap.computeIfAbsent(topicName, name -> new SALClassDescription(topicName, simpleSalClass, level, category));
            SALClassDescription.BusVariable busVariable = new SALClassDescription.BusVariable(originalPathName);
            SALClassDescription.SimpleSALVariable var = new SALClassDescription.SimpleSALVariable(this.makeSALClassParameterName(originalPathName, level), type, units, description, busVariable, count);
            salClassDescription.add(var);
            if (simpleSalClass == null) continue;
            this.SALClassMap.put(topicName, simpleSalClass);
        }
        for (SALClassDescription classDescription : this.SALClassDescriptionMap.values()) {
            List locationVariables = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).collect(Collectors.toList());
            if (locationVariables.size() != 1) continue;
            SALClassDescription.SALVariable theLocationVariable = (SALClassDescription.SALVariable)locationVariables.get(0);
            classDescription.renameVariable(theLocationVariable, "location");
        }
    }

    public MakeXMLConfiguration.DictionaryConfiguration getDictionaryConfiguration() {
        return this.dictConfig;
    }

    public int getLevel() {
        return this.level;
    }

    public Map<String, SALClassDescription> getSALClassDescriptions() {
        return this.SALClassDescriptionMap;
    }

    public Map<String, Class> getSALClasses() {
        return this.SALClassMap;
    }

    private Class makeSALClasseName(String topicName, XMLMaker2.SALType salType, Camera camera) {
        String[] packages = null;
        switch (camera) {
            case COMCAM: {
                packages = new String[]{"org.lsst.sal.cccamera.event", "org.lsst.sal.camera.event", "org.lsst.sal.cccamera.telemetry", "org.lsst.sal.camera.telemetry"};
                break;
            }
            case AUXTEL: {
                packages = new String[]{"org.lsst.sal.atcamera.event", "org.lsst.sal.camera.event", "org.lsst.sal.atcamera.telemetry", "org.lsst.sal.camera.telemetry"};
                break;
            }
            case MAIN_CAMERA: {
                packages = new String[]{"org.lsst.sal.camera.event", "org.lsst.sal.camera.telemetry"};
            }
        }
        String tmpTopicName = topicName;
        tmpTopicName = tmpTopicName.replace("-", "_");
        tmpTopicName = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? tmpTopicName.replace(camera.getCscName() + "_logevent_", "") : tmpTopicName.replace(camera.getCscName() + "_", "");
        tmpTopicName = SALClassDescriptionMaker.capitalize(tmpTopicName);
        tmpTopicName = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? tmpTopicName + "ConfigurationEvent" : tmpTopicName + "Telemetry";
        Class<?> classForName = null;
        for (String pkg : packages) {
            try {
                classForName = Class.forName(pkg + "." + tmpTopicName);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (classForName == null && !this.noWarning) {
            LOG.log(Level.WARNING, "For {0} {1} {2} Class not found {3}", new Object[]{topicName, salType, camera, tmpTopicName});
        }
        return classForName;
    }

    private String makeSALTopicName(int level, String cscName, String subsystemName, XMLMaker2.SALType salType, String path, String category) {
        if (cscName.toLowerCase().contains("comcam")) {
            cscName = "CCCamera";
        }
        String subsystemAndComponent = "";
        if (!cscName.isEmpty()) {
            subsystemAndComponent = cscName.substring(0, 1).toUpperCase() + cscName.substring(1);
        }
        if (!(subsystemName = subsystemName.trim()).isEmpty()) {
            subsystemAndComponent = subsystemAndComponent + "_" + subsystemName.substring(0, 1).toLowerCase() + subsystemName.substring(1);
        }
        String className = salType == XMLMaker2.SALType.SETTINGS_APPLIED ? cscName + "_logevent_" + subsystemName.toLowerCase() : subsystemAndComponent;
        String[] pathComponentsI = path.split("/");
        int depth = level;
        if (pathComponentsI.length <= level && level > 1) {
            depth = pathComponentsI.length - 1;
        }
        for (int i = 0; i < depth; ++i) {
            if (pathComponentsI[i].isEmpty()) continue;
            className = className + "_" + SALClassDescriptionMaker.capitalize(pathComponentsI[i]);
        }
        if (category != null && !category.isEmpty()) {
            className = className + "_" + category;
        }
        if (className.endsWith("_")) {
            className = className.substring(0, className.length() - 1);
        }
        return className.replace("-", "_");
    }

    final String makeSALClassParameterName(String path, int level) {
        int pathLength = path.split("/").length;
        String variableName = "";
        if ((path = path.replaceAll("-", "_")).startsWith("/")) {
            path = path.replace("/", "");
        }
        if (path.contains("/")) {
            if (level < pathLength) {
                for (int i = level; i < pathLength; ++i) {
                    variableName = variableName + "_" + path.split("/")[i];
                }
                if (variableName.startsWith("_")) {
                    variableName = variableName.substring(1);
                }
            } else {
                variableName = path.split("/")[pathLength - 1];
            }
        } else {
            variableName = path;
        }
        if (variableName.isEmpty()) {
            throw new RuntimeException("Empty parameter name from original path " + path + " at level " + level);
        }
        return SALClassDescriptionMaker.uncapitalize(variableName).trim();
    }

    public static String capitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toUpperCase() + in.substring(1);
        }
        return in.toUpperCase();
    }

    public static String uncapitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toLowerCase() + in.substring(1);
        }
        return in.toLowerCase();
    }
}

