/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.utilities.location.Location;

public class StoreSimulation {
    private final List<TriggerListener> listeners = new CopyOnWriteArrayList<TriggerListener>();
    private RegisterAccess registerAccess;
    private static final StoreSimulation singleton = new StoreSimulation();

    private StoreSimulation() {
    }

    public static StoreSimulation instance() {
        return singleton;
    }

    public void addTriggerListener(TriggerListener listener) {
        this.listeners.add(listener);
    }

    public void removeTriggerListener(TriggerListener listener) {
        this.listeners.remove(listener);
    }

    public void setRegisterAccess(RegisterAccess ra) {
        this.registerAccess = ra;
    }

    void fireTrigger(int opcode, ImageMetaData meta, Map<Location.LocationType, int[]> registerLists) {
        for (TriggerListener l : this.listeners) {
            l.trigger(opcode, meta, registerLists);
        }
    }

    int readRegister(Location l, int address) {
        if (this.registerAccess != null) {
            return this.registerAccess.readRegister(l, address);
        }
        return 0;
    }

    void writeRegister(Location l, int address, int value) {
        if (this.registerAccess != null) {
            this.registerAccess.writeRegister(l, address, value);
        }
    }

    public static interface RegisterAccess {
        public int readRegister(Location var1, int var2);

        public void writeRegister(Location var1, int var2, int var3);
    }

    public static interface TriggerListener {
        public void trigger(int var1, ImageMetaData var2, Map<Location.LocationType, int[]> var3);
    }
}

