/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.drivers.apcpdu.APC7900Series;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class APC7900B
extends Session
implements APC7900Series {
    private String product;
    private String fwVersion;
    private Integer numPhases;
    private Integer numOutlets;

    public APC7900B() {
        super(1, "apc>", "User Name :", "Password  :", "exit", Ascii.Terminator.CR);
    }

    @Override
    public void open(Session.ConnType connType, String ident, String username, String password) throws DriverException {
        this.open(connType, ident, 9600, username, password, 200, 50);
    }

    @Override
    public void open(Session.ConnType connType, String ident) throws DriverException {
        this.open(connType, ident, 9600, 50);
    }

    @Override
    public void close() throws DriverException {
        try {
            super.close();
        }
        finally {
            this.product = null;
            this.fwVersion = null;
            this.numPhases = null;
            this.numOutlets = null;
        }
    }

    @Override
    public String getProductName() throws DriverException {
        if (this.product == null) {
            this.getVersionInfo();
        }
        return this.product;
    }

    @Override
    public String getFWVersion() throws DriverException {
        if (this.fwVersion == null) {
            this.getVersionInfo();
        }
        return this.fwVersion;
    }

    @Override
    public int getPhaseCount() throws DriverException {
        if (this.numPhases == null) {
            this.getVersionInfo();
        }
        return this.numPhases;
    }

    @Override
    public int getOutletCount() throws DriverException {
        if (this.numOutlets == null) {
            this.getVersionInfo();
        }
        return this.numOutlets;
    }

    @Override
    public String getOutletName(int outlet) throws DriverException {
        String[] reply = this.receiveString("olName " + outlet);
        APC7900B.checkReplyLength((String[])reply, (int)2);
        String[] words = reply[0].split(" *: ");
        return words[1];
    }

    @Override
    public void setOutletName(int outlet, String name) throws DriverException {
        String[] reply = this.receiveString("olName " + outlet + " \"" + name + "\"");
    }

    @Override
    public int getOutletNumber(String outlet) throws DriverException {
        String[] reply = this.receiveString("olStatus \"" + outlet + "\"");
        APC7900B.checkReplyLength((String[])reply, (int)2);
        String[] words = reply[0].split(" *: ");
        int number = 0;
        try {
            number = APC7900B.getInteger(words[0]);
        }
        catch (NumberFormatException e) {
            APC7900B.responseError((String)reply[0]);
        }
        return number;
    }

    @Override
    public Map<String, Integer> getOutletNumberMap() throws DriverException {
        String[] reply = this.receiveString("olStatus all");
        APC7900B.checkReplyLength((String[])reply, (int)(this.getOutletCount() + 1));
        LinkedHashMap<String, Integer> numberMap = new LinkedHashMap<String, Integer>();
        for (int j = 0; j < reply.length - 1; ++j) {
            String[] words = reply[j].split(" *: ");
            try {
                numberMap.put(words.length >= 2 ? words[1] : "", APC7900B.getInteger(words[0]));
                continue;
            }
            catch (NumberFormatException e) {
                APC7900B.responseError((String)reply[j]);
            }
        }
        return numberMap;
    }

    @Override
    public int getOutletOnDelay(int outlet) throws DriverException {
        return this.extractDelay(this.receiveString("olOnDelay " + outlet));
    }

    @Override
    public int getOutletOffDelay(int outlet) throws DriverException {
        return this.extractDelay(this.receiveString("olOffDelay " + outlet));
    }

    @Override
    public int getOutletOnDelay(String outlet) throws DriverException {
        return this.extractDelay(this.receiveString("olOnDelay \"" + outlet + "\""));
    }

    @Override
    public int getOutletOffDelay(String outlet) throws DriverException {
        return this.extractDelay(this.receiveString("olOffDelay \"" + outlet + "\""));
    }

    private int extractDelay(String[] reply) throws DriverException {
        APC7900B.checkReplyLength((String[])reply, (int)2);
        String[] words = reply[0].split(" *: ");
        String[] values = words[2].split(" ");
        int delay = 0;
        try {
            delay = APC7900B.getInteger(values[0]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            APC7900B.responseError((String)reply[0]);
        }
        return delay;
    }

    @Override
    public int[] getOutletOnDelays() throws DriverException {
        return this.getOutletDelays(true);
    }

    @Override
    public int[] getOutletOffDelays() throws DriverException {
        return this.getOutletDelays(false);
    }

    private int[] getOutletDelays(boolean on) throws DriverException {
        String[] reply = this.receiveString(on ? "olOnDelay all" : "olOffDelay all");
        APC7900B.checkReplyLength((String[])reply, (int)(this.getOutletCount() + 1));
        int[] delays = new int[reply.length - 1];
        for (int j = 0; j < reply.length - 1; ++j) {
            String[] values = reply[j].split(" *: ")[2].split(" ");
            try {
                delays[j] = APC7900B.getInteger(values[0]);
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                APC7900B.responseError((String)reply[j]);
            }
        }
        return delays;
    }

    @Override
    public Map<String, Integer> getOutletOnDelayMap() throws DriverException {
        return this.getOutletDelayMap(true);
    }

    @Override
    public Map<String, Integer> getOutletOffDelayMap() throws DriverException {
        return this.getOutletDelayMap(false);
    }

    private Map<String, Integer> getOutletDelayMap(boolean on) throws DriverException {
        String[] reply = this.receiveString(on ? "olOnDelay all" : "olOffDelay all");
        APC7900B.checkReplyLength((String[])reply, (int)(this.getOutletCount() + 1));
        LinkedHashMap<String, Integer> delayMap = new LinkedHashMap<String, Integer>();
        for (int j = 0; j < reply.length - 1; ++j) {
            String[] words = reply[j].split(" *: ");
            String[] values = words[2].split(" ");
            int delay = 0;
            try {
                delay = APC7900B.getInteger(values[0]);
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                APC7900B.responseError((String)reply[j]);
            }
            delayMap.put(words[1], delay);
        }
        return delayMap;
    }

    @Override
    public void setOutletOnDelay(int delay, int outlet) throws DriverException {
        this.receiveString("olOnDelay " + outlet + " " + delay);
    }

    @Override
    public void setOutletOffDelay(int delay, int outlet) throws DriverException {
        this.receiveString("olOffDelay " + outlet + " " + delay);
    }

    @Override
    public void setOutletOnDelay(int delay, String outlet) throws DriverException {
        this.receiveString("olOnDelay \"" + outlet + "\" " + delay);
    }

    @Override
    public void setOutletOffDelay(int delay, String outlet) throws DriverException {
        this.receiveString("olOffDelay \"" + outlet + "\" " + delay);
    }

    @Override
    public void setOutletOnDelay(int delay, int[] outlets) throws DriverException {
        this.receiveString("olOnDelay" + APC7900B.makeOutletString(APC7900B.makeOutletSet(outlets)) + " " + delay);
    }

    @Override
    public void setOutletOffDelay(int delay, int[] outlets) throws DriverException {
        this.receiveString("olOffDelay" + APC7900B.makeOutletString(APC7900B.makeOutletSet(outlets)) + " " + delay);
    }

    @Override
    public void setOutletOnDelay(int delay, String[] outlets) throws DriverException {
        this.receiveString("olOnDelay " + APC7900B.makeOutletString(this.makeOutletSet(outlets)) + " " + delay);
    }

    @Override
    public void setOutletOffDelay(int delay, String[] outlets) throws DriverException {
        this.receiveString("olOffDelay " + APC7900B.makeOutletString(this.makeOutletSet(outlets)) + " " + delay);
    }

    @Override
    public boolean isOutletOn(int outlet) throws DriverException {
        String[] reply = this.receiveString("olStatus " + outlet);
        APC7900B.checkReplyLength((String[])reply, (int)2);
        return reply[0].split(" *: ")[2].trim().equals("On");
    }

    @Override
    public boolean isOutletOn(String outlet) throws DriverException {
        String[] reply = this.receiveString("olStatus \"" + outlet + "\"");
        APC7900B.checkReplyLength((String[])reply, (int)2);
        return reply[0].split(" *: ")[2].trim().equals("On");
    }

    @Override
    public boolean[] getOutletOnStates() throws DriverException {
        String[] reply = this.receiveString("olStatus all");
        boolean[] onStates = new boolean[this.getOutletCount()];
        APC7900B.checkReplyLength((String[])reply, (int)(onStates.length + 1));
        for (int j = 0; j < onStates.length; ++j) {
            onStates[j] = reply[j].split(" *: ")[2].trim().equals("On");
        }
        return onStates;
    }

    @Override
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        String[] reply = this.receiveString("olStatus all");
        APC7900B.checkReplyLength((String[])reply, (int)(this.getOutletCount() + 1));
        LinkedHashMap<String, Boolean> stateMap = new LinkedHashMap<String, Boolean>();
        for (int j = 0; j < reply.length - 1; ++j) {
            String[] words = reply[j].split(" *: ");
            stateMap.put(words[1], words[2].trim().equals("On"));
        }
        return stateMap;
    }

    @Override
    public int setOutletOn(int outlet) throws DriverException {
        this.receiveString("olOn " + outlet);
        return 1;
    }

    @Override
    public int setOutletOff(int outlet) throws DriverException {
        this.receiveString("olOff " + outlet);
        return 1;
    }

    @Override
    public int setOutletOn(String outlet) throws DriverException {
        this.receiveString("olOn \"" + outlet + "\"");
        return 1;
    }

    @Override
    public int setOutletOff(String outlet) throws DriverException {
        this.receiveString("olOff \"" + outlet + "\"");
        return 1;
    }

    @Override
    public int setOutletsOn(int[] outlets) throws DriverException {
        return this.sendOutlets("olOn", outlets);
    }

    @Override
    public int setOutletsOff(int[] outlets) throws DriverException {
        return this.sendOutlets("olOff", outlets);
    }

    @Override
    public int setOutletsOn(String[] outlets) throws DriverException {
        return this.sendOutlets("olOn", outlets);
    }

    @Override
    public int setOutletsOff(String[] outlets) throws DriverException {
        return this.sendOutlets("olOff", outlets);
    }

    @Override
    public int delayedOutletOn(int outlet) throws DriverException {
        this.receiveString("olDlyOn " + outlet);
        return 1;
    }

    @Override
    public int delayedOutletOff(int outlet) throws DriverException {
        this.receiveString("olDlyOff " + outlet);
        return 1;
    }

    @Override
    public int delayedOutletOn(String outlet) throws DriverException {
        this.receiveString("olDlyOn \"" + outlet + "\"");
        return 1;
    }

    @Override
    public int delayedOutletOff(String outlet) throws DriverException {
        this.receiveString("olDlyOff \"" + outlet + "\"");
        return 1;
    }

    @Override
    public int delayedOutletsOn(int[] outlets) throws DriverException {
        return this.sendOutlets("olDlyOn", outlets);
    }

    @Override
    public int delayedOutletsOff(int[] outlets) throws DriverException {
        return this.sendOutlets("olDlyOff", outlets);
    }

    @Override
    public int delayedOutletsOn(String[] outlets) throws DriverException {
        return this.sendOutlets("olDlyOn", outlets);
    }

    @Override
    public int delayedOutletsOff(String[] outlets) throws DriverException {
        return this.sendOutlets("olDlyOff", outlets);
    }

    @Override
    public double[] readCurrent() throws DriverException {
        String[] reply = this.receiveString("phReading all current");
        APC7900B.checkReplyLength((String[])reply, (int)(this.getPhaseCount() + 1));
        double[] current = new double[reply.length - 1];
        for (int j = 0; j < current.length; ++j) {
            try {
                String token = reply[j].split(": ")[1];
                current[j] = Double.valueOf(token.substring(0, token.length() - 1));
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                APC7900B.responseError((String)reply[j]);
            }
        }
        return current;
    }

    private int sendOutlets(String command, int[] outlets) throws DriverException {
        Set<Integer> outletSet = APC7900B.makeOutletSet(outlets);
        this.receiveString(command + APC7900B.makeOutletString(outletSet));
        return outletSet.size();
    }

    private int sendOutlets(String command, String[] outlets) throws DriverException {
        Set<Integer> outletSet = this.makeOutletSet(outlets);
        this.receiveString(command + APC7900B.makeOutletString(outletSet));
        return outletSet.size();
    }

    @Override
    public synchronized String[] receiveString(String command) throws DriverException {
        String[] resp = this.receive(command);
        if (resp.length < 2) {
            throw new DriverException("No response received");
        }
        if (!resp[1].startsWith("E0")) {
            throw new DriverException("Command error " + resp[1]);
        }
        String[] reply = new String[resp.length - 2];
        System.arraycopy(resp, 2, reply, 0, reply.length);
        return reply;
    }

    private void getVersionInfo() throws DriverException {
        String[] reply = this.receiveString("prodinfo");
        APC7900B.checkReplyLength((String[])reply, (int)14);
        this.product = APC7900B.getVersionItemString(reply[2]);
        this.fwVersion = APC7900B.getVersionItemString(reply[0]);
        this.numOutlets = APC7900B.getVersionItemInt(reply[6]);
        this.numPhases = APC7900B.getVersionItemInt(reply[10]);
    }

    private static Set<Integer> makeOutletSet(int[] outlets) {
        HashSet<Integer> outletSet = new HashSet<Integer>();
        for (int outlet : outlets) {
            outletSet.add(outlet);
        }
        return outletSet;
    }

    private Set<Integer> makeOutletSet(String[] outlets) throws DriverException {
        Map<String, Integer> outletMap = this.getOutletNumberMap();
        LinkedHashMap<String, Integer> outletMapLC = new LinkedHashMap<String, Integer>();
        for (String outlet : outletMap.keySet()) {
            outletMapLC.put(outlet.toLowerCase(), outletMap.get(outlet));
        }
        HashSet<Integer> outletSet = new HashSet<Integer>();
        for (String outlet : outlets) {
            Integer outletNum = (Integer)outletMapLC.get(outlet.toLowerCase());
            if (outletNum == null) {
                throw new DriverException("Invalid outlet name: \"" + outlet + "\"");
            }
            outletSet.add(outletNum);
        }
        return outletSet;
    }

    private static String makeOutletString(Set<Integer> outlets) {
        StringBuilder outString = new StringBuilder();
        int sep = 32;
        for (int outlet : outlets) {
            outString.append((char)sep).append(outlet);
            sep = 44;
        }
        if (outString.length() == 0) {
            outString.append(" all");
        }
        return outString.toString();
    }

    private static String getVersionItemString(String line) throws DriverException {
        try {
            return line.substring(18).trim();
        }
        catch (IndexOutOfBoundsException e) {
            APC7900B.responseError((String)line);
            return null;
        }
    }

    private static int getVersionItemInt(String line) throws DriverException {
        try {
            return Integer.valueOf(line.substring(18).trim());
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            APC7900B.responseError((String)line);
            return 0;
        }
    }

    private static int getInteger(String str) {
        return Integer.valueOf(str.trim());
    }
}

