/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcam.filterchanger;

import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.motrona.MotronaIV251;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class MotronaIV251Device
extends Device {
    private final MotronaIV251 iv251 = new MotronaIV251();
    private static final Logger LOG = Logger.getLogger(MotronaIV251Device.class.getName());
    private Integer chanKey;
    @ConfigurationParameter(isFinal=true, description="port Id", units="unitless")
    protected volatile String devcId;
    private final int SSIlowBit = 1;
    private final int SSIhighBit = 25;
    private final int SSIbaudRate = 100000;
    private final int SSIwaitTime = 0;
    private final int SSIoffset = 0;
    private final int SSIsetValue = 1000;
    private final int errorBit = 0;
    private final int errorPolarity = 1;
    static final double mmPerEncoderUnit = 0.005;

    protected void initDevice() {
        this.chanKey = 0;
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "MotronaIV251 " + this.name + " (" + this.devcId + ")";
    }

    protected void initialize() {
        try {
            this.iv251.open(this.devcId);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_LOW_BIT, 1);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_HIGH_BIT, 25);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_BAUD_RATE, 100000);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_WAIT_TIME, 0);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_OFFSET, 0);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_SET_VALUE, 1000);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_ERROR_BIT, 0);
            this.iv251.setParam(MotronaIV251.CmndParam.SSI_ERROR_POLARITY, 1);
            this.iv251.activateData();
            this.initSensors();
            LOG.info("MotronaIV251 " + this.name + " starting linear encoder value = " + Integer.toString(this.iv251.readEncoder()));
            LOG.info("\n Connected to " + this.fullName);
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe("Error connecting to or initializing " + this.fullName + ": " + (Object)((Object)e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.iv251.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        String chName = ch.getName();
        try {
            MotronaIV251.CmndOp.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)chName, (String)"type", (Object)type);
        }
        if (type.equals("POSITION")) {
            Integer n = this.chanKey;
            Integer n2 = this.chanKey = Integer.valueOf(this.chanKey + 1);
        }
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        String chanName = ch.getName();
        String chanType = ch.getTypeStr();
        try {
            if (chanType.equals("POSITION")) {
                value = this.iv251.readEncoder();
                value *= 0.005;
            }
        }
        catch (DriverTimeoutException et) {
            LOG.severe(this.name + " timeout reading " + chanName + ": " + (Object)((Object)et));
            this.setOnline(false);
        }
        catch (DriverException e) {
            LOG.severe(this.name + " exception reading data " + chanName + ": " + (Object)((Object)e));
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, name="readAll", level=1, description="Read all linear-encoder settings and data")
    public String readAll() {
        String table = "Read all IV251 settings and data\n\n";
        MotronaIV251.CmndParam[] cmndN = MotronaIV251.CmndParam.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", cmndN[i]);
            try {
                int respN = this.iv251.readParam(cmndN[i]);
                table = table + String.format("%d", respN);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\nRun -app TestIV251 to decode serial baud rate (0 is 9600) and format";
        table = table + "\n";
        table = table + String.format("\n   %-22s", "Encoder position");
        try {
            int pos = this.iv251.readEncoder();
            table = table + String.format("%d", pos);
        }
        catch (DriverException ex) {
            table = table + ex.getMessage();
        }
        table = table + String.format("\n   %-22s", "Encoder error");
        try {
            int err = this.iv251.readErrorBit();
            table = table + String.format("%d", err);
        }
        catch (DriverException ex) {
            table = table + ex.getMessage();
        }
        table = table + "\n";
        return table;
    }

    @Command(type=Command.CommandType.QUERY, name="readPosition", level=0, description="Read linear-encoder position")
    public int readPosition() throws DriverException {
        return this.iv251.readEncoder();
    }

    @Command(type=Command.CommandType.ACTION, name="saveSettings", level=2, description="Save active values of parameters to EEPROM")
    public void saveSettings() throws DriverException {
        this.iv251.saveToEEProm();
    }
}

