/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.fitter.fitdata.FitData;
import hep.aida.ref.fitter.fitdata.FitDataCreator;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.FunctionIntegrator;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.pdf.NonParametricPdf;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.PdfFitter;
import hep.aida.ref.pdf.Sum;
import java.util.Random;

public class NonParametricPdfFit {
    public static void main(String[] args) {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        IHistogram1D hBkg = histogramFactory.createHistogram1D("hBkg", 100, -10.0, 10.0);
        IHistogram1D hSignal = histogramFactory.createHistogram1D("Signal", 100, -10.0, 10.0);
        ICloud1D cBkg = histogramFactory.createCloud1D("cBkg");
        ICloud1D cSignal = histogramFactory.createCloud1D("Signal");
        Random r = new Random();
        for (int i = 0; i < 5000; ++i) {
            double x = r.nextDouble();
            if (x < 0.5 && r.nextDouble() < x || x > 0.5 && r.nextDouble() < 0.5) {
                x = x * 20.0 - 10.0;
                cBkg.fill(x);
                hBkg.fill(x);
                cSignal.fill(x);
                hSignal.fill(x);
            }
            x = r.nextGaussian();
            cSignal.fill(x);
            hSignal.fill(x);
        }
        Dependent x = new Dependent("x", -10.0, 10.0);
        Parameter m = new Parameter("mean", cSignal.mean(), 0.01);
        Parameter s = new Parameter("sigma", 1.0);
        Gaussian gauss = new Gaussian("gauss", x, m, s);
        NonParametricPdf bkg = new NonParametricPdf("bkg", (FitData)FitDataCreator.create(cBkg), x, 2);
        NonParametricPdf bkgNoMirror = new NonParametricPdf("bkgNoMirror", (FitData)FitDataCreator.create(cBkg), x, 0);
        System.out.println("Integral : " + FunctionIntegrator.integralTrapezoid((Function)bkg, x) + " " + FunctionIntegrator.integralTrapezoid((Function)bkgNoMirror, x));
        Parameter f0 = new Parameter("f0", 0.2, 0.0, 1.0);
        Sum sum = new Sum("Sum of Gauss", gauss, bkg, f0);
        PdfFitter fitter = new PdfFitter("uml", "jminuit");
        fitter.setUseFunctionGradient(false);
        fitter.fit(cSignal, (Function)sum);
        double normSignal = HistUtils.histogramNormalization(hSignal);
        hSignal.scale(1.0 / normSignal);
        double normBkg = HistUtils.histogramNormalization(hBkg);
        hBkg.scale(1.0 / normBkg);
        plotter.createRegions(2, 2);
        plotter.region(0).plot((IBaseHistogram)hBkg);
        plotter.region(0).plot((IFunction)bkg);
        plotter.region(1).plot((IBaseHistogram)hBkg);
        plotter.region(1).plot((IFunction)bkgNoMirror);
        plotter.region(2).plot((IBaseHistogram)hSignal);
        plotter.region(2).plot((IFunction)sum);
        plotter.show();
    }
}

