/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.pathfinder.PathfinderPowerDevice;
import org.lsst.ccs.subsystem.pathfinder.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.pathfinder.data.VacuumException;

public class TrimHeaterControl
implements HasLifecycle {
    public static final int NUM_COLD_RTDS = 8;
    public static final int NUM_CRYO_RTDS = 20;
    private static final String PIC = "Pic";
    @LookupPath
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, PathfinderPowerDevice> powerDevices = new HashMap<String, PathfinderPowerDevice>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double gain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double timeConst = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double smoothTime = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double awGain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double basePower = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double tolerance = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minInput = -200.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double maxInput = 100.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minOutput = 0.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double maxOutput = Double.NaN;
    @ConfigurationParameter(category="Refrig")
    private volatile double tempLimit = Double.NaN;
    @ConfigurationParameter(category="Refrig")
    private volatile double tempDeadband = Double.NaN;
    @ConfigurationParameter(category="Refrig", maxLength=20)
    private volatile Map<String, Double> tempWeights = new ConcurrentHashMap<String, Double>();
    private String powerDevc;
    private Integer powerChan;
    private String[] tempChans;
    private static final Logger LOG = Logger.getLogger(TrimHeaterControl.class.getName());
    private PIController pic;
    private PathfinderPowerDevice powerDevcC;
    private final Map<String, ChannelData> channelData = new LinkedHashMap<String, ChannelData>();
    private volatile double lastPower;
    private volatile double power;
    private volatile TrimHeaterOpState opState;
    private volatile boolean overTemp = false;
    private volatile boolean loopTempError = false;
    private volatile boolean limitTempError = false;

    public void build() {
        ConfigurationParameterDescription desc = new ConfigurationParameterDescription().withCategory(PIC).withName("updateTime");
        AgentPeriodicTask pt = new AgentPeriodicTask(this.name + "-iterate", () -> this.iterateLoop()).withPeriod(Duration.ofMillis(10000L)).withPeriodParameterDescription(desc);
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        pt = new AgentPeriodicTask(this.name + "-tempCheck", () -> this.checkTempLimit()).withPeriod(Duration.ofMillis(2000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        if (Double.isNaN(this.gain)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (Double.isNaN(this.timeConst)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (Double.isNaN(this.smoothTime)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (Double.isNaN(this.awGain)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (Double.isNaN(this.basePower)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"basePower", (String)"is missing");
        }
        if (Double.isNaN(this.tolerance)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        if (Double.isNaN(this.maxOutput)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maxOutput", (String)"is missing");
        }
        if (this.minOutput < 0.0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"minOutput", (String)("value (" + this.minOutput + ") must be non-negative"));
        }
        if (this.powerDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerDevc", (String)"is missing");
        }
        this.powerDevcC = this.powerDevices.get(this.powerDevc);
        if (this.powerDevcC == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerDevc", (String)(this.powerDevc + " doesn't exist"));
        }
        if (this.powerChan == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerChan", (String)"is missing");
        }
        if (this.tempChans == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempChans", (String)"is missing");
        }
        for (String cName : this.tempChans) {
            Double value;
            Channel chan = this.allChannels.get(cName);
            if (chan == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempChans", (String)("element " + cName + " doesn't exist"));
            }
            ChannelData cData = new ChannelData();
            this.channelData.put(cName, cData);
            cData.channel = chan;
            cData.weight = this.tempWeights.isEmpty() ? 1.0 : ((value = this.tempWeights.get(cName)) == null ? 0.0 : value);
        }
        if (Double.isNaN(this.tempLimit)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempLimit", (String)"is missing");
        }
        if (Double.isNaN(this.tempDeadband)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempDeadband", (String)"is missing");
        }
        if (this.tempDeadband <= 0.0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempDeadband", (String)"is non-positive");
        }
        this.pic = new PIController(this.gain, this.timeConst);
        this.pic.setSmoothTime(this.smoothTime);
        this.pic.setAwGain(this.awGain);
        this.pic.setBaseOutput(this.basePower);
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput);
        this.pic.setTolerance(this.tolerance);
    }

    @ConfigurationParameterChanger
    public void setTempWeights(Map<String, Double> weights) {
        if (!this.channelData.isEmpty()) {
            this.checkTempWeights(weights);
            for (ChannelData channelData : this.channelData.values()) {
                channelData.weight = weights.isEmpty() ? 1.0 : 0.0;
            }
            for (Map.Entry entry : weights.entrySet()) {
                ChannelData cData = this.channelData.get((String)entry.getKey());
                if (cData == null) continue;
                cData.weight = (Double)entry.getValue();
            }
        }
        this.tempWeights.clear();
        this.tempWeights.putAll(weights);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of temperature channel names")
    public String getTempChannelNames() {
        return this.channelData.keySet().toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Set a temperature weight")
    public void setTempWeight(@Argument(description="Channel name") String cName, @Argument(description="Channel weight") double weight) throws VacuumException {
        HashMap<String, Double> weights = new HashMap<String, Double>();
        weights.putAll(this.tempWeights);
        weights.put(cName, weight);
        this.configService.change(this.name, "tempWeights", weights);
    }

    public int getPowerChannel() {
        return this.powerChan;
    }

    public synchronized void setPower(double value) {
        this.power = value;
        if (this.opState == TrimHeaterOpState.POWER) {
            this.powerDevcC.setPower(this.powerChan, this.power);
            this.lastPower = this.power;
        }
    }

    public void setTemp(double value) {
        this.pic.setSetpoint(value);
    }

    public synchronized void setOpState(TrimHeaterOpState state) {
        this.opState = state;
        switch (this.opState) {
            case OFF: {
                this.powerDevcC.enableOutput(this.powerChan, false);
                break;
            }
            case POWER: {
                this.powerDevcC.enableOutput(this.powerChan, !this.overTemp);
                this.powerDevcC.setPower(this.powerChan, this.power);
                this.lastPower = this.power;
                break;
            }
            case TEMP: {
                this.pic.reset();
                this.pic.setIntegral(this.lastPower - this.basePower);
                this.powerDevcC.enableOutput(this.powerChan, !this.overTemp);
            }
        }
    }

    public boolean isOverTemp() {
        return this.overTemp;
    }

    private synchronized void iterateLoop() {
        if (this.opState != TrimHeaterOpState.TEMP || this.overTemp) {
            return;
        }
        double temp = 0.0;
        double weight = 0.0;
        for (ChannelData cData : this.channelData.values()) {
            double value = cData.channel.getValue();
            if (Double.isNaN(value)) continue;
            temp += cData.weight * value;
            weight += cData.weight;
        }
        if (weight > 0.0) {
            if (this.loopTempError) {
                LOG.log(Level.INFO, "{0} control loop iteration succeeded again", this.name);
                this.loopTempError = false;
            }
            double avgTemp = temp / weight;
            LOG.log(Level.FINE, "{0} control loop average temperature = {1}", new Object[]{this.name, avgTemp});
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastPower = this.pic.performPI(new double[]{avgTemp}, tod);
            this.powerDevcC.setPower(this.powerChan, this.lastPower);
        } else if (!this.loopTempError) {
            LOG.log(Level.SEVERE, "{0} control loop iteration failed: no valid temperatures available", this.name);
            this.loopTempError = true;
        }
    }

    private synchronized void checkTempLimit() {
        int nValidChan = 0;
        boolean newOverTemp = false;
        for (ChannelData cData : this.channelData.values()) {
            double temp = cData.channel.getValue();
            if (Double.isNaN(temp)) continue;
            ++nValidChan;
            if (temp < this.tempLimit - this.tempDeadband) {
                cData.overTemp = false;
            } else if (temp >= this.tempLimit) {
                cData.overTemp = true;
            }
            if (!cData.overTemp) continue;
            newOverTemp = true;
        }
        if (nValidChan == 0) {
            if (!this.limitTempError) {
                LOG.log(Level.SEVERE, "{0} temperature check failed: no valid temperatures available", this.name);
                this.limitTempError = true;
            }
        } else {
            if (this.limitTempError) {
                LOG.log(Level.INFO, "{0} temperature check succeeded again", this.name);
                this.limitTempError = false;
            }
            if (newOverTemp ^ this.overTemp) {
                this.overTemp = newOverTemp;
                this.powerDevcC.enableOutput(this.powerChan, this.overTemp ? false : this.opState != TrimHeaterOpState.OFF);
            }
        }
    }

    private void checkTempWeights(Map<String, Double> weights) {
        for (Map.Entry<String, Double> entry : weights.entrySet()) {
            String cName = entry.getKey();
            if (this.channelData.get(cName) == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempWeights", (String)("element " + cName + " doesn't exist"));
            }
            if (!(entry.getValue() < 0.0)) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempWeights", (String)("element " + cName + " has negative value"));
        }
    }

    static class ChannelData {
        Channel channel;
        double weight;
        boolean overTemp;

        ChannelData() {
        }
    }
}

