/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.RefrigAction;
import org.lsst.ccs.subsystem.refrig.ChillerSubsystem;
import org.lsst.ccs.subsystem.refrig.constants.ChillerAlerts;

public class ChillerAlertListener
implements AlertListener,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private ChillerSubsystem subsys;
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(ChillerSubsystem.class.getName());
    @ConfigurationParameter(isFinal=true, units="unitless", description="Subsystem listened to for vacuum alerts")
    protected volatile String vacuumAlertSource;
    @ConfigurationParameter(isFinal=true, units="unitless", description="Subsystem listened to for temperature alerts")
    protected volatile String thermalAlertSource;
    private List<String> sources = new ArrayList<String>();
    private List<AlertAction> actions = new ArrayList<AlertAction>();
    private Map<AlertAction, List<String>> idMap = new HashMap<AlertAction, List<String>>();

    public void init() {
        this.propertiesService.setAgentProperty(RefrigAction.getManagerName(), "");
        if (!this.subsys.getConnectedToCamera()) {
            return;
        }
        this.actions.add(new AlertAction(this.vacuumAlertSource, RefrigAction.Action.VACUUM_INSUFFICIENT, ChillerAlerts.VACUUM_LIMIT));
        this.actions.add(new AlertAction(this.thermalAlertSource, RefrigAction.Action.COLD_PLATE_TOO_COLD, ChillerAlerts.COLD_TEMP_LOW));
        this.actions.add(new AlertAction(this.thermalAlertSource, RefrigAction.Action.COLD_PLATE_TOO_WARM, ChillerAlerts.COLD_TEMP_HIGH));
        for (AlertAction act : this.actions) {
            String src = act.getSource();
            if (!this.sources.contains(src)) {
                this.sources.add(src);
            }
            this.idMap.put(act, new CopyOnWriteArrayList());
        }
        this.alertService.startStatusAlertListening(info -> this.sources.contains(info.getName()));
        LOG.log(Level.INFO, this.name + " listening to Alerts from " + this.sources);
    }

    public void start() {
        this.alertService.addListener((AlertListener)this);
    }

    public void shutdown() {
        this.alertService.removeListener((AlertListener)this);
    }

    public void onAlert(AlertEvent event) {
        switch (event.getType()) {
            case ALERT_RAISED: {
                AlertAction action;
                if (event.getLevel() != AlertState.ALARM || (action = this.findAction(event.getAlert())) == null) break;
                this.raiseAlarm(event.getAlert(), action);
                break;
            }
            case ALERT_CLEARED: {
                List cleared = event.getClearedIds();
                for (AlertAction action : this.actions) {
                    if (this.idMap.get(action).isEmpty()) continue;
                    for (String id : cleared) {
                        this.idMap.get(action).remove(id);
                    }
                    if (!this.idMap.get(action).isEmpty()) continue;
                    this.alertService.raiseAlert(action.getResponse().newAlert(), AlertState.NOMINAL, " source Alert(s) cleared");
                }
                break;
            }
            case AGENT_CONNECTION: {
                String srcConn = event.getSource();
                LOG.log(Level.INFO, "Agent " + srcConn + " connected");
                for (AlertAction act : this.actions) {
                    if (!act.getSource().equals(srcConn)) continue;
                    boolean raised = !this.idMap.get(act).isEmpty();
                    this.idMap.get(act).clear();
                    for (RaisedAlertHistory hist : event.getSummary().getAllRaisedAlertHistories()) {
                        if (hist.getHighestAlertState() != AlertState.ALARM || this.findAction(hist.getHighestAlert()) != act) continue;
                        this.raiseAlarm(hist.getHighestAlert(), act);
                    }
                    if (!raised || !this.idMap.get(act).isEmpty()) continue;
                    this.alertService.raiseAlert(act.getResponse().newAlert(), AlertState.NOMINAL, " source Alert(s) cleared");
                }
                break;
            }
            case AGENT_DISCONNECTION: {
                LOG.log(Level.WARNING, "Agent " + event.getSource() + " disconnected");
                break;
            }
        }
    }

    private AlertAction findAction(Alert alert) {
        AlertAction action = null;
        for (AlertAction act : this.actions) {
            if (RefrigAction.getData((Alert)alert) == null || RefrigAction.getData((Alert)alert).action != act.getAction()) continue;
            action = act;
            break;
        }
        return action;
    }

    public void raiseAlarm(Alert alert, AlertAction action) {
        String id = alert.getAlertId();
        if (!this.idMap.get(action).contains(id)) {
            this.idMap.get(action).add(id);
        }
        this.alertService.raiseAlert(action.getResponse().newAlert(), AlertState.ALARM, action.getResponse().getDescription() + ", from Alert " + id);
    }

    private static class AlertAction {
        private String source;
        private RefrigAction.Action action;
        private ChillerAlerts response;

        AlertAction(String source, RefrigAction.Action action, ChillerAlerts calert) {
            this.source = source;
            this.action = action;
            this.response = calert;
        }

        public String getSource() {
            return this.source;
        }

        public RefrigAction.Action getAction() {
            return this.action;
        }

        public ChillerAlerts getResponse() {
            return this.response;
        }
    }
}

