/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.kafka;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.kafka.SALKafkaHashTable;
import org.lsst.sal.kafka.SALKafkaUtils;
import org.springframework.beans.PropertyAccessorFactory;

class SALKafkaObject<SS> {
    private static final Logger LOG = Logger.getLogger(SALKafkaObject.class.getName());
    private final SALType type;
    private final String salClass;
    private final String simpleSALClass;
    private final List<SALObjectField> fields;
    private final String revCode;
    private final String cscName;
    private int index;
    private final boolean buildSchemaOnTheFly = false;
    private final Schema schema;
    private static final SALKafkaUtils utils = SALKafkaUtils.instance();

    SALKafkaObject(String[] tokenizedLine, SALKafkaHashTable hashTable, File avroTemplatesDir, String cscName) throws ReflectiveOperationException, IOException {
        this.type = SALType.valueOf(tokenizedLine[0].toUpperCase());
        this.simpleSALClass = tokenizedLine[1];
        this.salClass = tokenizedLine[2];
        this.revCode = hashTable.getRevCode(this.salClass);
        this.cscName = cscName;
        if (tokenizedLine.length == 3) {
            this.fields = Collections.EMPTY_LIST;
        } else {
            this.fields = new ArrayList<SALObjectField>();
            for (int i = 3; i < tokenizedLine.length; i += 2) {
                Class salType = this.parseFieldType(tokenizedLine[i]);
                String fieldName = tokenizedLine[i + 1];
                this.fields.add(new SALObjectField(fieldName, salType));
            }
        }
        this.schema = this.computeSchema(avroTemplatesDir, false, cscName);
    }

    private Class parseFieldType(String typeString) throws ClassNotFoundException {
        boolean isArray = typeString.endsWith("[]");
        if (isArray) {
            typeString = typeString.substring(0, typeString.length() - 2);
        }
        switch (typeString) {
            case "boolean": {
                return isArray ? boolean[].class : Boolean.TYPE;
            }
            case "int": {
                return isArray ? int[].class : Integer.TYPE;
            }
            case "short": {
                return isArray ? short[].class : Short.TYPE;
            }
            case "long": {
                return isArray ? long[].class : Long.TYPE;
            }
            case "float": {
                return isArray ? float[].class : Float.TYPE;
            }
            case "double": {
                return isArray ? double[].class : Double.TYPE;
            }
            case "byte": {
                return isArray ? byte[].class : Byte.TYPE;
            }
            case "String": {
                return String.class;
            }
        }
        return Class.forName(typeString);
    }

    SALType getType() {
        return this.type;
    }

    String getRevCode() {
        return this.revCode;
    }

    public String getSimpleSALClass() {
        return this.simpleSALClass;
    }

    public String getSalClass() {
        return this.salClass;
    }

    Schema getSchema() {
        return this.schema;
    }

    String getTopic(String topicRoot) {
        return topicRoot + "." + this.cscName + "." + this.schema.getName();
    }

    String getKey() {
        switch (this.type) {
            case EVENT: 
            case STATE: {
                return String.format("{ \"name\": \"%s\", \"topic\": \"%s\" }", this.cscName, this.schema.getName());
            }
        }
        return null;
    }

    private Schema computeSchema(File avroTemplatesDir, boolean buildSchemaOnTheFly, String cscName) {
        if (buildSchemaOnTheFly) {
            Schema onTheFlySchema = Schema.createRecord(this.salClass, null, "org.lsst.camera", false);
            ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
            for (SALObjectField field : this.fields) {
                Schema fieldSchema = field.getAvroType();
                avroFields.add(new Schema.Field(field.getName(), fieldSchema));
            }
            onTheFlySchema.setFields(avroFields);
            return onTheFlySchema;
        }
        File file = new File(avroTemplatesDir, cscName + "/" + this.salClass.replace(".", "_") + ".json");
        try {
            return Schema.parse(file);
        }
        catch (IOException x) {
            throw new RuntimeException("Unable to parse json schema " + file, x);
        }
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    GenericRecord createRecord(Object data, String cscName, int seqNum) {
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(this.schema);
        this.fillGenericRecord(recordBuilder, data, cscName, seqNum);
        return recordBuilder.build();
    }

    ObjectWithPrivateData createObjectFromRecord(GenericRecord genericRecord) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?> constuctor = Class.forName(this.simpleSALClass).getConstructors()[0];
        Object[] constructorArgs = new Object[constuctor.getParameterCount()];
        int i = 0;
        int nPrivate = 0;
        String identity = null;
        int origin = 0;
        int seqNum = 0;
        for (Schema.Field field : this.schema.getFields()) {
            Enum[] enumConstants;
            Class<?> enumClass;
            if (field.name().startsWith("private_")) {
                switch (field.name()) {
                    case "private_sndStamp": 
                    case "private_rcvStamp": 
                    case "private_efdStamp": 
                    case "private_kafkaStamp": 
                    case "private_revCode": {
                        break;
                    }
                    case "private_seqNum": {
                        seqNum = ((Number)genericRecord.get(field.name())).intValue();
                        break;
                    }
                    case "private_origin": {
                        origin = ((Number)genericRecord.get(field.name())).intValue();
                        break;
                    }
                    case "private_identity": {
                        identity = genericRecord.get(field.name()).toString();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown private SAL field: " + field.name());
                    }
                }
                ++nPrivate;
                continue;
            }
            Object value = genericRecord.get(field.name());
            Class<?> parameterType = constuctor.getParameterTypes()[i];
            if (parameterType.isEnum() && value instanceof Integer) {
                enumClass = parameterType;
                enumConstants = (Enum[])enumClass.getEnumConstants();
                int iValue = (Integer)value;
                if (iValue < 1 || iValue > enumConstants.length) {
                    LOG.log(Level.WARNING, "Invalid enum index {0} for {1}", new Object[]{value, field.name()});
                } else {
                    Enum enumConstant = enumConstants[iValue - 1];
                    value = enumConstant;
                }
            } else if (parameterType.isArray() && parameterType.getComponentType().isEnum() && value instanceof List) {
                enumClass = parameterType.getComponentType();
                enumConstants = (Enum[])enumClass.getEnumConstants();
                List valueList = (List)value;
                Object enumArray = Array.newInstance(enumClass, valueList.size());
                for (int j = 0; j < valueList.size(); ++j) {
                    if ((Integer)valueList.get(j) < 1 || (Integer)valueList.get(j) > enumConstants.length) {
                        LOG.log(Level.WARNING, "Invalid enum index {0} for {1}", new Object[]{valueList.get(j), field.name()});
                        continue;
                    }
                    Array.set(enumArray, j, enumConstants[(Integer)valueList.get(j) - 1]);
                }
                value = enumArray;
            } else if (value instanceof CharSequence) {
                value = value.toString();
            } else if (value instanceof List) {
                List valueList = (List)value;
                if (valueList.get(0) instanceof Integer) {
                    value = valueList.stream().mapToInt(o -> (Integer)o).toArray();
                } else if (valueList.get(0) instanceof Double) {
                    value = valueList.stream().mapToDouble(o -> (Double)o).toArray();
                } else if (valueList.get(0) instanceof Long) {
                    value = valueList.stream().mapToLong(o -> (Long)o).toArray();
                } else if (valueList.get(0) instanceof Boolean) {
                    boolean[] array = new boolean[valueList.size()];
                    for (int j = 0; j < array.length; ++j) {
                        array[j] = (Boolean)valueList.get(j);
                    }
                    value = array;
                }
            }
            constructorArgs[i++] = value instanceof CharSequence ? value.toString() : value;
        }
        try {
            return new ObjectWithPrivateData(constuctor.newInstance(constructorArgs), identity, origin, seqNum);
        }
        catch (IllegalArgumentException x) {
            for (int j = 0; j < constructorArgs.length; ++j) {
                Class<?> argType = constuctor.getParameterTypes()[j];
                System.out.printf("%s %s %s %s\n", this.schema.getFields().get(nPrivate + j).name(), argType, constructorArgs[j], argType.isAssignableFrom(constructorArgs[j].getClass()));
            }
            throw x;
        }
    }

    private void fillGenericRecord(GenericRecordBuilder recordBuilder, Object data, String cscName, int seqNum) {
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        this.schema.getFields().forEach(r -> {
            String varName = r.name();
            if (varName.startsWith("private_")) {
                switch (varName) {
                    case "private_sndStamp": {
                        recordBuilder.set(varName, (Object)now.getTAIDouble());
                        break;
                    }
                    case "private_rcvStamp": {
                        recordBuilder.set(varName, (Object)0.0);
                        break;
                    }
                    case "private_efdStamp": {
                        recordBuilder.set(varName, (Object)now.getUTCDouble());
                        break;
                    }
                    case "private_kafkaStamp": {
                        recordBuilder.set(varName, (Object)now.getTAIDouble());
                        break;
                    }
                    case "private_origin": {
                        recordBuilder.set(varName, (Object)utils.getPid());
                        break;
                    }
                    case "private_seqNum": {
                        recordBuilder.set(varName, (Object)seqNum);
                        break;
                    }
                    case "private_revCode": {
                        recordBuilder.set(varName, (Object)this.getRevCode());
                        break;
                    }
                    case "private_identity": {
                        recordBuilder.set(varName, (Object)cscName);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown private SAL field: " + varName);
                    }
                }
            } else {
                Object propertyValue = "summaryState".equals(varName) && this.type == SALType.STATE ? PropertyAccessorFactory.forDirectFieldAccess((Object)data).getPropertyValue("substate") : PropertyAccessorFactory.forDirectFieldAccess((Object)data).getPropertyValue(varName);
                if (propertyValue instanceof int[]) {
                    int[] intArray = (int[])propertyValue;
                    ArrayList<Integer> intList = new ArrayList<Integer>(intArray.length);
                    for (int i : intArray) {
                        intList.add(i);
                    }
                    propertyValue = intList;
                } else if (propertyValue instanceof double[]) {
                    double[] intArray = (double[])propertyValue;
                    ArrayList<Double> intList = new ArrayList<Double>(intArray.length);
                    for (double i : intArray) {
                        intList.add(i);
                    }
                    propertyValue = intList;
                } else if (propertyValue instanceof boolean[]) {
                    boolean[] intArray = (boolean[])propertyValue;
                    ArrayList<Boolean> intList = new ArrayList<Boolean>(intArray.length);
                    for (boolean i : intArray) {
                        intList.add(i);
                    }
                    propertyValue = intList;
                } else if (propertyValue instanceof long[]) {
                    long[] intArray = (long[])propertyValue;
                    ArrayList<Long> intList = new ArrayList<Long>(intArray.length);
                    for (long i : intArray) {
                        intList.add(i);
                    }
                    propertyValue = intList;
                } else if (propertyValue instanceof Enum) {
                    propertyValue = ((Enum)propertyValue).ordinal() + 1;
                } else if (propertyValue instanceof Enum[]) {
                    Enum[] enumList = (Enum[])propertyValue;
                    ArrayList<Integer> intList = new ArrayList<Integer>(enumList.length);
                    for (Enum e : enumList) {
                        intList.add(e.ordinal() + 1);
                    }
                    propertyValue = intList;
                }
                recordBuilder.set(varName, propertyValue);
            }
        });
    }

    class ObjectWithPrivateData {
        private final String identity;
        private final int origin;
        private final Object object;
        private final int seqNum;

        public ObjectWithPrivateData(Object object, String identity, int origin, int seqNum) {
            this.identity = identity;
            this.origin = origin;
            this.object = object;
            this.seqNum = seqNum;
        }

        String getIdentity() {
            return this.identity;
        }

        int getOrigin() {
            return this.origin;
        }

        Object getObject() {
            return this.object;
        }

        int getSeqNum() {
            return this.seqNum;
        }
    }

    private static class SALObjectField<SS, T> {
        private final String name;
        private final Class type;

        private SALObjectField(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        private Schema getAvroType() {
            if (this.type == Integer.TYPE) {
                return Schema.create(Schema.Type.INT);
            }
            if (this.type == Double.TYPE) {
                return Schema.create(Schema.Type.DOUBLE);
            }
            if (this.type == Short.TYPE) {
                return Schema.create(Schema.Type.INT);
            }
            if (this.type == Byte.TYPE) {
                return Schema.create(Schema.Type.INT);
            }
            if (this.type == Float.TYPE) {
                return Schema.create(Schema.Type.FLOAT);
            }
            if (this.type == String.class) {
                return Schema.create(Schema.Type.STRING);
            }
            if (this.type == Boolean.TYPE) {
                return Schema.create(Schema.Type.BOOLEAN);
            }
            if (this.type == Long.TYPE) {
                return Schema.create(Schema.Type.LONG);
            }
            if (this.type == int[].class) {
                return Schema.createArray(Schema.create(Schema.Type.INT));
            }
            if (this.type == double[].class) {
                return Schema.createArray(Schema.create(Schema.Type.DOUBLE));
            }
            if (this.type == short[].class) {
                return Schema.createArray(Schema.create(Schema.Type.INT));
            }
            if (this.type == byte[].class) {
                return Schema.createArray(Schema.create(Schema.Type.INT));
            }
            if (this.type == float[].class) {
                return Schema.createArray(Schema.create(Schema.Type.FLOAT));
            }
            if (this.type == boolean[].class) {
                return Schema.createArray(Schema.create(Schema.Type.BOOLEAN));
            }
            if (this.type == long[].class) {
                return Schema.createArray(Schema.create(Schema.Type.LONG));
            }
            throw new RuntimeException("Unsupported type " + this.type);
        }
    }

    static enum SALType {
        COMMAND,
        EVENT,
        STATE,
        TELEMETRY,
        ACK;

    }
}

