/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.auxelex.IonPump;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.comcamvacuum.IonPumpControl;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacuumException;
import org.lsst.ccs.utilities.logging.Logger;

public class IonPumpDevice
extends Device {
    public static final int CHAN_HIP1 = 0;
    public static final int CHAN_HIP2 = 1;
    public static final int CHAN_OIP = 3;
    public static final int CHAN_CIP1 = 2;
    private static final int MON_TYPE_VOLTAGE = 0;
    private static final int MON_TYPE_CURRENT = 1;
    private static final int MON_TYPE_POWER = 2;
    private static final String IP_ADDRESS = "ipAddr";
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, IonPumpControl> ctrlChans = new LinkedHashMap<String, IonPumpControl>();
    @ConfigurationParameter(name="ipAddr", category="Cryo", isFinal=true)
    private String ipAddr;
    private static final Logger LOG;
    private final IonPump ipc = new IonPump();

    protected void initDevice() {
        if (this.ipAddr == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)IP_ADDRESS, (String)"is missing");
        }
        this.fullName = "Ion pump controller (" + this.ipAddr + ")";
    }

    protected void initialize() {
        try {
            this.ipc.open(this.ipAddr);
            for (IonPumpControl ctrl : this.ctrlChans.values()) {
                ctrl.writeVoltage();
                ctrl.writeCurrent();
                ctrl.writePower();
            }
            this.initSensors();
            this.setOnline(true);
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException | VacuumException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.ipc.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan;
        String type = ch.getTypeStr();
        String name = ch.getName();
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        if ((hwChan = ch.getHwChan()) < 0 || hwChan >= 9) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        String item = null;
        if (this.isOnline()) {
            int type = ch.getType();
            int hwChan = ch.getHwChan();
            try {
                switch (type) {
                    case 0: {
                        item = "voltage";
                        value = this.ipc.readVoltage(hwChan);
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.ipc.readCurrent(hwChan);
                        break;
                    }
                    case 2: {
                        item = "power";
                        value = this.ipc.readPower(hwChan);
                    }
                }
            }
            catch (DriverException e) {
                LOG.error((Object)("Error reading " + this.fullName + " " + item + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }

    protected void setChannelOn(int chan, boolean on) {
        try {
            if (on) {
                this.ipc.powerOn(chan);
            } else {
                this.ipc.powerOff(chan);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error setting channel " + chan + " on " + this.fullName));
        }
    }

    protected Boolean isChannelOn(int chan) {
        if (!this.isOnline()) {
            return null;
        }
        try {
            return this.ipc.isPowered(chan);
        }
        catch (DriverException e) {
            LOG.error((Object)("Error getting state for channel " + chan + " on " + this.fullName));
            return null;
        }
    }

    public List<String> getChannelNames() {
        return new ArrayList<String>(this.ctrlChans.keySet());
    }

    public List<Integer> getChannelNumbers() {
        ArrayList<Integer> chans = new ArrayList<Integer>();
        for (IonPumpControl ctrl : this.ctrlChans.values()) {
            chans.add(ctrl.getHwChan());
        }
        return chans;
    }

    void setVoltage(int chan, double value) throws VacuumException {
        try {
            this.ipc.setVoltage(chan, value);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    void setCurrent(int chan, double value) throws VacuumException {
        try {
            this.ipc.setCurrent(chan, value);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    void setPower(int chan, double value) throws VacuumException {
        try {
            this.ipc.setPower(chan, value);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    void powerOn(int chan) throws VacuumException {
        try {
            this.ipc.powerOn(chan);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    void powerOff(int chan) throws VacuumException {
        try {
            this.ipc.powerOff(chan);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    private IonPumpControl getControl(String name) throws VacuumException {
        IonPumpControl ctrl = this.ctrlChans.get(name);
        if (ctrl == null) {
            throw new VacuumException("Unrecognized ion pump name: " + name);
        }
        return ctrl;
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
        mTypeMap.put("POWER", 2);
        LOG = Logger.getLogger((String)IonPumpDevice.class.getName());
    }
}

