/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.yaskawa.A1000;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.constants.VfdState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class A1000Device
extends Device {
    public static final int CHAN_FREQUENCY = 0;
    public static final int CHAN_CURRENT = 1;
    public static final int CHAN_VOLTAGE = 2;
    public static final int CHAN_TEMPERATURE = 3;
    public static final int NUM_CHANS = 4;
    private static final double INPUT_VOLTAGE = 380.0;
    private static final double MAX_FREQ_PCT = 110.0;
    @ConfigurationParameter(category="Device", isFinal=true)
    private volatile String devcName;
    @ConfigurationParameter(category="Device", isFinal=true)
    private volatile int baudRate = 0;
    @ConfigurationParameter(category="Device", isFinal=true)
    private volatile int address = 0;
    private static final Logger LOG = Logger.getLogger(A1000Device.class.getName());
    private final A1000 a1000 = new A1000();
    private String compName;
    private boolean initError = false;
    private int faultCode = 0;
    private Set<Integer> alarmCodes = new HashSet<Integer>();
    private final int MAX_READ = 16;

    protected void initDevice() {
        if (this.devcName == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getPath(), (String)"devcName", (String)"is missing");
        }
        this.fullName = this.getPath() + " (A1000 VFD at " + this.devcName + ":" + this.address + ")";
        for (Integer code : A1000.getAllAvailableAlarmCodes()) {
            this.alertService.registerAlert(this.getAlarmAlert(code));
        }
        for (Integer code : A1000.getAllAvailableFaultCodes()) {
            this.alertService.registerAlert(this.getFaultAlert(code));
        }
    }

    protected void initialize() {
        try {
            this.a1000.open(this.devcName, this.address, this.baudRate);
            try {
                if ((this.a1000.getDriveStatus() & 1) == 0) {
                    this.initParams();
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error initializing {0} parameters: {1}", new Object[]{this.fullName, e});
            }
            this.initSensors();
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.a1000.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void close() {
        try {
            this.a1000.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    public void setCompressorName(String name) {
        this.compName = name;
    }

    public void setFrequency(double freq) throws RefrigException {
        try {
            this.a1000.setFrequency(freq);
        }
        catch (DriverException e) {
            this.setOnline(false);
            throw new RefrigException("Error setting frequency for " + this.getPath() + ": " + (Object)((Object)e));
        }
    }

    public double getFrequency() {
        double value = Double.NaN;
        if (this.isOnline()) {
            try {
                value = this.a1000.getFrequencyApp();
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error getting frequency for {0}: {1}", new Object[]{this.getPath(), e});
                this.setOnline(false);
            }
        }
        return value;
    }

    public void resetFault() throws RefrigException {
        try {
            this.a1000.resetFault();
            this.a1000.runForward();
        }
        catch (DriverException e) {
            this.setOnline(false);
            throw new RefrigException("Error resetting fault for " + this.getPath() + ": " + (Object)((Object)e));
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan >= 4) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        if (this.isOnline()) {
            String quantity = null;
            try {
                switch (ch.getHwChan()) {
                    case 0: {
                        quantity = "frequency";
                        value = this.a1000.readFrequency();
                        break;
                    }
                    case 1: {
                        quantity = "current";
                        value = this.a1000.readCurrent();
                        break;
                    }
                    case 2: {
                        quantity = "voltage";
                        value = this.a1000.readVoltage();
                        break;
                    }
                    case 3: {
                        quantity = "temperature";
                        value = this.a1000.readTemperature();
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.getPath(), quantity, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    public VfdState getState() {
        VfdState state = VfdState.OFFLINE;
        if (this.isOnline()) {
            try {
                HashSet<Integer> codes;
                int code;
                int driveStatus = this.a1000.getDriveStatus();
                VfdState vfdState = (driveStatus & 4) != 0 ? VfdState.REVERSE : ((driveStatus & 2) != 0 ? VfdState.ZEROFREQ : (state = (driveStatus & 1) != 0 ? VfdState.RUNNING : VfdState.STOPPED));
                if ((driveStatus & 0x80) != 0) {
                    code = this.a1000.getCurrFaultCode();
                    state = VfdState.FAULT;
                } else {
                    code = 0;
                }
                if (code != this.faultCode) {
                    if (this.faultCode != 0) {
                        this.lowerFault(this.faultCode);
                    }
                    if (code != 0) {
                        this.raiseFault(code);
                    }
                    this.faultCode = code;
                }
                if ((driveStatus & 0x40) != 0) {
                    codes = this.a1000.getAlarmCodes();
                    state = VfdState.ALARM;
                } else {
                    codes = new HashSet<Integer>();
                }
                if (!codes.equals(this.alarmCodes)) {
                    for (int alarmCode : this.alarmCodes) {
                        if (codes.contains(alarmCode)) continue;
                        this.lowerAlarm(alarmCode);
                    }
                    for (int alarmCode : codes) {
                        if (this.alarmCodes.contains(alarmCode)) continue;
                        this.raiseAlarm(alarmCode);
                    }
                    this.alarmCodes = codes;
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0}: {1}", new Object[]{this.getPath(), e});
                this.setOnline(false);
            }
        }
        return state;
    }

    private void raiseFault(int code) {
        this.alertService.raiseAlert(this.getFaultAlert(code), AlertState.ALARM, "Fault raised: " + A1000.getFaultDesc((int)code));
    }

    private void lowerFault(int code) {
        this.alertService.raiseAlert(this.getFaultAlert(code), AlertState.NOMINAL, "Fault cleared: " + A1000.getFaultDesc((int)code));
    }

    private Alert getFaultAlert(int code) {
        return new Alert(this.compName + "VfdFault" + code, this.compName + "VFD fault condition " + code);
    }

    private void raiseAlarm(int code) {
        this.alertService.raiseAlert(this.getAlarmAlert(code), AlertState.WARNING, "Alarm raised: " + A1000.getAlarmDesc((int)code));
    }

    private void lowerAlarm(int code) {
        this.alertService.raiseAlert(this.getAlarmAlert(code), AlertState.NOMINAL, "Alarm cleared: " + A1000.getAlarmDesc((int)code));
    }

    private Alert getAlarmAlert(int code) {
        return new Alert(this.compName + "VfdAlarm" + code, this.compName + "VFD alarm condition " + code);
    }

    @Command(type=Command.CommandType.ACTION, description="Initialize parameters")
    public void initParams() throws DriverException {
        this.a1000.setAccessLevel(A1000.AccessLevel.FULL);
        this.a1000.setRunCmndFwdRev(true);
        this.a1000.setRunProg(A1000.RunProg.RUN_ONLY);
        this.a1000.setStopMethod(A1000.StopMethod.COAST);
        this.a1000.setControlMode(A1000.ControlMode.VF);
        this.a1000.setErrorAction(A1000.ErrorAction.ALARM_ONLY);
        this.a1000.setFaultDetected(false);
        this.a1000.setInputVoltage(380.0);
        this.a1000.setVfSelection(A1000.VfSelection.HZ50);
        this.a1000.setVoltageUnits(A1000.VoltageUnits.TENTHS);
        this.a1000.setMaxFrequency(110.0);
        this.a1000.setEnterRequired(false);
        this.a1000.setReversePermitted(false);
        this.a1000.setRunCmndSrc(A1000.RunCmndSrc.MODBUS);
        this.a1000.setFreqRefSrc(A1000.FreqRefSrc.MODBUS);
        this.a1000.enterParameters();
        this.a1000.stop();
        this.a1000.runForward();
        this.a1000.runForward();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read a register")
    public String readRegister(@Argument(description="Register to read") int number) throws DriverException {
        return String.format("%04x: %04x", number, this.a1000.readRegister((short)number));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read a set of registers")
    public String readRegisters(@Argument(description="First register to read") int number, @Argument(description="Number of registers to read") int count) {
        StringBuilder text = new StringBuilder();
        int lineSize = 8;
        int nRead = 0;
        try {
            while (nRead < count) {
                short[] reply = this.a1000.readRegisters((short)number, (short)Math.min(count - nRead, 16));
                int j = 0;
                while (j < reply.length) {
                    if (nRead % lineSize == 0) {
                        if (nRead != 0) {
                            text.append("\n");
                        }
                        text.append(String.format("%04x:", number));
                    }
                    text.append(String.format(" %04x", reply[j]));
                    ++j;
                    ++nRead;
                    ++number;
                }
            }
        }
        catch (DriverException e) {
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append("***** Got read error: ").append(e.getMessage());
        }
        return text.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show model name")
    public String showModelName() throws DriverException {
        return this.a1000.getModelName();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show node address")
    public int showNodeAddress() throws DriverException {
        return this.a1000.getNodeAddress();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show baud rate")
    public String showBaudRate() throws DriverException {
        return this.a1000.getBaudRate().toString().substring(1);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show parity")
    public A1000.Parity showParity() throws DriverException {
        return this.a1000.getParity();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show access level")
    public A1000.AccessLevel showAccessLevel() throws DriverException {
        return this.a1000.getAccessLevel();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show control mode")
    public A1000.ControlMode showControlMode() throws DriverException {
        return this.a1000.getControlMode();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show whether enter required")
    public boolean isEnterRequired() throws DriverException {
        return this.a1000.isEnterRequired();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show communications error action")
    public A1000.ErrorAction showErrorAction() throws DriverException {
        return this.a1000.getErrorAction();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show whether fault detected")
    public boolean isFaultDetected() throws DriverException {
        return this.a1000.isFaultDetected();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show frequency reference source")
    public A1000.FreqRefSrc showFreqRefSrc() throws DriverException {
        return this.a1000.getFreqRefSrc();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show input voltage")
    public double showInputVoltage() throws DriverException {
        return this.a1000.getInputVoltage();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show whether reverse permitted")
    public boolean isReversePermitted() throws DriverException {
        return this.a1000.isReversePermitted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show whether run command style is forward/reverse")
    public boolean isRunCmndFwdRev() throws DriverException {
        return this.a1000.isRunCmndFwdRev();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show run command source")
    public A1000.RunCmndSrc showRunCmndSrc() throws DriverException {
        return this.a1000.getRunCmndSrc();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show run/program interaction")
    public A1000.RunProg showRunProg() throws DriverException {
        return this.a1000.getRunProg();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the stop method")
    public A1000.StopMethod showStopMethod() throws DriverException {
        return this.a1000.getStopMethod();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show V/f profile selection")
    public A1000.VfSelection showVfSelection() throws DriverException {
        return this.a1000.getVfSelection();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show voltge units")
    public A1000.VoltageUnits showVoltageUnits() throws DriverException {
        return this.a1000.getVoltageUnits();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show maximum frequency percentage")
    public double showMaxFrequency() throws DriverException {
        return this.a1000.getMaxFrequency();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show minimum frequency percentage")
    public double showMinFrequency() throws DriverException {
        return this.a1000.getMinFrequency();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the reference frequency")
    public double showFrequency() throws DriverException {
        return this.a1000.getFrequency();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the applied reference frequency")
    public double showFrequencyApp() throws DriverException {
        return this.a1000.getFrequencyApp();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the frequency")
    public double readFrequency() throws DriverException {
        return this.a1000.readFrequency();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the current")
    public double readCurrent() throws DriverException {
        return this.a1000.readCurrent();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the voltage")
    public double readVoltage() throws DriverException {
        return this.a1000.readVoltage();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the temperature")
    public double readTemperature() throws DriverException {
        return this.a1000.readTemperature();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Read the bus voltage")
    public double readBusVoltage() throws DriverException {
        return this.a1000.readBusVoltage();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the drive status")
    public String showDriveStatus() throws DriverException {
        return String.format("0x%02x", this.a1000.getDriveStatus());
    }

    @Command(type=Command.CommandType.QUERY, description="Show the alarm code")
    public int showAlarmCode() throws DriverException {
        return this.a1000.getAlarmCode();
    }

    @Command(type=Command.CommandType.QUERY, description="Show the alarm codes")
    public Set<Integer> showAlarmCodes() throws DriverException {
        return this.a1000.getAlarmCodes();
    }

    @Command(type=Command.CommandType.QUERY, description="Show the alarm description")
    public String showAlarmDesc() throws DriverException {
        return this.a1000.getAlarmDesc();
    }

    @Command(type=Command.CommandType.QUERY, description="Show an alarm description")
    public String showAlarmDesc(@Argument(description="Alarm code") int code) throws DriverException {
        return A1000.getAlarmDesc((int)code);
    }

    @Command(type=Command.CommandType.QUERY, description="Show the current fault code")
    public int showCurrFaultCode() throws DriverException {
        return this.a1000.getCurrFaultCode();
    }

    @Command(type=Command.CommandType.QUERY, description="Show the previous fault code")
    public int showPrevFaultCode() throws DriverException {
        return this.a1000.getPrevFaultCode();
    }

    @Command(type=Command.CommandType.QUERY, description="Show the current fault description")
    public String showCurrFaultDesc() throws DriverException {
        return this.a1000.getCurrFaultDesc();
    }

    @Command(type=Command.CommandType.QUERY, description="Show the previous fault description")
    public String showPrevFaultDesc() throws DriverException {
        return this.a1000.getPrevFaultDesc();
    }

    @Command(type=Command.CommandType.QUERY, description="Show a fault description")
    public String showFaultDesc(@Argument(description="Fault code") int code) throws DriverException {
        return A1000.getFaultDesc((int)code);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the cumulative operation time")
    public int showOperationTime() throws DriverException {
        return this.a1000.getOperationTime();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show whether cumulative operation time is only time active")
    public boolean isOpTimeActive() throws DriverException {
        return this.a1000.isOpTimeActive();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the cumulative fan operation time")
    public int showFanOperationTime() throws DriverException {
        return this.a1000.getFanOperationTime();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the run command count")
    public int showRunCount() throws DriverException {
        return this.a1000.getRunCount();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the cumulative output kilowatt hours")
    public double showOutputKwh() throws DriverException {
        return this.a1000.getOutputKwh();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the fan lifetime fraction used")
    public double showFanLifetimeUsed() throws DriverException {
        return this.a1000.getFanLifetimeUsed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the capacitor lifetime fraction used")
    public double showCapLifetimeUsed() throws DriverException {
        return this.a1000.getCapLifetimeUsed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the soft charge bypass relay lifetime fraction used")
    public double showScbrLifetimeUsed() throws DriverException {
        return this.a1000.getScbrLifetimeUsed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Show the IGBT lifetime fraction used")
    public double showIgbtLifetimeUsed() throws DriverException {
        return this.a1000.getIgbtLifetimeUsed();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Flash the display LEDs")
    public void flashLeds() throws DriverException {
        this.a1000.flashLeds();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Write a set of registers")
    public void writeRegisters(@Argument(description="First register to write") int number, int ... values) throws DriverException {
        int count = values.length;
        if (count == 0) {
            throw new DriverException("No values supplied");
        }
        short[] sValues = new short[count];
        for (int j = 0; j < count; ++j) {
            sValues[j] = (short)values[j];
        }
        this.a1000.writeRegisters((short)number, sValues);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Enter parameters")
    public void enterParameters() throws DriverException {
        this.a1000.enterParameters();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Save parameters")
    public void saveParameters() throws DriverException {
        this.a1000.saveParameters();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set node address")
    public void setNodeAddress(@Argument(description="Node address") int address) throws DriverException {
        this.a1000.setNodeAddress(address);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set baud rate")
    public void setBaudRate(@Argument(description="Baud rate enum") A1000.BaudRate baudRate) throws DriverException {
        this.a1000.setBaudRate(baudRate);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set parity")
    public void setParity(@Argument(description="Parity enum") A1000.Parity parity) throws DriverException {
        this.a1000.setParity(parity);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set access level")
    public void setAccessLevel(@Argument(description="Access level enum") A1000.AccessLevel level) throws DriverException {
        this.a1000.setAccessLevel(level);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set control mode")
    public void setControlMode(@Argument(description="Control mode enum") A1000.ControlMode mode) throws DriverException {
        this.a1000.setControlMode(mode);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set whether enter required")
    public void setEnterRequired(@Argument(description="Whether enter required") boolean required) throws DriverException {
        this.a1000.setEnterRequired(required);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set communications error action")
    public void setErrorAction(@Argument(description="Error action enum") A1000.ErrorAction action) throws DriverException {
        this.a1000.setErrorAction(action);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set whether fault detected")
    public void setFaultDetected(@Argument(description="Whether fault detected") boolean detect) throws DriverException {
        this.a1000.setFaultDetected(detect);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set frequency reference source")
    public void setFreqRefSrc(@Argument(description="Freq refc source enum") A1000.FreqRefSrc source) throws DriverException {
        this.a1000.setFreqRefSrc(source);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set the input voltage")
    public void setInputVoltage(@Argument(description="The voltage") double voltage) throws DriverException {
        this.a1000.setInputVoltage(voltage);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set whether reverse permitted")
    public void setReversePermitted(@Argument(description="Whether reverse permitted") boolean permit) throws DriverException {
        this.a1000.setReversePermitted(permit);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set whether run command style is forward/reverse")
    public void setRunCmndFwdRev(@Argument(description="Whether forward/reverse") boolean fwdRev) throws DriverException {
        this.a1000.setRunCmndFwdRev(fwdRev);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set run command source")
    public void setRunCmndSrc(@Argument(description="Run cmnd source enum") A1000.RunCmndSrc source) throws DriverException {
        this.a1000.setRunCmndSrc(source);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set run/program interaction")
    public void setRunProg(@Argument(description="Run/program enum") A1000.RunProg runProg) throws DriverException {
        this.a1000.setRunProg(runProg);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set the stop method")
    public void setStopMethod(@Argument(description="Stop method enum") A1000.StopMethod method) throws DriverException {
        this.a1000.setStopMethod(method);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set V/f profile selection")
    public void setVfSelection(@Argument(description="V/f selection enum") A1000.VfSelection select) throws DriverException {
        this.a1000.setVfSelection(select);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set voltage units")
    public void setVoltageUnits(@Argument(description="Voltage units enum") A1000.VoltageUnits units) throws DriverException {
        this.a1000.setVoltageUnits(units);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set maximum frequency percentage")
    public void setMaxFrequency(@Argument(description="The frequency percentage") double freqPct) throws DriverException {
        this.a1000.setMaxFrequency(freqPct);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set minimum frequency percentage")
    public void setMinFrequency(@Argument(description="The frequency percentage") double freqPct) throws DriverException {
        this.a1000.setMinFrequency(freqPct);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Run the motor forwards")
    public void runForward() throws DriverException {
        this.a1000.runForward();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Run the motor in reverse")
    public void runReverse() throws DriverException {
        this.a1000.runReverse();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Stop the motor")
    public void stop() throws DriverException {
        this.a1000.stop();
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set the cumulative operation time")
    public void setOperationTime(@Argument(description="The time (10 hrs)") int time) throws DriverException {
        this.a1000.setOperationTime(time);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set whether cumulative operation time is only time active")
    public void setOpTimeActive(@Argument(description="Whether to use time active") boolean isActvTime) throws DriverException {
        this.a1000.setOpTimeActive(isActvTime);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set the cumulative fan operation time")
    public void setFanOperationTime(@Argument(description="The time") int time) throws DriverException {
        this.a1000.setFanOperationTime(time);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set the capacitor lifetime fraction used")
    public void setCapLifetimeUsed(@Argument(description="The fraction used") double fract) throws DriverException {
        this.a1000.setCapLifetimeUsed(fract);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set the soft charge bypass relay lifetime fraction used")
    public void setScbrLifetimeUsed(@Argument(description="The fraction used") double fract) throws DriverException {
        this.a1000.setScbrLifetimeUsed(fract);
    }

    @Command(type=Command.CommandType.ACTION, level=50, description="Set the IGBT lifetime fraction used")
    public void setIgbtLifetimeUsed(@Argument(description="The fraction used") double fract) throws DriverException {
        this.a1000.setIgbtLifetimeUsed(fract);
    }
}

