/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.power.PowerControl;
import org.lsst.ccs.subsystem.power.PowerGroup;
import org.lsst.ccs.subsystem.power.data.ATSPowerState;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class ATSPowerMain
extends Subsystem
implements HasLifecycle {
    private static final String DIGITAL_CHAN = "Digital";
    private static final String ANALOG_CHAN = "Analog";
    private static final String CLK_HIGH_CHAN = "ClockHigh";
    private static final String CLK_LOW_CHAN = "ClockLow";
    private static final String OD_CHAN = "OD";
    private static final String HV_BIAS_CHAN = "HVBias";
    private static final String DPHI_CHAN = "DPHI";
    private static final String OTM_CHAN = "OTM";
    private static final String FAN_CHAN = "Fan";
    private static final String AUX_CHAN = "Aux";
    private static final String[] pwrChannels = new String[10];
    private static final int POWER_TIMEOUT = 2000;
    private static final int UPDATE_TIME = 3000;
    private static final int[] rebChannels;
    private static final Logger LOG;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, PowerControl> specPwrControls = new LinkedHashMap<String, PowerControl>();
    private PowerControl dphiControl;
    private PowerControl hvBiasControl;
    private PowerControl otmControl;
    private PowerControl fanControl;
    private PowerControl auxControl;
    private final Boolean[] powerOn = new Boolean[10];
    private final PowerGroup rebGroup = new PowerGroup(new PowerControl[0]);
    private final PowerGroup dphiGroup = new PowerGroup(new PowerControl[0]);
    private final PowerGroup hvBiasGroup = new PowerGroup(new PowerControl[0]);
    private final PowerGroup otmGroup = new PowerGroup(new PowerControl[0]);
    private final PowerGroup fanGroup = new PowerGroup(new PowerControl[0]);
    private final PowerGroup auxGroup = new PowerGroup(new PowerControl[0]);
    private final Map<String, PowerControl> pwrControls = new LinkedHashMap<String, PowerControl>();
    private MonitorTaskControl monitorControl;

    public ATSPowerMain() {
        super("ats-power", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("power-state", () -> this.updatePowerState()).withPeriod(Duration.ofMillis(3000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.agentPropertiesService.setAgentProperty("atsPowerAgent", ((Object)((Object)this)).getClass().getCanonicalName());
        for (Map.Entry<String, PowerControl> entry : this.specPwrControls.entrySet()) {
            String[] fields = entry.getKey().split("/");
            this.pwrControls.put(fields[fields.length - 1], entry.getValue());
        }
        boolean error = false;
        for (String chan : pwrChannels) {
            if (this.pwrControls.get(chan) != null) continue;
            LOG.log(Level.SEVERE, "Required power channel {0} has not been defined", chan);
            error = true;
        }
        if (error) {
            throw new RuntimeException("Fatal initialization error");
        }
        this.dphiControl = this.pwrControls.get(DPHI_CHAN);
        this.hvBiasControl = this.pwrControls.get(HV_BIAS_CHAN);
        this.otmControl = this.pwrControls.get(OTM_CHAN);
        this.fanControl = this.pwrControls.get(FAN_CHAN);
        this.auxControl = this.pwrControls.get(AUX_CHAN);
        for (int chan : rebChannels) {
            this.rebGroup.addControl(this.pwrControls.get(pwrChannels[chan]));
        }
        this.dphiGroup.addControl(this.dphiControl);
        this.hvBiasGroup.addControl(this.hvBiasControl);
        this.otmGroup.addControl(this.otmControl);
        this.fanGroup.addControl(this.fanControl);
        this.auxGroup.addControl(this.auxControl);
    }

    public void postStart() {
        LOG.info("ATS power subsystem started");
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the power")
    public void powerOn() throws PowerException {
        try {
            if (!this.isPowerOn()) {
                this.rebGroup.powerOn();
                this.rebGroup.waitPowerOn(2000);
            }
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the power")
    public void powerOff() throws PowerException {
        PowerException excp = null;
        try {
            this.hvBiasGroup.powerOff();
        }
        catch (PowerException e) {
            excp = e;
        }
        try {
            this.dphiGroup.powerOff();
        }
        catch (PowerException e) {
            excp = excp == null ? e : excp;
        }
        try {
            this.rebGroup.powerOff();
            this.rebGroup.waitPowerOff(2000);
            if (excp != null) {
                throw excp;
            }
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the DPHI voltage")
    public void dphiOn() throws PowerException {
        if (!this.isPowerOn()) {
            return;
        }
        try {
            this.dphiGroup.powerOn();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the DPHI voltage")
    public void dphiOff() throws PowerException {
        try {
            this.dphiGroup.powerOff();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Query the DPHI voltage state", level=0)
    public boolean isDphiOn() {
        return this.powerOn[5] == Boolean.TRUE;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the DPHI voltage")
    public void setDphi(@Argument(description="Voltage value") double value) throws PowerException {
        this.dphiControl.setVoltage(value);
        try {
            if (this.powerOn[5] == Boolean.TRUE) {
                this.dphiControl.writeVoltage();
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the HV bias")
    public void hvBiasOn() throws PowerException {
        if (!this.isPowerOn()) {
            return;
        }
        try {
            this.hvBiasGroup.powerOn();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the HV bias")
    public void hvBiasOff() throws PowerException {
        try {
            this.hvBiasGroup.powerOff();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Query the HV bias voltage state", level=0)
    public boolean isHvBiasOn() {
        return this.powerOn[6] == Boolean.TRUE;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the HV bias voltage")
    public void setHvBias(@Argument(description="Voltage value") double value) throws PowerException {
        this.hvBiasControl.setVoltage(-Math.abs(value));
        try {
            if (this.powerOn[6] == Boolean.TRUE) {
                this.hvBiasControl.writeVoltage();
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the OTM")
    public void otmOn() throws PowerException {
        try {
            this.otmGroup.powerOn();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the OTM")
    public void otmOff() throws PowerException {
        try {
            this.otmGroup.powerOff();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the fan")
    public void fanOn() throws PowerException {
        try {
            this.fanGroup.powerOn();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the fan")
    public void fanOff() throws PowerException {
        try {
            this.fanGroup.powerOff();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the aux power")
    public void auxOn() throws PowerException {
        try {
            this.auxGroup.powerOn();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the aux power")
    public void auxOff() throws PowerException {
        try {
            this.auxGroup.powerOff();
        }
        finally {
            this.updatePowerState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state", level=0)
    public ATSPowerState getFullState() throws PowerException {
        return new ATSPowerState(this.monitorControl.getFastPeriod(), this.powerOn, this.dphiControl.getVoltage(), this.hvBiasControl.getVoltage());
    }

    private void publishState() {
        ATSPowerState ps = new ATSPowerState(this.monitorControl.getFastPeriod(), this.powerOn, this.dphiControl.getVoltage(), this.hvBiasControl.getVoltage());
        KeyValueData kvd = new KeyValueData("ATSPowerState", (Serializable)ps);
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }

    private synchronized void updatePowerState() {
        boolean changed = this.monitorControl.hasPeriodChanged();
        for (int chan = 0; chan < 10; ++chan) {
            Boolean state = this.pwrControls.get(pwrChannels[chan]).readOutput();
            if (state == this.powerOn[chan]) continue;
            this.powerOn[chan] = state;
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
    }

    private boolean isPowerOn() {
        boolean isOn = true;
        for (int chan : rebChannels) {
            if (this.powerOn[chan] == Boolean.TRUE) continue;
            isOn = false;
            break;
        }
        return isOn;
    }

    static {
        ATSPowerMain.pwrChannels[0] = DIGITAL_CHAN;
        ATSPowerMain.pwrChannels[1] = ANALOG_CHAN;
        ATSPowerMain.pwrChannels[2] = CLK_HIGH_CHAN;
        ATSPowerMain.pwrChannels[3] = CLK_LOW_CHAN;
        ATSPowerMain.pwrChannels[4] = OD_CHAN;
        ATSPowerMain.pwrChannels[5] = DPHI_CHAN;
        ATSPowerMain.pwrChannels[6] = HV_BIAS_CHAN;
        ATSPowerMain.pwrChannels[7] = OTM_CHAN;
        ATSPowerMain.pwrChannels[8] = FAN_CHAN;
        ATSPowerMain.pwrChannels[9] = AUX_CHAN;
        rebChannels = new int[]{0, 1, 4, 2, 3};
        LOG = Logger.getLogger(ATSPowerMain.class.getName());
    }
}

