/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class UtilTrunkValves {
    public static final String VALVE_UT = "UtValve";
    public static final String VALVE_VPC = "VpcValve";
    public static final String VALVE_MPC = "MpcValve";
    public static final int VALVE_UT_ID = 0;
    public static final int VALVE_VPC_ID = 1;
    public static final int VALVE_MPC_ID = 2;
    public static final int NUM_VALVES = 3;
    private static final Map<String, Integer> valveNameToId = new LinkedHashMap<String, Integer>();
    private static final Map<Integer, String> valveIdToName;
    private static final boolean[] hasTempState;

    public static List<String> getNames() {
        return new ArrayList<String>(valveNameToId.keySet());
    }

    public static String getName(int id) {
        return valveIdToName.get(id);
    }

    public static int getId(String name) throws UtilityException {
        Integer id = valveNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid valve name: " + name);
        }
        return id;
    }

    static {
        valveNameToId.put(VALVE_UT, 0);
        valveNameToId.put(VALVE_VPC, 1);
        valveNameToId.put(VALVE_MPC, 2);
        valveIdToName = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : valveNameToId.entrySet()) {
            valveIdToName.put(entry.getValue(), entry.getKey());
        }
        hasTempState = new boolean[3];
        UtilTrunkValves.hasTempState[0] = false;
        UtilTrunkValves.hasTempState[1] = false;
        UtilTrunkValves.hasTempState[2] = false;
    }
}

