/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.actions.RefrigAction;
import org.lsst.ccs.subsystem.common.data.MonitorTask;
import org.lsst.ccs.subsystem.refrig.StickyCondition;
import org.lsst.ccs.subsystem.refrig.constants.HexAlert;
import org.lsst.ccs.subsystem.refrig.data.HexState;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;
import org.lsst.ccs.subsystem.refrig.data.UpdatePeriod;

public class HexMain
extends Subsystem
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener {
    private static final int TEMP_REPEAT_COUNT = 3;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @ConfigurationParameter(isFinal=true)
    private volatile double rtnToEvapOffset = 0.3;
    @ConfigurationParameter(isFinal=true)
    private volatile double lowCryoTempLimit;
    private List<String> cryoTempChans;
    private static final Logger LOG = Logger.getLogger(HexMain.class.getName());
    private final HexState hexState = new HexState();
    private String refrigGroup;
    private MonitorTaskControl monitorControl;
    private Map<String, MonitorTask> monitorTaskMap;
    private final List<Channel> cryoTempChannels = new ArrayList<Channel>();
    private final List<StickyCondition> cryoConditions = new ArrayList<StickyCondition>();
    private final Map<String, Boolean> activeAlarms = new HashMap<String, Boolean>();

    public HexMain() {
        super("hex", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("hex-state", () -> this.publishUpdatedHexState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        pt = new AgentPeriodicTask("temp-check", () -> this.checkTemperatures()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void init() {
        for (String chanName : this.cryoTempChans) {
            this.alertService.registerAlert(HexAlert.EVAP_TEMP_LOW.newAlert(chanName.split("/")[0]));
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("hexType", HexMain.class.getCanonicalName());
        ((MessagingService)this.getAgentService(MessagingService.class)).getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.refrigGroup = RefrigUtils.getGroupName(this.subsys.getAgentInfo());
        this.monitorTaskMap = this.monitorControl.getMonitorTaskMap();
        for (String chanName : this.cryoTempChans) {
            Channel chan = this.allChannels.get(chanName);
            if (chan == null) {
                throw new RuntimeException("Channel " + chanName + " doesn't exist");
            }
            this.cryoTempChannels.add(chan);
            this.cryoConditions.add(new StickyCondition(3));
            this.activeAlarms.put(chanName, false);
        }
    }

    public void postStart() {
        LOG.info("Heat exchanger subsystem started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            if (!RefrigUtils.getGroupName(agent).equals(this.refrigGroup)) continue;
            ((MessagingService)this.getAgentService(MessagingService.class)).getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            break;
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType") || !RefrigUtils.getGroupName(agent).equals(this.refrigGroup)) continue;
            ((MessagingService)this.getAgentService(MessagingService.class)).getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        int tickMillis;
        StatusSubsystemData sd = (StatusSubsystemData)msg;
        if (sd.getDataKey().equals("UpdatePeriod") && (tickMillis = ((UpdatePeriod)sd.getSubsystemData().getValue()).getTickMillis()) != this.monitorControl.getFastPeriod()) {
            this.monitorControl.setFastPeriod(tickMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, description="Get the heat exchanger state", level=0)
    public HexState getSystemState() {
        HexState hexState = this.hexState;
        synchronized (hexState) {
            this.hexState.setTickMillis(this.monitorControl.getFastPeriod());
            this.hexState.clearMonitorTasks();
            for (MonitorTask task : this.monitorTaskMap.values()) {
                this.hexState.addMonitorTask(task);
            }
            return this.hexState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishUpdatedHexState() {
        HexState hexState = this.hexState;
        synchronized (hexState) {
            boolean changed = this.monitorControl.hasPeriodChanged();
            this.hexState.clearMonitorTasks();
            for (MonitorTask task : this.monitorTaskMap.values()) {
                if (!task.hasChanged()) continue;
                this.hexState.addMonitorTask(task);
                changed = true;
            }
            if (changed) {
                this.hexState.setTickMillis(this.monitorControl.getFastPeriod());
                this.publishSubsystemDataOnStatusBus(new KeyValueData("HexState", (Serializable)this.hexState));
            }
        }
    }

    private void checkTemperatures() {
        for (int j = 0; j < this.cryoTempChannels.size(); ++j) {
            Channel chan;
            double value;
            if (this.cryoConditions.get(j).update((value = (chan = this.cryoTempChannels.get(j)).getValue()) < this.lowCryoTempLimit)) {
                this.raiseTempAlarm(chan.getName(), value);
                continue;
            }
            this.lowerTempAlarm(chan.getName(), value);
        }
    }

    private void raiseTempAlarm(String chanName, double value) {
        if (!this.activeAlarms.get(chanName).booleanValue()) {
            this.activeAlarms.put(chanName, true);
            String compName = chanName.split("/")[0];
            Alert alert = HexAlert.EVAP_TEMP_LOW.newAlert(compName);
            RefrigAction.addData((Alert)alert, (RefrigAction.Action)RefrigAction.Action.CRYO_CIRCUIT_TOO_COLD, (String)compName);
            String sValue = String.format("%.1f", value);
            this.alertService.raiseAlert(alert, AlertState.ALARM, "Temperature is too low: value (" + sValue + ") < " + this.lowCryoTempLimit);
        }
    }

    private void lowerTempAlarm(String chanName, double value) {
        if (this.activeAlarms.get(chanName).booleanValue()) {
            this.activeAlarms.put(chanName, false);
            String compName = chanName.split("/")[0];
            Alert alert = HexAlert.EVAP_TEMP_LOW.newAlert(compName);
            RefrigAction.addData((Alert)alert, (RefrigAction.Action)RefrigAction.Action.CRYO_CIRCUIT_TOO_COLD, (String)compName);
            String sValue = String.format("%.1f", value);
            this.alertService.raiseAlert(alert, AlertState.NOMINAL, "Temperature is normal: value = " + sValue);
        }
    }

    double getRtnToEvapOffset() {
        return this.rtnToEvapOffset;
    }
}

