/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.gpio;

import java.util.List;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.gpio.GPIODriver;

public class TestGPIODriver {
    private final GPIODriver gpio = new GPIODriver();

    @Command(name="enumerateChips", description="Enumerate available chips")
    public List<GPIODriver.GPIOChip> enumerateChips() throws DriverException {
        return this.gpio.enumerateChips();
    }

    @Command(name="enumerateChannels", description="Enumerate available chips")
    public List<GPIODriver.GPIOChannel> enumerateChannels() throws DriverException {
        return this.gpio.enumerateExportedChannels();
    }

    @Command(name="export", description="Export a single channel")
    public GPIODriver.GPIOChannel export(@Argument(name="channel") int channel) throws DriverException {
        return this.gpio.export(channel);
    }

    @Command(name="unexport", description="Export a single channel")
    public void unexport(@Argument(name="channel") int channel) throws DriverException {
        this.gpio.unexport(channel);
    }

    @Command(name="setChannel", description="Set a single channel")
    public void set(@Argument(name="channel") int channel) throws DriverException {
        this.gpio.getChannel(channel).set();
    }

    @Command(name="clearChannel", description="Clear a single channel")
    public void clear(@Argument(name="channel") int channel) throws DriverException {
        this.gpio.getChannel(channel).clear();
    }

    @Command(name="readChannel", description="Read a single channel")
    public boolean read(@Argument(name="channel") int channel) throws DriverException {
        return this.gpio.getChannel(channel).read();
    }

    @Command(name="readAll", description="Read all exported channels channel")
    public void readAll() throws DriverException {
        for (GPIODriver.GPIOChannel channel : this.enumerateChannels()) {
            System.out.printf("Channel %d direction=%s value %s\n", new Object[]{channel.getChannel(), channel.getDirection(), channel.read()});
        }
    }

    @Command(name="lock", description="Lock a single channel")
    public void lock(@Argument(name="channel") int channel) throws DriverException {
        this.gpio.getChannel(channel).lock();
    }

    @Command(name="unlock", description="Unlock a single channel")
    public void unlock(@Argument(name="channel") int channel) throws DriverException {
        this.gpio.getChannel(channel).unlock();
    }

    @Command(name="getDirection", description="Clear a single channel")
    public GPIODriver.GPIOChannel.Direction getDirection(@Argument(name="channel") int channel) throws DriverException {
        return this.gpio.getChannel(channel).getDirection();
    }

    @Command(name="setDirection", description="Clear a single channel")
    public void setDirection(@Argument(name="channel") int channel, @Argument(name="direction") GPIODriver.GPIOChannel.Direction dir) throws DriverException {
        this.gpio.getChannel(channel).setDirection(dir);
    }

    @Command(name="exportRange", description="Export all channels in specified range")
    public void exportRange(@Argument(name="start") int start, @Argument(name="n") int n) throws DriverException {
        this.gpio.exportRange(start, n);
    }

    @Command(name="unexportRange", description="Export all channels in specified range")
    public void unexportRange(@Argument(name="start") int start, @Argument(name="n") int n) throws DriverException {
        this.gpio.unexportRange(start, n);
    }

    @Command(name="pollTest", description="Repeatedly read a channel")
    public void pollTest(@Argument(name="channel") int channel, @Argument(name="n", defaultValue="1000") int n) throws DriverException {
        GPIODriver.GPIOChannel gpioChannel = this.gpio.getChannel(channel);
        long start = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            gpioChannel.read();
        }
        long stop = System.currentTimeMillis();
        System.out.printf("Polled channel %d %d times, took=%dms\n", channel, n, stop - start);
        start = System.currentTimeMillis();
        gpioChannel.lock();
        for (int i = 0; i < n; ++i) {
            gpioChannel.read();
        }
        gpioChannel.unlock();
        stop = System.currentTimeMillis();
        System.out.printf("Polled channel %d %d times, took=%dms\n", channel, n, stop - start);
    }
}

