/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

public class ConfiguredAverageChannel
extends DerivedChannel {
    @LookupField(strategy=LookupField.Strategy.TREE)
    Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(ConfiguredAverageChannel.class.getName());
    private final List<Channel> channels = new CopyOnWriteArrayList<Channel>();
    private final List<Double> channelsW = new CopyOnWriteArrayList<Double>();
    private volatile String channelSelection;
    private final List<Channel> tmpChannels = new CopyOnWriteArrayList<Channel>();
    private final List<Double> tmpChannelsW = new CopyOnWriteArrayList<Double>();
    private volatile String tmpChannelSelection;
    private volatile double sumWeights;
    @ConfigurationParameter(name="chanNames", category="General", description="Path regular expression to select the Channels to be averaged", maxLength=-1, units="unitless")
    protected volatile List<String> chanNames = new ArrayList<String>();
    @ConfigurationParameter(name="chanWeights", category="General", description="Weights of Channels to be averaged", maxLength=-1, units="unitless")
    protected volatile List<Double> chanWeights = new ArrayList<Double>();
    @ConfigurationParameter(name="ignoreNaN", category="General", isFinal=true, units="unitless", description="if true ignore (omit) NaN channels")
    protected volatile boolean ignoreNaN;

    public void validateBulkChange(Map<String, Object> params) {
        super.validateBulkChange(params);
        List channelList = (List)params.get("chanNames");
        List weightList = (List)params.get("chanWeights");
        int len = channelList.size();
        if (weightList.size() != len) {
            throw new RuntimeException(this.name + ": chanWeights and chanNames do not have same size");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Updated Channel/Weight lists for ConfiguredAverageChannel ").append(this.name).append("\n");
        this.tmpChannels.clear();
        this.tmpChannelsW.clear();
        for (int i = 0; i < len; ++i) {
            try {
                Double chanWeight = (Double)weightList.get(i);
                if (!(chanWeight >= 0.0)) {
                    throw new RuntimeException(this.name + "/chanWeights element " + i + " is not positive-definite");
                }
                String chanName = (String)channelList.get(i);
                Pattern p = Pattern.compile(chanName);
                sb.append("Regular expression ").append(chanName).append(" selected Channels with weight ").append(chanWeight).append(":\n");
                int channelCount = 0;
                boolean noMatch = true;
                for (Map.Entry<String, Channel> e : this.channelMap.entrySet()) {
                    if (!p.matcher(e.getKey()).matches()) continue;
                    noMatch = false;
                    Channel ch = e.getValue();
                    if (this.tmpChannels.contains(ch)) {
                        throw new RuntimeException("Channel " + e.getKey() + " has already been selected by another entry in \"channelNames\" " + chanName);
                    }
                    this.tmpChannels.add(ch);
                    this.tmpChannelsW.add(chanWeight);
                    sb.append("-").append(channelCount++).append("- ").append(e.getKey()).append("\n");
                }
                if (!noMatch) continue;
                throw new RuntimeException(this.name + "/chanNames element " + (String)channelList.get(i) + " didn't match any available channels.");
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException(this.name + "/chanNames element " + (String)channelList.get(i) + " is not a valid regular expression.");
            }
        }
        this.tmpChannelSelection = sb.toString();
    }

    public void setParameterBulk(Map<String, Object> params) {
        super.setParameterBulk(params);
        boolean updatesRequired = false;
        Set<String> keys = params.keySet();
        if (keys.contains("chanWeights")) {
            this.chanWeights.clear();
            this.chanWeights.addAll((List)params.get("chanWeights"));
            updatesRequired = true;
        }
        if (keys.contains("chanNames")) {
            this.chanNames.clear();
            this.chanNames.addAll((List)params.get("chanNames"));
            updatesRequired = true;
        }
        if (updatesRequired) {
            this.channels.clear();
            this.channels.addAll(this.tmpChannels);
            this.channelsW.clear();
            this.channelsW.addAll(this.tmpChannelsW);
            LOG.log(Level.INFO, this.tmpChannelSelection);
            this.sumWeights = 0.0;
            for (Double w : this.channelsW) {
                this.sumWeights += w.doubleValue();
            }
        }
    }

    public double evaluateDerivedValue() {
        double sum = 0.0;
        double sumW = this.sumWeights;
        for (int i = 0; i < this.channels.size(); ++i) {
            double val = this.channels.get(i).getValue();
            if (val != Double.NaN || !this.ignoreNaN) {
                sum += this.channelsW.get(i) * val;
                continue;
            }
            sumW -= this.channelsW.get(i).doubleValue();
        }
        return sumW > 0.0 ? sum / sumW : Double.NaN;
    }

    List<Channel> getChannels() {
        return this.channels;
    }

    List<Double> getWeights() {
        return this.channelsW;
    }

    double getSumOfWeights() {
        return this.sumWeights;
    }
}

