/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.test.AidaTestCase;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;

public class TestHistogram
extends AidaTestCase {
    private int nEntries = 1234;
    private int xbins = 40;
    private int ybins = 20;
    private int zbins = 10;
    private double xLowerEdge = -2.3;
    private double xUpperEdge = 4.2;
    private double yLowerEdge = -6.1;
    private double yUpperEdge = 1.2;
    private double zLowerEdge = -0.6;
    private double zUpperEdge = 7.5;
    private String hist1DTitle = "Aida 1D Histogram";
    private String hist2DTitle = "Aida 2D Histogram";
    private String hist3DTitle = "Aida 3D Histogram";

    public TestHistogram(String testName) {
        super(testName);
    }

    public void testHistogramCreation() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree1 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory1 = af.createHistogramFactory(tree1);
        this.createHistograms(histogramFactory1, tree1);
        ITree tree2 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory2 = af.createHistogramFactory(tree2);
        this.createHistograms(histogramFactory2, tree2);
        tree1.cd("/hist");
        IHistogram1D h1 = (IHistogram1D)tree1.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)tree1.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)tree1.find(this.hist3DTitle);
        Assert.assertEquals((String)this.hist1DTitle, (String)h1.title());
        Assert.assertEquals((String)this.hist2DTitle, (String)h2.title());
        Assert.assertEquals((String)this.hist3DTitle, (String)h3.title());
        Assert.assertEquals((int)this.xbins, (int)h1.axis().bins());
        Assert.assertEquals((int)this.xbins, (int)h2.xAxis().bins());
        Assert.assertEquals((int)this.xbins, (int)h3.xAxis().bins());
        Assert.assertEquals((int)this.ybins, (int)h2.yAxis().bins());
        Assert.assertEquals((int)this.ybins, (int)h3.yAxis().bins());
        Assert.assertEquals((int)this.zbins, (int)h3.zAxis().bins());
        AidaTestCase.assertEqualsDouble(this.xLowerEdge, h1.axis().lowerEdge(), h1.axis().lowerEdge());
        AidaTestCase.assertEqualsDouble(this.xUpperEdge, h1.axis().upperEdge(), h1.axis().upperEdge());
        AidaTestCase.assertEqualsDouble(this.xLowerEdge, h2.xAxis().lowerEdge(), h2.xAxis().lowerEdge());
        AidaTestCase.assertEqualsDouble(this.xUpperEdge, h2.xAxis().upperEdge(), h2.xAxis().upperEdge());
        AidaTestCase.assertEqualsDouble(this.xLowerEdge, h3.xAxis().lowerEdge(), h3.xAxis().lowerEdge());
        AidaTestCase.assertEqualsDouble(this.xUpperEdge, h3.xAxis().upperEdge(), h3.xAxis().upperEdge());
        AidaTestCase.assertEqualsDouble(this.yLowerEdge, h2.yAxis().lowerEdge(), h2.yAxis().lowerEdge());
        AidaTestCase.assertEqualsDouble(this.yUpperEdge, h2.yAxis().upperEdge(), h2.yAxis().upperEdge());
        AidaTestCase.assertEqualsDouble(this.yLowerEdge, h3.yAxis().lowerEdge(), h3.yAxis().lowerEdge());
        AidaTestCase.assertEqualsDouble(this.yUpperEdge, h3.yAxis().upperEdge(), h3.yAxis().upperEdge());
        AidaTestCase.assertEqualsDouble(this.zLowerEdge, h3.zAxis().lowerEdge(), h3.zAxis().lowerEdge());
        AidaTestCase.assertEqualsDouble(this.zUpperEdge, h3.zAxis().upperEdge(), h3.zAxis().upperEdge());
        tree2.cd("/hist");
        IHistogram1D h1Var = (IHistogram1D)tree2.find(this.hist1DTitle);
        IHistogram2D h2Var = (IHistogram2D)tree2.find(this.hist2DTitle);
        IHistogram3D h3Var = (IHistogram3D)tree2.find(this.hist3DTitle);
        AidaTestCase.assertEquals(h1, h1Var);
        AidaTestCase.assertEquals(h2, h2Var);
        AidaTestCase.assertEquals(h3, h3Var);
    }

    public void testHistogramFill() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree1 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory1 = af.createHistogramFactory(tree1);
        this.createHistograms(histogramFactory1, tree1);
        ITree tree2 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory2 = af.createHistogramFactory(tree2);
        this.createHistograms(histogramFactory2, tree2);
        this.fillHistograms(tree1, tree2);
        tree1.cd("/hist");
        IHistogram1D h1 = (IHistogram1D)tree1.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)tree1.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)tree1.find(this.hist3DTitle);
        tree2.cd("/hist");
        IHistogram1D h1Var = (IHistogram1D)tree2.find(this.hist1DTitle);
        IHistogram2D h2Var = (IHistogram2D)tree2.find(this.hist2DTitle);
        IHistogram3D h3Var = (IHistogram3D)tree2.find(this.hist3DTitle);
        AidaTestCase.assertEquals(h1, h1Var);
        AidaTestCase.assertEquals(h2, h2Var);
        AidaTestCase.assertEquals(h3, h3Var);
    }

    public void testHistogramStatistics() {
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(tree);
        this.createHistograms(histogramFactory, tree);
        tree.cd("/hist");
        IHistogram1D h1 = (IHistogram1D)tree.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)tree.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)tree.find(this.hist3DTitle);
        double[] error1d = new double[this.xbins + 2];
        double[][] error2d = new double[this.xbins + 2][this.ybins + 2];
        double[][][] error3d = new double[this.xbins + 2][this.ybins + 2][this.zbins + 2];
        double xmean1 = 0.0;
        double xrms1 = 0.0;
        double sumOfWeight1 = 0.0;
        double sumOfWeightSquared1 = 0.0;
        double xmean2 = 0.0;
        double xrms2 = 0.0;
        double ymean2 = 0.0;
        double yrms2 = 0.0;
        double sumOfWeight2 = 0.0;
        double sumOfWeightSquared2 = 0.0;
        double xmean3 = 0.0;
        double xrms3 = 0.0;
        double ymean3 = 0.0;
        double yrms3 = 0.0;
        double zmean3 = 0.0;
        double zrms3 = 0.0;
        double sumOfWeight3 = 0.0;
        double sumOfWeightSquared3 = 0.0;
        int entries = 0;
        for (int i = 0; i < 10 * this.nEntries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            int xbin = h1.coordToIndex(xval) + 2;
            int ybin = h2.coordToIndexY(yval) + 2;
            int zbin = h3.coordToIndexZ(zval) + 2;
            if (xbin > 1) {
                xmean1 += xval * w;
                xrms1 += xval * xval * w;
                sumOfWeight1 += w;
                sumOfWeightSquared1 += w * w;
                if (ybin > 1) {
                    xmean2 += xval * w;
                    xrms2 += xval * xval * w;
                    ymean2 += yval * w;
                    yrms2 += yval * yval * w;
                    sumOfWeight2 += w;
                    sumOfWeightSquared2 += w * w;
                    if (zbin > 1) {
                        xmean3 += xval * w;
                        xrms3 += xval * xval * w;
                        ymean3 += yval * w;
                        yrms3 += yval * yval * w;
                        zmean3 += zval * w;
                        zrms3 += zval * zval * w;
                        sumOfWeight3 += w;
                        sumOfWeightSquared3 += w * w;
                    }
                }
            }
            ++entries;
            int n = xbin;
            error1d[n] = error1d[n] + w * w;
            double[] dArray = error2d[xbin];
            int n2 = ybin;
            dArray[n2] = dArray[n2] + w * w;
            double[] dArray2 = error3d[xbin][ybin];
            int n3 = zbin;
            dArray2[n3] = dArray2[n3] + w * w;
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
        }
        double meanX1 = xmean1 / sumOfWeight1;
        double rmsX1 = Math.sqrt(xrms1 / sumOfWeight1 - xmean1 * xmean1 / sumOfWeight1 / sumOfWeight1);
        double equivEnt1 = sumOfWeight1 * sumOfWeight1 / sumOfWeightSquared1;
        double meanX2 = xmean2 / sumOfWeight2;
        double rmsX2 = Math.sqrt(xrms2 / sumOfWeight2 - xmean2 * xmean2 / sumOfWeight2 / sumOfWeight2);
        double meanY2 = ymean2 / sumOfWeight2;
        double rmsY2 = Math.sqrt(yrms2 / sumOfWeight2 - ymean2 * ymean2 / sumOfWeight2 / sumOfWeight2);
        double equivEnt2 = sumOfWeight2 * sumOfWeight2 / sumOfWeightSquared2;
        double meanX3 = xmean3 / sumOfWeight3;
        double rmsX3 = Math.sqrt(xrms3 / sumOfWeight3 - xmean3 * xmean3 / sumOfWeight3 / sumOfWeight3);
        double meanY3 = ymean3 / sumOfWeight3;
        double rmsY3 = Math.sqrt(yrms3 / sumOfWeight3 - ymean3 * ymean3 / sumOfWeight3 / sumOfWeight3);
        double meanZ3 = zmean3 / sumOfWeight3;
        double rmsZ3 = Math.sqrt(zrms3 / sumOfWeight3 - zmean3 * zmean3 / sumOfWeight3 / sumOfWeight3);
        double equivEnt3 = sumOfWeight3 * sumOfWeight3 / sumOfWeightSquared3;
        AidaTestCase.assertEqualsDouble(h1.mean(), meanX1, h1.rms(), h1.entries());
        AidaTestCase.assertEqualsDouble(h2.meanX(), meanX2, h2.rmsX(), h2.entries());
        AidaTestCase.assertEqualsDouble(h3.meanX(), meanX3, h3.rmsX(), h3.entries());
        AidaTestCase.assertEqualsDouble(h2.meanY(), meanY2, h2.rmsY(), h2.entries());
        AidaTestCase.assertEqualsDouble(h3.meanY(), meanY3, h3.rmsY(), h3.entries());
        AidaTestCase.assertEqualsDouble(h3.meanZ(), meanZ3, h3.rmsZ(), h3.entries());
        AidaTestCase.assertEqualsDouble(h1.rms(), rmsX1, h1.rms(), h1.entries());
        AidaTestCase.assertEqualsDouble(h2.rmsX(), rmsX2, h2.rmsX(), h2.entries());
        AidaTestCase.assertEqualsDouble(h3.rmsX(), rmsX3, h3.rmsX(), h3.entries());
        AidaTestCase.assertEqualsDouble(h2.rmsY(), rmsY2, h2.rmsY(), h2.entries());
        AidaTestCase.assertEqualsDouble(h3.rmsY(), rmsY3, h3.rmsY(), h3.entries());
        AidaTestCase.assertEqualsDouble(h3.rmsZ(), rmsZ3, h3.rmsZ(), h3.entries());
        for (int i = -2; i < this.xbins; ++i) {
            AidaTestCase.assertEqualsDouble(h1.binError(i), Math.sqrt(error1d[i + 2]), h1.binHeight(i));
            for (int j = -2; j < this.ybins; ++j) {
                AidaTestCase.assertEqualsDouble(h2.binError(i, j), Math.sqrt(error2d[i + 2][j + 2]), h2.binHeight(i, j));
                for (int k = -2; k < this.zbins; ++k) {
                    AidaTestCase.assertEqualsDouble(h3.binError(i, j, k), Math.sqrt(error3d[i + 2][j + 2][k + 2]), h3.binHeight(i, j, k));
                }
            }
        }
        Assert.assertEquals((int)h1.allEntries(), (int)entries);
        Assert.assertEquals((int)h2.allEntries(), (int)entries);
        Assert.assertEquals((int)h3.allEntries(), (int)entries);
        AidaTestCase.assertEqualsDouble(h1.equivalentBinEntries(), equivEnt1, 1.0, h1.entries());
        AidaTestCase.assertEqualsDouble(h2.equivalentBinEntries(), equivEnt2, 1.0, h2.entries());
        AidaTestCase.assertEqualsDouble(h3.equivalentBinEntries(), equivEnt3, 1.0, h3.entries());
    }

    public void testHistogramScale() {
        double w;
        double zval;
        double yval;
        double xval;
        int i;
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree1 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory1 = af.createHistogramFactory(tree1);
        ITree tree2 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory2 = af.createHistogramFactory(tree2);
        tree1.mkdir("/hist");
        tree1.cd("/hist");
        IHistogram1D h1 = histogramFactory1.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory1.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory1.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        tree2.mkdir("/hist");
        tree2.cd("/hist");
        IHistogram1D h1S = histogramFactory2.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2S = histogramFactory2.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3S = histogramFactory2.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        double scale1D = 0.002;
        double scale2D = 4.2;
        double scale3D = 1123.0;
        for (i = 0; i < 343; ++i) {
            xval = r.nextGaussian();
            yval = r.nextGaussian();
            zval = r.nextGaussian();
            w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1S.fill(xval, scale1D * w);
            h2S.fill(xval, yval, scale2D * w);
            h3S.fill(xval, yval, zval, scale3D * w);
        }
        h1.scale(scale1D);
        h2.scale(scale2D);
        h3.scale(scale3D);
        AidaTestCase.assertEquals(h1, h1S);
        AidaTestCase.assertEquals(h2, h2S);
        AidaTestCase.assertEquals(h3, h3S);
        for (i = 0; i < 32; ++i) {
            xval = r.nextGaussian();
            yval = r.nextGaussian();
            zval = r.nextGaussian();
            w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1S.fill(xval, w);
            h2S.fill(xval, yval, w);
            h3S.fill(xval, yval, zval, w);
        }
        AidaTestCase.assertEquals(h1, h1S);
        AidaTestCase.assertEquals(h2, h2S);
        AidaTestCase.assertEquals(h3, h3S);
    }

    public void testHistogramAdd() {
        double w;
        double zval;
        double yval;
        double xval;
        int i;
        Random r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree1 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory1 = af.createHistogramFactory(tree1);
        ITree tree2 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory2 = af.createHistogramFactory(tree2);
        ITree tree3 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory3 = af.createHistogramFactory(tree3);
        tree1.mkdir("/hist");
        tree1.cd("/hist");
        IHistogram1D h1 = histogramFactory1.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory1.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory1.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        tree2.mkdir("/hist");
        tree2.cd("/hist");
        IHistogram1D h1A = histogramFactory2.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2A = histogramFactory2.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3A = histogramFactory2.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        tree3.mkdir("/hist");
        tree3.cd("/hist");
        IHistogram1D h1B = histogramFactory3.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2B = histogramFactory3.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3B = histogramFactory3.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        for (i = 0; i < 343; ++i) {
            xval = r.nextGaussian();
            yval = r.nextGaussian();
            zval = r.nextGaussian();
            w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1A.fill(xval, w);
            h2A.fill(xval, yval, w);
            h3A.fill(xval, yval, zval, w);
        }
        for (i = 0; i < 894; ++i) {
            xval = r.nextGaussian();
            yval = r.nextGaussian();
            zval = r.nextGaussian();
            w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1B.fill(xval, w);
            h2B.fill(xval, yval, w);
            h3B.fill(xval, yval, zval, w);
        }
        h1A.add(h1B);
        h2A.add(h2B);
        h3A.add(h3B);
        AidaTestCase.assertEquals(h1, h1A);
        AidaTestCase.assertEquals(h2, h2A);
        AidaTestCase.assertEquals(h3, h3A);
        for (i = 0; i < 32; ++i) {
            xval = r.nextGaussian();
            yval = r.nextGaussian();
            zval = r.nextGaussian();
            w = r.nextDouble();
            h1.fill(xval, w);
            h2.fill(xval, yval, w);
            h3.fill(xval, yval, zval, w);
            h1A.fill(xval, w);
            h2A.fill(xval, yval, w);
            h3A.fill(xval, yval, zval, w);
        }
        AidaTestCase.assertEquals(h1, h1A);
        AidaTestCase.assertEquals(h2, h2A);
        AidaTestCase.assertEquals(h3, h3A);
    }

    public void testHistogramCopy() throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree1 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory1 = af.createHistogramFactory(tree1);
        this.createHistograms(histogramFactory1, tree1);
        ITree tree2 = af.createTreeFactory().create();
        IHistogramFactory histogramFactory2 = af.createHistogramFactory(tree2);
        this.createHistograms(histogramFactory2, tree2);
        this.fillHistograms(tree1, tree2);
        tree1.cd("/hist");
        IHistogram1D h1 = (IHistogram1D)tree1.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)tree1.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)tree1.find(this.hist3DTitle);
        tree2.cd("/hist");
        IHistogram1D h1Var = (IHistogram1D)tree2.find(this.hist1DTitle);
        IHistogram2D h2Var = (IHistogram2D)tree2.find(this.hist2DTitle);
        IHistogram3D h3Var = (IHistogram3D)tree2.find(this.hist3DTitle);
        ITree newTree = af.createTreeFactory().create();
        IHistogramFactory newHistogramFactory = af.createHistogramFactory(newTree);
        newTree.mkdir("hist");
        newTree.cd("/hist");
        IHistogram1D h1New = newHistogramFactory.createCopy(this.hist1DTitle, h1);
        IHistogram2D h2New = newHistogramFactory.createCopy(this.hist2DTitle, h2);
        IHistogram3D h3New = newHistogramFactory.createCopy(this.hist3DTitle, h3);
        IHistogram1D h1VarNew = newHistogramFactory.createCopy(this.hist1DTitle, h1Var);
        IHistogram2D h2VarNew = newHistogramFactory.createCopy(this.hist2DTitle, h2Var);
        IHistogram3D h3VarNew = newHistogramFactory.createCopy(this.hist3DTitle, h3Var);
        AidaTestCase.assertEquals(h1, h1New);
        AidaTestCase.assertEquals(h2, h2New);
        AidaTestCase.assertEquals(h3, h3New);
        AidaTestCase.assertEquals(h1Var, h1VarNew);
        AidaTestCase.assertEquals(h2Var, h2VarNew);
        AidaTestCase.assertEquals(h3Var, h3VarNew);
    }

    public void testHistogramFillNaN() {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory histogramFactory = af.createHistogramFactory(tree);
        this.createHistograms(histogramFactory, tree);
        this.fillHistograms(tree);
        tree.cd("/hist");
        IHistogram1D h1 = (IHistogram1D)tree.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)tree.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)tree.find(this.hist3DTitle);
        double mean = h1.mean();
        double rms = h1.rms();
        int entries = h1.entries();
        double meanX2 = h2.meanX();
        double meanY2 = h2.meanY();
        double rmsX2 = h2.rmsX();
        double rmsY2 = h2.rmsY();
        int entries2 = h2.entries();
        double meanX3 = h3.meanX();
        double meanY3 = h3.meanY();
        double meanZ3 = h3.meanZ();
        double rmsX3 = h3.rmsX();
        double rmsY3 = h3.rmsY();
        double rmsZ3 = h3.rmsZ();
        int entries3 = h3.entries();
        h1.fill(Double.NaN);
        h2.fill(1.0, Double.NaN);
        h3.fill(Double.NaN, 0.0, 3.0, 0.5);
        Assert.assertEquals((int)h1.nanEntries(), (int)1);
        Assert.assertEquals((int)h2.nanEntries(), (int)1);
        Assert.assertEquals((int)h3.nanEntries(), (int)1);
        AidaTestCase.assertEqualsDouble(mean, h1.mean(), 0.0);
        AidaTestCase.assertEqualsDouble(rms, h1.rms(), 0.0);
        Assert.assertEquals((int)entries, (int)h1.entries());
        AidaTestCase.assertEqualsDouble(meanX2, h2.meanX(), 0.0);
        AidaTestCase.assertEqualsDouble(meanY2, h2.meanY(), 0.0);
        AidaTestCase.assertEqualsDouble(rmsX2, h2.rmsX(), 0.0);
        AidaTestCase.assertEqualsDouble(rmsY2, h2.rmsY(), 0.0);
        Assert.assertEquals((int)entries2, (int)h2.entries());
        AidaTestCase.assertEqualsDouble(meanX3, h3.meanX(), 0.0);
        AidaTestCase.assertEqualsDouble(meanY3, h3.meanY(), 0.0);
        AidaTestCase.assertEqualsDouble(meanZ3, h3.meanZ(), 0.0);
        AidaTestCase.assertEqualsDouble(rmsX3, h3.rmsX(), 0.0);
        AidaTestCase.assertEqualsDouble(rmsY3, h3.rmsY(), 0.0);
        AidaTestCase.assertEqualsDouble(rmsZ3, h3.rmsZ(), 0.0);
        Assert.assertEquals((int)entries3, (int)h3.entries());
    }

    private void createHistograms(IHistogramFactory histogramFactory, ITree tree) {
        int i;
        tree.mkdir("hist");
        tree.cd("hist");
        IHistogram1D h1 = histogramFactory.createHistogram1D(this.hist1DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge);
        IHistogram2D h2 = histogramFactory.createHistogram2D(this.hist2DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge);
        IHistogram3D h3 = histogramFactory.createHistogram3D(this.hist3DTitle, this.xbins, this.xLowerEdge, this.xUpperEdge, this.ybins, this.yLowerEdge, this.yUpperEdge, this.zbins, this.zLowerEdge, this.zUpperEdge);
        IAxis xAxis = h1.axis();
        IAxis yAxis = h2.yAxis();
        IAxis zAxis = h3.zAxis();
        int xbins = xAxis.bins();
        int ybins = yAxis.bins();
        int zbins = zAxis.bins();
        double[] xVarAxis = new double[xbins + 1];
        double[] yVarAxis = new double[ybins + 1];
        double[] zVarAxis = new double[zbins + 1];
        for (i = 0; i < xbins; ++i) {
            xVarAxis[i] = xAxis.binLowerEdge(i);
        }
        xVarAxis[xbins] = xAxis.upperEdge();
        for (i = 0; i < ybins; ++i) {
            yVarAxis[i] = yAxis.binLowerEdge(i);
        }
        yVarAxis[ybins] = yAxis.upperEdge();
        for (i = 0; i < zbins; ++i) {
            zVarAxis[i] = zAxis.binLowerEdge(i);
        }
        zVarAxis[zbins] = zAxis.upperEdge();
    }

    private void fillHistograms(ITree tree1) {
        tree1.cd("/hist");
        IHistogram1D h1 = (IHistogram1D)tree1.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)tree1.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)tree1.find(this.hist3DTitle);
        Random r = this.getRandomNumberGenerator();
        for (int i = 0; i < 10 * this.nEntries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w > r.nextDouble()) {
                h1.fill(xval, w);
                h2.fill(xval, yval, w);
                h3.fill(xval, yval, zval, w);
                continue;
            }
            h1.fill(xval);
            h2.fill(xval, yval);
            h3.fill(xval, yval, zval);
        }
    }

    private void fillHistograms(ITree tree1, ITree tree2) {
        tree1.cd("/hist");
        IHistogram1D h1 = (IHistogram1D)tree1.find(this.hist1DTitle);
        IHistogram2D h2 = (IHistogram2D)tree1.find(this.hist2DTitle);
        IHistogram3D h3 = (IHistogram3D)tree1.find(this.hist3DTitle);
        tree2.cd("/hist");
        IHistogram1D h1Var = (IHistogram1D)tree2.find(this.hist1DTitle);
        IHistogram2D h2Var = (IHistogram2D)tree2.find(this.hist2DTitle);
        IHistogram3D h3Var = (IHistogram3D)tree2.find(this.hist3DTitle);
        Random r = this.getRandomNumberGenerator();
        for (int i = 0; i < 10 * this.nEntries; ++i) {
            double xval = r.nextGaussian();
            double yval = r.nextGaussian();
            double zval = r.nextGaussian();
            double w = r.nextDouble();
            if (w > r.nextDouble()) {
                h1.fill(xval, w);
                h2.fill(xval, yval, w);
                h3.fill(xval, yval, zval, w);
                h1Var.fill(xval, w);
                h2Var.fill(xval, yval, w);
                h3Var.fill(xval, yval, zval, w);
                continue;
            }
            h1.fill(xval);
            h2.fill(xval, yval);
            h3.fill(xval, yval, zval);
            h1Var.fill(xval);
            h2Var.fill(xval, yval);
            h3Var.fill(xval, yval, zval);
        }
    }
}

