/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.xml.MakeAllXML;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Main {
    @Argument(required=true, usage="Input (.ser) File")
    private File file;
    @Option(name="-level", aliases={"-l"}, usage="Conversion level")
    private int level;
    @Option(name="-verbose", aliases={"-v"}, usage="Turn on verbose output")
    private boolean verbose;
    @Option(name="-csc", aliases={"-c"}, usage="CSC name (e.g. CCCamera, MTCamera, ATCamera)")
    private String cscName;
    @Option(name="-map", aliases={"-m"}, usage="Use alternate mapping file")
    private File mappingFile;
    @Option(name="-output", aliases={"-o"}, usage="Output file name ")
    private String outputFileName;
    @Option(name="-settingsApplied", aliases={"-s"}, usage="Generate settingsApplied ")
    private boolean generateSettingsApplied;
    @Option(name="-options", aliases={"-f"}, usage="Fiole to read options from")
    private File optionsFile;
    private String subsystemName;
    private String componentName;

    public static void main(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, SAXException, XPathExpressionException {
        new Main().doMain(args);
    }

    private void doMain(String[] args) throws IOException, FileNotFoundException, ClassNotFoundException, ParserConfigurationException, TransformerException, SAXException, XPathExpressionException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            Mapping mapping = Main.createMapping(this.mappingFile);
            if (this.optionsFile != null) {
                int i;
                this.outputFileName = "/home/tonyj/projects/lsst/ocs-ccs/ts_xml/sal_interfaces/CCCamera/CCCamera_Telemetry.xml";
                this.cscName = "CCCamera";
                XMLMaker2 maker = new XMLMaker2(false);
                Document document = maker.createDocument(XMLMaker2.SALType.TELEMETRY);
                File file1 = new File("src/main/resources/org/lsst/ccs/subsystem/ocsbridge/sim/comcam-fcs-status-dictionary.ser");
                StatusDataProviderDictionary dictionary1 = Main.readInputFile(file1);
                maker.addXMLFromMonitoringDictionary(document, dictionary1, "CCCamera", "fcs", 0, mapping);
                File file1a = new File("src/main/resources/org/lsst/ccs/subsystem/ocsbridge/sim/comcam-bonn-shutter-status-dictionary.ser");
                StatusDataProviderDictionary dictionary1a = Main.readInputFile(file1a);
                maker.addXMLFromMonitoringDictionary(document, dictionary1a, "CCCamera", "bonn_shutter", 1, mapping);
                File file2 = new File("src/main/resources/org/lsst/ccs/subsystem/ocsbridge/sim/comcam-daq-monitor-status-dictionary.ser");
                StatusDataProviderDictionary dictionary2 = Main.readInputFile(file2);
                maker.addXMLFromMonitoringDictionary(document, dictionary2, "CCCamera", "daq_monitor", 1, mapping);
                File file3 = new File("src/main/resources/org/lsst/ccs/subsystem/ocsbridge/sim/comcam-rebpower-status-dictionary.ser");
                StatusDataProviderDictionary dictionary3 = Main.readInputFile(file3);
                maker.addXMLFromMonitoringDictionary(document, dictionary3, "CCCamera", "rebpower", 1, mapping);
                File file4 = new File("src/main/resources/org/lsst/ccs/subsystem/ocsbridge/sim/comcam-vacuum-status-dictionary.ser");
                StatusDataProviderDictionary dictionary4 = Main.readInputFile(file4);
                maker.addXMLFromMonitoringDictionary(document, dictionary4, "CCCamera", "vacuum", 1, mapping);
                File file5 = new File("src/main/resources/org/lsst/ccs/subsystem/ocsbridge/sim/comcam-quadbox-status-dictionary.ser");
                StatusDataProviderDictionary dictionary5 = Main.readInputFile(file5);
                maker.addXMLFromMonitoringDictionary(document, dictionary5, "CCCamera", "quadbox", 1, mapping);
                File file6 = new File("src/main/resources/org/lsst/ccs/subsystem/ocsbridge/sim/comcam-fp-status-dictionary.ser");
                StatusDataProviderDictionary dictionary6 = Main.readInputFile(file6);
                maker.addXMLFromMonitoringDictionary(document, dictionary6, "CCCamera", "focal_plane", 1, mapping);
                maker.writeXML(new StreamResult(new File(this.outputFileName)), document);
                System.out.println("Wrote " + this.outputFileName);
                String settingsApplideOutputFileName = "/home/tonyj/projects/lsst/ocs-ccs/ts_xml/sal_interfaces/CCCamera/CCCamera_Events.xml";
                Document settingsAppliedDocument = maker.createDocument(XMLMaker2.SALType.SETTINGS_APPLIED);
                maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary1, "CCCamera", "fcs", 1, mapping);
                maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary1a, "CCCamera", "bonn_shutter", 1, mapping);
                maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary2, "CCCamera", "daq_monitor", 1, mapping);
                maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary3, "CCCamera", "rebpower", 1, mapping);
                maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary4, "CCCamera", "vacuum", 1, mapping);
                maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary5, "CCCamera", "quadbox", 1, mapping);
                maker.addXMLFromConfigDictionary(settingsAppliedDocument, dictionary6, "CCCamera", "focal_plane", 1, mapping);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new File(settingsApplideOutputFileName));
                XPath xp = XPathFactory.newInstance().newXPath();
                NodeList nl = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
                for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                    Node node = nl.item(i2);
                    node.getParentNode().removeChild(node);
                }
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int startIndex = 0;
                int endIndex = 0;
                for (i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (!(node instanceof Comment)) continue;
                    Comment comment = (Comment)node;
                    if (comment.getData().trim().startsWith("SETTINGSAPPLIED")) {
                        startIndex = i;
                        continue;
                    }
                    if (!comment.getData().trim().startsWith("ENDSETTINGSAPPLIED")) continue;
                    endIndex = i;
                }
                for (i = startIndex + 1; i < endIndex; ++i) {
                    root.removeChild(childNodes.item(startIndex).getNextSibling());
                }
                Node nextSibling = childNodes.item(startIndex).getNextSibling();
                NodeList replacementNodes = settingsAppliedDocument.getDocumentElement().getChildNodes();
                for (int i3 = 0; i3 < replacementNodes.getLength(); ++i3) {
                    Node newNode = doc.importNode(replacementNodes.item(i3), true);
                    root.insertBefore(newNode, nextSibling);
                }
                maker.writeXML(new StreamResult(new File(settingsApplideOutputFileName)), doc);
                System.out.println("Wrote " + settingsApplideOutputFileName);
            } else {
                Document document;
                StatusDataProviderDictionary readObject = Main.readInputFile(this.file);
                if (this.verbose) {
                    System.out.println(readObject.getClass().getTypeName());
                }
                if (this.outputFileName == null) {
                    String inputFileName = this.file.getName();
                    this.outputFileName = inputFileName.endsWith(".ser") ? inputFileName.replace(".ser", ".xml") : inputFileName + ".xml";
                    if (this.generateSettingsApplied) {
                        this.outputFileName = this.outputFileName.replace(".xml", "SettingsApplied.xml");
                    }
                }
                XMLMaker2 maker = new XMLMaker2(this.verbose);
                if (readObject instanceof StatusDataProviderDictionary) {
                    StatusDataProviderDictionary dictionary = readObject;
                    this.computeSubsystemAndComponentNames(dictionary.getOriginAgentInfo(), this.cscName);
                    document = this.generateSettingsApplied ? maker.makeXMLFromConfigDictionary(dictionary, this.subsystemName, this.componentName, this.level, mapping) : maker.makeXMLFromDataProviderDictionary(dictionary, this.subsystemName, this.componentName, this.level, mapping);
                } else {
                    throw new IllegalArgumentException("Invalid .ser file, containts " + readObject.getClass());
                }
                maker.writeXML(new StreamResult(new File(this.outputFileName)), document);
                System.out.println("Wrote " + this.outputFileName);
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java XMLMaker [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
        }
    }

    static StatusDataProviderDictionary readFromPath(String path) throws IOException, ClassNotFoundException {
        try (InputStream in = MakeAllXML.class.getResourceAsStream("/org/lsst/ccs/subsystem/ocsbridge/sim/" + path);){
            if (in == null) {
                throw new IOException("Path not found " + path);
            }
            StatusDataProviderDictionary statusDataProviderDictionary = Main.readInputStream(in);
            return statusDataProviderDictionary;
        }
    }

    static StatusDataProviderDictionary readInputFile(File inputFile) throws IOException, ClassNotFoundException {
        try (FileInputStream fis = new FileInputStream(inputFile);){
            StatusDataProviderDictionary statusDataProviderDictionary = Main.readInputStream(fis);
            return statusDataProviderDictionary;
        }
    }

    /*
     * Exception decompiling
     */
    static StatusDataProviderDictionary readInputStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void computeSubsystemAndComponentNames(AgentInfo agentInfo, String cscName) {
        String subsystemAndComponent = agentInfo.toString().split(":")[0];
        this.subsystemName = "";
        this.componentName = "";
        if (cscName != null) {
            this.subsystemName = cscName;
            this.componentName = subsystemAndComponent;
        } else if (subsystemAndComponent.contains("comcam-")) {
            this.subsystemName = "CCCamera";
            this.componentName = subsystemAndComponent.replace("comcam-", "").trim();
        } else {
            this.subsystemName = "MTCamera";
            this.componentName = subsystemAndComponent;
        }
        if (this.verbose) {
            System.out.println(agentInfo);
            System.out.println(subsystemAndComponent);
            System.out.println(" Subsystem  Name " + this.subsystemName + " Component Name " + this.componentName);
        }
    }

    static Mapping createMapping(File mappingFile) throws IOException {
        Mapping mapping;
        if (mappingFile == null) {
            mapping = Mapping.defaultMapping();
        } else {
            try (FileInputStream in = new FileInputStream(mappingFile);){
                mapping = new Mapping(in);
            }
        }
        return mapping;
    }
}

