/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.QueryCondition;
import DDS.StringSeqHolder;
import org.opensplice.dds.dcps.DataReaderImpl;
import org.opensplice.dds.dcps.DataReaderViewImpl;
import org.opensplice.dds.dcps.QueryConditionBase;
import org.opensplice.dds.dcps.ReportStack;

public class QueryConditionImpl
extends QueryConditionBase
implements QueryCondition {
    private static final long serialVersionUID = 6576466365353996218L;
    private String expression = null;
    private String[] parameters = null;

    protected QueryConditionImpl() {
    }

    protected int init(DataReaderImpl reader, int sample_states, int view_states, int instance_states, String query_expression, String[] query_parameters) {
        int result = 0;
        assert (reader != null);
        assert (query_expression != null);
        long uReader = reader.get_user_object();
        if (uReader != 0L) {
            long uQuery;
            this.expression = new String(query_expression);
            if (query_parameters != null) {
                int len = query_parameters.length;
                this.parameters = new String[len];
                for (int i = 0; i < len; ++i) {
                    this.parameters[i] = new String(query_parameters[i]);
                }
            }
            result = (uQuery = this.jniQueryConditionNew(uReader, this, sample_states, view_states, instance_states, query_expression, query_parameters)) != 0L ? this.init(reader, sample_states, view_states, instance_states, uQuery) : 1;
        } else {
            result = 9;
        }
        return result;
    }

    protected int init(DataReaderViewImpl view, int sample_states, int view_states, int instance_states, String query_expression, String[] query_parameters) {
        int result = 0;
        assert (view != null);
        assert (query_expression != null);
        long uView = view.get_user_object();
        if (uView != 0L) {
            long uQuery;
            this.expression = new String(query_expression);
            if (query_parameters != null) {
                int len = query_parameters.length;
                this.parameters = new String[len];
                for (int i = 0; i < len; ++i) {
                    this.parameters[i] = new String(query_parameters[i]);
                }
            }
            result = (uQuery = this.jniQueryConditionNew(uView, this, sample_states, view_states, instance_states, query_expression, query_parameters)) != 0L ? this.init(view, sample_states, view_states, instance_states, uQuery) : 1;
        } else {
            result = 9;
        }
        return result;
    }

    @Override
    public String get_query_expression() {
        return this.expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get_query_parameters(StringSeqHolder query_parameters) {
        int len = 0;
        int result = 0;
        ReportStack.start();
        if (query_parameters == null) {
            result = 3;
            ReportStack.report(result, "query_parameters 'null' is invalid.");
        } else {
            QueryConditionImpl queryConditionImpl = this;
            synchronized (queryConditionImpl) {
                if (this.parameters != null) {
                    len = this.parameters.length;
                }
                query_parameters.value = new String[len];
                for (int i = 0; i < len; ++i) {
                    query_parameters.value[i] = new String(this.parameters[i]);
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int set_query_parameters(String[] query_parameters) {
        long uQuery = 0L;
        int result = 0;
        ReportStack.start();
        QueryConditionImpl queryConditionImpl = this;
        synchronized (queryConditionImpl) {
            uQuery = this.get_user_object();
            if (uQuery != 0L) {
                if (query_parameters != null) {
                    int len = query_parameters.length;
                    this.parameters = new String[len];
                    for (int i = 0; i < len; ++i) {
                        this.parameters[i] = new String(query_parameters[i]);
                    }
                    result = this.jniSetQueryParameters(uQuery, query_parameters);
                } else {
                    result = 3;
                    ReportStack.report(result, "query_parameters 'null' is invalid.");
                }
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    private native long jniQueryConditionNew(long var1, Object var3, int var4, int var5, int var6, String var7, String[] var8);

    private native int jniQueryConditionFree(long var1);

    private native int jniSetQueryParameters(long var1, String[] var3);
}

